/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.BIRTContainer");
dojo.require("dijit._Widget");
dojo.require("dijit._Templated");
dojo.require("dijit._Container");



 dojo.declare(
	'cosmos.widget.BIRTContainer',
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
		templatePath:dojo.moduleUrl("cosmos.widget", "html/BIRTContainer.html"),
		widgetClass:'cosmos:BIRTContainer',
		widgetId: "birtcontainer",
		// width
		width : "100%",
		// height
		height : "400",
		content_provider: "",
		postCreate: function(){
			//call superclass
			cosmos.widget.BIRTContainer.superclass.postCreate.apply(this, arguments);
			if (this.store instanceof dojo.data.ItemFileWriteStore){
				this.refreshContent(this.store._jsonData);
			}
//			dojo.subscribe(this.subscribe, this, this.refreshContent);	
			
		},		
		URLEncode: function(sStr) {
		    return escape(sStr)
       			.replace(/\+/g, '%2B')
          			.replace(/\"/g,'%22')
             			.replace(/\'/g, '%27');
  		},			
	    refreshContent:function(message) {
	    	if (typeof(message) != 'undefined'){
		  	//should add a javascript method that will render itself and make a call
			//back to the server.  It will get the context from a queue.			
				type = this.URLEncode(message.reportId);	
				datasource = this.URLEncode(message.datasource);	
			}
			//make REST call to get content data
	    	if ((typeof(datasource) != 'undefined') && (typeof(type) != 'undefined')){
			dojo.xhrGet({
					changeit : this.changeit,
					widgetId: this.widgetId,
					url: this.reportHandler+"&type="+type+"&datasource="+datasource,    
			        handleAs: "json",
			        handle: function(response, ioArgs){
			                //This function handles the response.
			                //Inside this function, the "this" variable
			                //will be the object used as the argument to the dojo.xhrGet() call.
			                if(response instanceof Error){
			                        if(response.dojoType == "cancel"){
			                                //The request was canceled by some other JavaScript code.
			                                console.debug("Request canceled.");
			                        }else if(response.dojoType == "timeout"){
			                                //The request took over 5 seconds to complete.
			                                console.debug("Request timed out.");
			                        }else{
			                                //Some other error happened.
			                                console.error(response);
			                        }
			                }else{
								this.changeit(response, this.widgetId);						 		
			                }
			                //If you think there could be other callback handlers registered with this deferred, then
			                //return response to propagate the same response to other callback handlers. Otherwise,
			                //the error callbacks may be called in the success case.
			                return response;
			        }
			});
			}
			else{
			//reset page
				this.changeit(this.blankPath, this.widgetId);
			}
	    },
		changeit:function(url, id){
  			document.getElementById(id).src=url;
		},
	    
		// definitions
		blankPath:dojo.moduleUrl("cosmos.widget", "html/blank.html")
	}
);

dojo.declare(
	// class
	"cosmos.widget.ReportMenu",
	// superclass	
	[cosmos.widget.ContextMenu],
	{
		widgetClass:'cosmos:ReportMenu',
		constructor: function(params){
			dojo.mixin(this,params);
		},
		createContextMenu: function(menu, store, className){
			//check for specific node class
			this.populateMenu(menu, store, className);
		},
		populateMenu:function(menu, store, className){
			dojo.xhrGet({
					url: this.handler+"&value="+store.item.classification,  
					value: this.value,
					srcNodeRef: this.srcNodeRef,
					reportChooser: this,
					publish: this.publish,  
			        handleAs: "json",
			        handle: function(response, ioArgs){
			                //This function handles the response.
			                //Inside this function, the "this" variable
			                //will be the object used as the argument to the dojo.xhrGet() call.
			                if(response instanceof Error){
			                        if(response.dojoType == "cancel"){
			                                //The request was canceled by some other JavaScript code.
			                                console.debug("Request canceled.");
			                        }else if(response.dojoType == "timeout"){
			                                //The request took over 5 seconds to complete.
			                                console.debug("Request timed out.");
			                        }else{
			                                //Some other error happened.
			                                console.error(response);
			                        }
			                }else{
								for (y=0;y < response.length;y++){
									var responseObj = response[y];
									menu.addChild(new dijit.MenuItem({publish: this.publish,onClick:function(){
											var params= new Array();
											params.store = store.item;
											params.store.reportId = responseObj.value;
											params.nodeClass = store.item.nodeClass;
											if (typeof(this.publish) != 'undefined'){
													for (i=0;i < this.publish.length;i++){
														dojo.publish(this.publish[i], [{contextMap:params, store:params.store}]);
										 			}
								 			}	    
									},
									label:responseObj.caption
									}));
			                					                			
		                		}
			                }
			                //If you think there could be other callback handlers registered with this deferred, then
			                //return response to propagate the same response to other callback handlers. Otherwise,
			                //the error callbacks may be called in the success case.
			                return response;
			        }
			});
	}
		}

);	
