/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.CMDBfDialog");
dojo.require("dijit.Dialog");
dojo.require("dijit.form.Button");
dojo.require("dojo.io.iframe");

dojo.declare(
	"cosmos.widget.CMDBfDialog",
	[dijit.Dialog],
	{
	 	title:"CMDBf Query Dialog",
	 	rows:12,
	 	cols:80,	 	
		labelCMDBfQuery:"Enter the query, or paste the query below.",
		createElement: function(parent,childTag){
			//helper function to create and append child element
			var child = document.createElement(childTag);			
			parent.appendChild(child);
			return child;		
		},
		postCreate: function(){		
			//construct content of dialog box
			var table = this.createElement(this.containerNode,"table");			
			var tr = this.createElement(table,"tr");			
			var td = this.createElement(tr,"td");			
			td.setAttribute("colspan","2");			
			var label = this.createElement(td,"label");
			label.appendChild(document.createTextNode(this.labelCMDBfQuery));
			tr = this.createElement(table,"tr");			
			td = this.createElement(tr,"td");			
			label = this.createElement(td,"label");
			label.appendChild(document.createTextNode("File:"));
			td = this.createElement(tr,"td");			

			tr = this.createElement(table,"tr");			
			td = this.createElement(tr,"td");			
			td = this.createElement(tr,"td");			
			this.cmdfQuery = this.createElement(td,"textarea");
			this.cmdfQuery.setAttribute("name","cmdbfQuery");
			this.cmdfQuery.setAttribute("rows",this.rows);
			this.cmdfQuery.setAttribute("cols",this.cols);
			tr = this.createElement(table,"tr");			
			td = this.createElement(tr,"td");			
			td = this.createElement(tr,"td");			
			div = this.createElement(td,"div");			
			div.setAttribute("style","background-color : #666666; text-align:right;padding:5px;");						
			
			//create dojo buttons instead of adding it to the template string.  This is required
			//so that dojo buttons are created instead of normal html buttons.
			var button = document.createElement("button");
			div.appendChild(button);
			new dijit.form.Button({type:"submit", label:"Submit"},button);
			button = document.createElement("button");
			div.appendChild(button);
			cancelButton = new dijit.form.Button({label:"Cancel",type:"cancel"},button);
			this.connect(cancelButton, "onClick", "onCancel");						
			this.connect(this, "onExecute", "submitQuery");			
			cosmos.widget.CMDBfDialog.superclass.postCreate.apply(this, arguments);
		},		
		submitQuery: function(){
			this.callback("query="+this.cmdfQuery.value+"&mdrepr="+this.epr);
		}		
	}
);


dojo.declare(
   "cosmos.widget.CreateQuery",
	// superclass	
	[],
	{
		constructor: function(params){
			dojo.mixin(this,params);
		},
		queryHandler:"",
		bindInput: function(data, callbackMethod){
		console.debug("EPR");
		console.debug(data);
			var builder = new cosmos.widget.CMDBfDialog({epr:data.epr,callback: callbackMethod});
			builder.show();		
		},
		render: function(input){
			return input;
		}
	}
); 
