/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.Navigator");
dojo.require("cosmos.widget.CMDBfDialog");
dojo.require("dijit.Menu");
dojo.require("dijit.Tree");
dojo.require("dijit.TitlePane");
dojo.require("dijit.layout.ContentPane");

dojo.declare(
	// class
	"cosmos.widget.Navigator",

	// superclass	
	[dijit.Tree],
	
	// member variables/functions
	{
		widgetClass:'cosmos:Navigator',
	    treeHandler: function(message){
		  if (message.event != 'execute') {
    		return;
  			}
			if (typeof(this.publish) != 'undefined'){
					for (i=0;i < this.publish.length;i++){
					 	if (message.node.item.store){
					 		//dojo bug: tree items can not contain array properties.  Need to evaluate 
					 		//strings to complex array objects
					 	    var contextMap =  message.node.item;
					 	    contextMap.store = 	dojo.fromJson(message.node.item.store);					 	    
							dojo.publish(this.publish[i], [{contextMap:contextMap, store:contextMap.store}]);
						}
						else{
							dojo.publish(this.publish[i], [{contextMap:message.node.item, store:message.node}]);
						}
		 			}
 			}	    
	    },
		addChildIcon: function(el){
			var value = el.label;
		    if ((el.item.nodeClass) && (this.UIContext)){
				initParam = this.UIContext.getStyleProperties(el.item.nodeClass);			
				if (initParam){
					value="<img src=\""+initParam.icon+"\"/>"+ el.label;
					}
		    }
			el.labelNode.innerHTML=value;	
			//check to see if this node has an expand query
			if (typeof(el.item['expandQuery'])!='undefined')
				el.makeFolder();
			dojo.connect(el,"addChild", this, "addChildIcon");
		},
		createContextMenu: function(e){
			var menu = this.menu;
			this.menu.getChildren().forEach(function(i){menu.removeChild(i);});
			var tn = this._domElement2TreeNode(e.target);
			var classes = [this.widgetClass+" "+tn.item.nodeClass,tn.item.nodeClass,this.widgetClass];
			var className = null;
			var contextMenuFactory = null
			for (y=0;y < classes.length;y++){			
				contextMenuFactory = this.UIContext.createMenu(classes[y], this, tn.item);
				if (contextMenuFactory != null){
					break;
				}
			}
			
			if (contextMenuFactory != null)
				contextMenuFactory.createContextMenu(this.menu,tn,className); 			
		},
		postMixInProperties: function(){
			//call superclass
		  	dojo.connect(this, "addChild", this, this.addChildIcon);
		  	
			var cell = document.createElement("ul");
			cell.setAttribute("style", "display:none;");
			cell.setAttribute("id", this.id+"_menu");

			this.parentWidget.domNode.appendChild(cell);

			this.menu = new dijit.Menu({}, cell);
			cosmos.widget.Navigator.superclass.postMixInProperties.apply(this, arguments);
		},
		postCreate: function(){
			// when we right-click anywhere on the tree, make sure we open the menu		  	
			this.menu.bindDomNode(this.domNode);				
			dojo.connect(this.menu, "_openMyself", this, this.createContextMenu);
			this._controller = new cosmos.widget.DataController(
				{
					UIContext:this.UIContext,	
					store: this.store,
					treeId: this.id,
					query: this.query,
					childrenAttr: this.childrenAttr
				}
			);
			
			this.postCreateExtend();
		  	dojo.subscribe(this.id, this, this.treeHandler);
		},
		postCreateExtend: function(){
			this.containerNode = this.domNode;
	
			// make template for container node (we will clone this and insert it into
			// any nodes that have children)
			var div = document.createElement('div');
			div.style.display = 'none';
			div.className = "dijitTreeContainer";	
			dijit.wai.setAttr(div, "waiRole", "role", "presentation");
			this.containerNodeTemplate = div;		
	
			this._publish("afterTreeCreate");
		},
		addTreeNode:function(newItem, parent){
			if (typeof(parent) == 'undefined')
				parent = this.treeNode.item;
			try{
				if (dojo.isArray(newItem)) {
					for (var x=0; x < newItem.length; x++){
						this.addTreeNode(newItem[x], parent);			   
					}
				}
				else{		
					var parentObject = this.store.newItem(newItem, {parent:parent,attribute:'children'});
					
					//need to expand parent node
					var parentNode = this._controller._itemNodeMap[this.store.getIdentity(parent)];
					this._controller._expand(parentNode);
					
				}
			}catch(e){
				console.debug(e);
			}
		},	
		deleteTreeNode:function(treeNode){
			this.store.deleteItem(treeNode);
		}
		
	}
	
);


dojo.declare(
	"cosmos.widget.DataController",
	dijit._tree.DataController,
{
	// summary
	//		Controller for tree that hooks up to dojo.data

	_expand: function( node){
		var store = this.store;
		var getValue = this.store.getValue;
		
		if ((node.state == "UNCHECKED") &&(typeof(node.item['expandQuery']) != 'undefined')){
			// need to load all the children, and then expand
			var parentItem = node.item;
			var childItems = store.getValues(parentItem, this.childrenAttr);
	       		// still waiting for some or all of the items to load
	       		node.markProcessing();
			var _this = this;
			function onItem(citem){
				_waitCount = citem.length;
				dojo.forEach(citem, function(item){
					if(!store.isItemLoaded(item)){
		       				store.loadItem({item: item, onItem: function(item){	
				   				if(--_waitCount == 0){
									// all nodes have been loaded, send them to the tree
									node.unmarkProcessing();
									_this._onLoadAllItems(node, citem);
								}
							}
		       				
		       				});
		       			}
		       		}
		       		);
			}
		    if (this.UIContext){
				this.UIContext.submitQuery({queryObject:parentItem, item:parentItem, onItem:onItem, queryProp:"expandQuery"});			
		    }			
		}
		else{
			cosmos.widget.DataController.superclass._expand.apply(this, arguments);			
		}
	}
}
);


dojo.declare(
   "cosmos.widget.QueryMenu",
	// superclass	
	[],
	{
		constructor: function(params){
			dojo.mixin(this,params);
		},
		widgetClass:'cosmos:QueryMenu',
		cmdbfQuery:null,
		createContextMenu: function(menu, store, className){
			//check for specific node class
			this.populateMenu(menu, store, className);
		},
		populateMenu:function(menu, store, className){
			var queryMenu = this;			
			menu.addChild(new dijit.MenuItem({item:this,UIContext:this.UIContext, store:store, sourceObject: this.sourceObject,onClick:function(){
				var sourceObject = this.sourceObject; 
				var store = this.store;
				this.UIContext.submitQuery({queryObject:queryMenu, item:store.item, onItem:function(items){
					sourceObject.addTreeNode(items, store.item);
					}, queryProp:"query"});			
			},
			label:this.label
			}));
		}
	}
);

dojo.declare(
   "cosmos.widget.RemoveMenu",
	// superclass	
	[],
	{
		widgetClass:'cosmos:RemoveMenu',
		constructor: function(params){
			dojo.mixin(this,params);
		},
		createContextMenu: function(menu, store, className){
			//check for specific node class
			this.populateMenu(menu, store, className);
		},
		populateMenu:function(menu, store, className){
			menu.addChild(new dijit.MenuItem({onClick:function(){
				store.tree.deleteTreeNode(store.item);
			},
			label:"Remove Query"
			}));
		}
	}
); 