/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.PropertiesContainer");
dojo.require("dijit.layout.ContentPane");
dojo.require("dijit.TitlePane");


dojo.declare(
	// class
	"cosmos.widget.SimplePropertiesTable",
	// superclass	
	[dijit.TitlePane],
	
	// member variables/functions
	{
		tableLabelNodeClass:"tplabel",
		widgetClass:'cosmos:SimplePropertiesTable',
		subscribeHandler:null,
		store: null,
		postCreate: function(){
			cosmos.widget.SimplePropertiesTable.superclass.postCreate.apply(this, arguments);			
			//call superclass		
//			this.subscribeHandler = dojo.subscribe(this.subscribe, this, this.refreshContainer);
			if (this.store instanceof dojo.data.ItemFileWriteStore){
				this.store = this.store._jsonData;
				this.storeFunction(this.store);
			}
			else if ((typeof(this.store) != 'undefined') && (this.store != null)){		
				this.refreshContainer(this.store);
			}
		},
	    refreshContainer:function(message) {
	    	if (typeof(message.contextMap) != 'undefined'){
		  	//should add a javascript method that will render itself and make a call
			//back to the server.  It will get the context from a queue.
				resourceContext = message.contextMap.object;	
				resourceClass = message.contextMap.nodeClass;	
			}
			//make REST call to get content data
	    	if (typeof(resourceContext) != 'undefined'){
				dojo.xhrGet({
						url: this.handler+"?context="+resourceContext,
						resourceClass:resourceClass,    
						propContainer:this,
				        handleAs: "json",
				        handle: function(response, ioArgs){
				                //This function handles the response.
				                //Inside this function, the "this" variable
				                //will be the object used as the argument to the dojo.xhrGet() call.
				                if(response instanceof Error){
				                        if(response.dojoType == "cancel"){
				                                //The request was canceled by some other JavaScript code.
				                                console.debug("Request canceled.");
				                        }else if(response.dojoType == "timeout"){
				                                //The request took over 5 seconds to complete.
				                                console.debug("Request timed out.");
				                        }else{
				                                //Some other error happened.
				                                console.error(response);
				                        }
				                }else{
									this.propContainer.storeFunction(response, resourceClass);
				                }
				                //If you think there could be other callback handlers registered with this deferred, then
				                //return response to propagate the same response to other callback handlers. Otherwise,
				                //the error callbacks may be called in the success case.
				                return response;
				        }
				});			    	
	    	
			}
	    },
	    setTableLabelClass:function(value){
	      this.tableLabelNodeClass = value;
	    },
	    destroy:function(){
	    try{
				dojo.unsubscribe(this.subscribeHandler);
		      if (typeof(this.containers) != 'undefined'){
				  var len = this.containers.length;
				  //clear the div element
				  for(var j = 0; j < len; j++)
		   		  {
		   		  	this.containers[j].destroy();
		   		  }
		   		}
				cosmos.widget.SimplePropertiesTable.superclass.destroy.apply(this, arguments);
			}catch(e){
				console.debug(e);
			}			
		   		
	    },
	    storeFunction:function(data, resourceClass){
	      if (typeof(this.containers) != 'undefined'){
			  var len = this.containers.length;
			  //clear the div element
			  for(var j = 0; j < len; j++)
	   		  {
	   		  	this.containers[j].destroy();
	   		  }
	   		}
			this.containers = new Array();
			customWidget = null;
			var div = null;
			if (resourceClass){			
				var styleProp = this.UIContext.getStyleProperties(resourceClass);
				div = document.createElement("div");	
				this.containerNode.appendChild(div);
				try{
					var containerNode = this.containerNode;
					if (!(this.UIContext.createWidget(styleProp, data, function(widget){
							if (widget == null){
								continerNode.removeChild(div);							
							}
						}, div))){
						customWidget = null;
					}				
				}catch(e){
					customWidget = null;
					this.containerNode.removeChild(div);
				}
			
			}
			if (customWidget != null){
				this.containers.push(customWidget);
				}
			else{
				if (div != null){
					this.containerNode.removeChild(div);
				}
	        	this.createContainerWidget(data, this.containerNode, "pcRoot", 0);
	        }
	    },
	    createContainerWidget:function(data, parent, containerId, indent){
			if (typeof(data) != 'undefined'){
				var div = document.createElement("div");			
				parent.appendChild(div);
				var table = document.createElement("table");
				table.setAttribute("cellpadding","0");
				table.setAttribute("class","simpletable");
				table.setAttribute("cellspacing","0");
				table.setAttribute("width","100%");
				table.setAttribute("border","0");
				div.appendChild(table);
				var thead = document.createElement("thead");
				table.appendChild(thead);
				var tr = document.createElement("tr");
				thead.appendChild(tr);
				var th = document.createElement("th");
				tr.appendChild(th);
				th.setAttribute("align","center");
				th.appendChild(document.createTextNode("Name"));
				th = document.createElement("th");
				tr.appendChild(th);
				th.setAttribute("align","center");
				th.appendChild(document.createTextNode("Value"));
				var tbody = document.createElement("tbody");
				table.appendChild(tbody);
					if (data instanceof dojo.data.ItemFileWriteStore){
						data = data._jsonData;
					}
					for (i=0;i < data.length;i++){
						tr = document.createElement("tr");	
						tbody.appendChild(tr);
						td = document.createElement("td");	
						tr.appendChild(td);
						td.appendChild(document.createTextNode(data[i].name));
						td = document.createElement("td");	
						tr.appendChild(td);
						td.appendChild(document.createTextNode(data[i].value));
					}
				}
			
				if (this.propertyNodeClass) {
					dojo.html.addClass(this.propertyNode, this.propertyNodeClass);
				}
				
				
		}
		
	}
);

dojo.declare(
	// class
	"cosmos.widget.PropertiesContainer",
	// superclass	
	[cosmos.widget.SimplePropertiesTable],
	
	// member variables/functions
	{
		widgetClass:'cosmos:PropertiesContainer',
	    createContainerWidget:function(data, parent, containerId, indent){
			for (var i=0;i < data.length;i++){
				var div = document.createElement("div");			
				parent.appendChild(div);
				if ((typeof(this.UIContext) != "undefined") && (typeof(data[i].value)!="undefined")){
					var styleProp = this.UIContext.getStyleProperties(data[i].value.type);
				}
				if ((typeof(styleProp) != 'undefined') && (styleProp.clazz)){		
						div = document.createElement("div");			
						this.containerNode.appendChild(div);
						try{
							var containerNode = this.containerNode;
							if (!(this.UIContext.createWidget(data[i], data[i].value, function(widget){
									if (widget == null){
										continerNode.removeChild(div);							
									}
								}, div))){
								customWidget = null;
							}				
						}catch(e){
							customWidget = null;
							this.containerNode.removeChild(div);
						}
					}
				else{
					//render title pane drop down properties table					
					var properties = data[i].properties;
					if (typeof(data[i].properties) != 'undefined'){
						var propTable = document.createElement("table");
						div.appendChild(propTable);
						this.containers.push(new cosmos.widget.Property({store: data[i].properties, indent:((indent+1)*20)}, propTable));
					}
					var lc = new dijit.TitlePane({indent:(indent*20),open:false, sizeMin:33, sizeShare:33, title:data[i].name, labelNodeClass:this.tableLabelNodeClass, containerNodeClass:"tpcontent"}, div);
					this.containers.push(lc);
					if (typeof(data[i].childProperties) != 'undefined')					
						this.createContainerWidget(data[i].childProperties, lc.containerNode, containerId+i+"_n_", indent+1);
					//to do render simple table
				}
			}	    
	    }
	}
);

dojo.declare("cosmos.widget.Property", 
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
    indent: 0,
	templateString:"<div dojoAttachPoint=\"propertyNode\" class=\"cosmosProperty\"></div>", 
	templateCssString:".cosmosProperty {font-size:0.8em;padding:2px;border:1px solid #ccc;	background: #ccc;margin-left:${this.indent}px}\n", 
	templateCssPath:dojo.moduleUrl("cosmos.widget", "templates/PropertyTemplate.css"),
	store:[],  
	postCreate:function () {
		if (this.store instanceof dojo.data.ItemFileWriteStore){
			this.store = this.store._jsonData;
		}
	    if (this.store){	        
			for (i=0;i < this.store.length;i++){
				p = document.createElement("div");	
				this.propertyNode.appendChild(p);
				p.appendChild(document.createTextNode(this.store[i].name+" : "+this.store[i].value));
			}
		}
	
		if (this.propertyNodeClass) {
			dojo.html.addClass(this.propertyNode, this.propertyNodeClass);
		}
		
	}
}
);