/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.WidgetContainer");
dojo.require("dijit._Widget");
dojo.require("dijit._Container");
dojo.require("dijit._Templated");

 dojo.declare(
	'cosmos.widget.WidgetContainer',
	[dijit._Widget, dijit._Container, dijit._Templated], 
	{
		widgetClass:'cosmos:WidgetContainer',
		templateString:"<div dojoAttachPoint=\"contentNode\">\n\t\t</div>\n",		
		childWidget: null,
		oldWidget: null,
		oldDiv: null,
		UIContext:null,
		attachPoint: null,
		postCreate: function(){
			//call superclass
			cosmos.widget.WidgetContainer.superclass.postCreate.apply(this, arguments);
		  	dojo.subscribe("initializeWidget", this, this.initWidget);				
			dojo.subscribe(this.attachPoint, this, this.updateContainer);
			
		},		
		setChildWidget: function(widget){
				this.oldWidget = widget;		
		},
		updateContainer: function(message){
			if ((this.contentNode.childNodes) && (this.contentNode.childNodes.length>0)) {
				var nodeLength = this.contentNode.childNodes.length;
				for (var x =0; x<nodeLength; x++)				
					this.contentNode.removeChild(this.contentNode.childNodes[0]);
			}
			if (this.oldWidget != null){
				this.oldWidget.destroy();
				this.oldWidget = null;
			}
		
	    	if (typeof(message.contextMap) != 'undefined'){
				resourceClass = message.contextMap.nodeClass;	
			}
		
	    	if (typeof(resourceClass) != 'undefined'){
				try{
					var styleProp = this.UIContext.context.getStyleProperties(this.attachPoint+" "+resourceClass);
					if ((typeof(styleProp) == 'undefined') || (!(styleProp)) || (!(styleProp.clazz))){
						styleProp = this.UIContext.context.getStyleProperties(this.attachPoint);
					}
					try{
						var contentNode = this.contentNode;
						this.oldDiv = document.createElement("div");
						this.contentNode.appendChild(this.oldDiv);
						var oldDiv = this.oldDiv;
						if ((styleProp)  && (typeof(styleProp) != 'undefined')){
							styleProp.parentWidget = this;
							if (!(this.UIContext.context.createWidget(styleProp, message.store, function(widget){
									if (widget == null){
										contentNode.removeChild(oldDiv);							
									}
								}, oldDiv))){
							}				
						}
					}catch(e){
						console.debug(e);
						this.contentNode.removeChild(oldDiv);
					}							
				}catch(e){
					console.debug(e);
				}
			}
	    },		
		initWidget: function(UIContext){
			if ((this.contentNode.childNodes) && (this.contentNode.childNodes.length>0)) {
				var nodeLength = this.contentNode.childNodes.length;
				for (var x =0; x<nodeLength; x++)				
					this.contentNode.removeChild(this.contentNode.childNodes[0]);
			}
			if (this.oldWidget != null){
				this.oldWidget.destroy();
				this.oldWidget = null;
			}
			this.UIContext = UIContext;		
			if (this.attachPoint != null){
				var styleProp = this.UIContext.context.getStyleProperties(this.attachPoint);
					try{
						var contentNode = this.contentNode;
						this.oldDiv = document.createElement("div");
						this.contentNode.appendChild(this.oldDiv);	
						if ((typeof(styleProp) != 'undefined') && (styleProp) && (styleProp.clazz)){
							styleProp.parentWidget = this;							
							var oldDiv = this.oldDiv;	
							if (!(this.UIContext.context.createWidget(styleProp, null, function(widget){
									if (widget == null){
										contentNode.removeChild(oldDiv);							
									}
								}, oldDiv))){
							}				
						}
					}catch(e){
						console.debug(e);
						this.contentNode.removeChild(this.oldDiv);
					}						
			}
	    }
	    
	}
);
