/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("mywidget.widget.End2End");
dojo.require("dijit._Widget");
dojo.require("dijit._Templated");
dojo.require("dijit._Container");

dojo.declare(
	// class
	"mywidget.widget.MinRequirement",
	// superclass	
	[dijit._Widget, dijit._Templated, dijit._Container], 
	
	// member variables/functions
	{
		processor:"",
		instructionSet:"",
		ram:"",
		size:"",
		sizeValue:"",
		clock:"",
		clockValue:"",
		instructionSetValue:"",
		templatePath:dojo.moduleUrl("mywidget.widget", "html/MinRequirement.html"),
		instructionIcon:dojo.moduleUrl("mywidget.widget", "img/options_obj.gif"),
		ramIcon:dojo.moduleUrl("mywidget.widget", "img/group.gif"),
		clockIcon:dojo.moduleUrl("mywidget.widget", "img/profile_obj.gif"),
	        templateCssString:".minrequirement table td{border:0px;} .header{	font-size: 10pt;	font-weight:bold;	color:red;}.header2{	font-size: 10pt;	font-weight:bold;	color:#999;}",
		postMixInProperties: function(args, fragment, parent){
			mywidget.widget.MinRequirement.superclass.postMixInProperties.apply(this, arguments);
			this.initWidget();	
		},		
	    initWidget:function(){		
					this.processor = this.data[0].name;
					this.instructionSet = this.data[0].childProperties[0].name;
					this.instructionSetValue = this.data[0].childProperties[0].properties[0].value;
					this.clock=this.data[0].childProperties[1].name;
					this.clockValue=this.data[0].childProperties[1].properties[1].value+this.data[0].childProperties[1].properties[0].value;
					this.ram=this.data[1].name;
					this.size=this.data[1].childProperties[0].name;
					this.sizeValue=this.data[1].childProperties[0].properties[0].value+this.data[1].childProperties[0].properties[1].value;
	    }
	}
);

//This demonstrates a query unit   
dojo.declare(
   "mywidget.widget.DatasourceQuery",
	// superclass	
	[],
	{
		constructor: function(params){
			dojo.mixin(this,params);
		},
		bindInput: function(data, callbackMethod){		
				callbackMethod("brokerepr="+data["brokerepr"]);
		},
		render: function(input){
			return input;
		}
	}
); 
   