<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%
/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
%>      
<jsp:useBean id="template" scope="request" class="org.eclipse.cosmos.dr.ps.common.Template"/>
 
<% template.init(session.getServletContext().getRealPath(template.getView()+"/css/widgetstyles.xml")); %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>COSMOS Web User Interface</title>

	<style type="text/css">
		@import "dojo/dojo/resources/dojo.css";
		@import "dojo/dijit/themes/tundra/tundra.css";
	</style>

<LINK REL=StyleSheet HREF="<%= template.getView()%>/css/styles.css" TYPE="text/css" MEDIA=screen>
<%= template.renderHeader(template.getView()+"/css/widgetstyles.xml") %>

<script>
dojo.require("mywidget.widget.*");
dojo.require("dijit.layout.SplitContainer");
dojo.require("dijit.layout.ContentPane");
dojo.require("dijit.TitlePane");
</script>


</head>
<body class="tundra">

		<table width="100%" border="0" cellspacing="0" cellpadding="0" class="wpsBannerEnclosure">

			<tr>
                      <td height="35" align="left" bgcolor="#F5F5F5"><img alt='Cosmos Data Visualization UI' title='Cosmos Data Visualization UI' src='views/cosmos/images/bannerLeft.gif'/></td>
                      <td height="35" align="right"  bgcolor="#F5F5F5"></td>
			</tr>
		</table>

	<div dojoType="dijit.layout.SplitContainer"
		orientation="horizontal"
		sizerWidth="10"
		activeSizing="false"
		class="container">
		<div dojoType="dijit.layout.ContentPane" sizeShare="30" sizeMin="20">
 			<div dojoType="dijit.TitlePane" title="&nbsp;&nbsp;Data Managers" class="navigator">
				<%= template.renderContent("nav") %>
 		    </div>
    	</div>

		<div dojoType="dijit.layout.SplitContainer"
			orientation="vertical"
			sizerWidth="10"
			activeSizing="false"
			class="container">
	
				<div class="detail" dojoType="dijit.TitlePane" title="&nbsp;&nbsp;Details" sizeShare="60" sizeMin="20">
					<%= template.renderContent("detail") %>
				</div>
				<div dojoType="dijit.layout.ContentPane" sizeShare="40" sizeMin="20">			
					<%= template.renderContent("properties") %>
				</div>								
    	</div>

	</div>
</body>
