/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.actions;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.operations.ISMLValidateOperation;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.actions.AbstractAction;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLRepositoryManager;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;

public class ValidateResourceAction
extends AbstractAction {
    private Map<String, Object> attributes = new Hashtable<String, Object>();

    public ValidateResourceAction() {
        this.attributes.put("attribute.environment", "value.environment.eclipse");
    }

    public void run(IAction action) {
        if (this.noValidSelection()) {
            return;
        }
        SMLValidationJob validate = new SMLValidationJob(SMLValidationMessages.validationJob);
        validate.setUser(true);
        validate.schedule();
    }

    private boolean runValidation(ISMLValidateOperation validationOperation, String inputType, String input) throws RepositoryOperationException {
        this.attributes.put("validation.input.type", inputType);
        this.attributes.put("validation.instance", input);
        validationOperation.setArguments(new Object[]{this.attributes});
        validationOperation.run();
        return validationOperation.getStatus();
    }

    private class SMLValidationJob
    extends Job {
        public SMLValidationJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ISMLRepository repository = SMLRepositoryManager.getRepository(ValidateResourceAction.this.getRootDirectory());
                ISMLValidateOperation validationOperation = (ISMLValidateOperation)repository.getOperation("org.eclipse.cosmos.rm.repository.provisional.operations.ISMLValidateOperation");
                List<String> smlifDocuments = ValidateResourceAction.this.getSmlifdocuments();
                ValidateResourceAction.this.attributes.put("validation.progress", monitor);
                ValidateResourceAction.this.attributes.put("validation.input.type", "value.sml.if");
                boolean status = true;
                try {
                    int smlifDocumentsCount = smlifDocuments.size();
                    monitor.beginTask(SMLValidationMessages.validationTask, 7 * (smlifDocumentsCount + 1));
                    int i = 0;
                    while (i < smlifDocumentsCount) {
                        status = ValidateResourceAction.this.runValidation(validationOperation, "value.sml.if", smlifDocuments.get(i)) && status;
                        ++i;
                    }
                    if (ValidateResourceAction.this.getSmlModelUnitPaths().length() > 0) {
                        status = ValidateResourceAction.this.runValidation(validationOperation, "value.sml.unit", ValidateResourceAction.this.getSmlModelUnitPaths()) && status;
                    } else {
                        monitor.worked(7);
                    }
                }
                catch (RepositoryOperationException roe) {
                    SMLCommonUtil.openErrorWithDetail(SMLValidationMessages.errorValidationTitle, SMLValidationMessages.errorValidation, roe);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
                final IWorkbench workbench = SMLPlugin.getDefault().getWorkbench();
                if (status) {
                    workbench.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLValidationMessages.confirmNoErrorTitle, (String)SMLValidationMessages.confirmNoError);
                        }
                    });
                } else {
                    workbench.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            try {
                                workbench.getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView");
                            }
                            catch (PartInitException partInitException) {
                                MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLValidationMessages.failedValidationTitle, (String)SMLValidationMessages.failedValidation);
                            }
                        }
                    });
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }
}

