/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLPage;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLCommonUtil {
    public static Node retrieveChildNode(Node parent, String uri, String localName) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (uri.equals(child.getNamespaceURI()) && localName.equals(child.getLocalName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static String retrieveTextNode(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node textNode = children.item(i);
            String currentText = null;
            if (textNode.getNodeType() == 3 && (currentText = textNode.getNodeValue()) != null && (currentText = currentText.trim()).length() > 0) {
                sb.append(currentText);
            }
            ++i;
        }
        StringTokenizer st = new StringTokenizer(sb.toString(), "\n");
        StringBuffer finalTextValue = new StringBuffer();
        while (st.hasMoreTokens()) {
            String currentLine = st.nextToken().trim();
            if (currentLine.length() <= 0) continue;
            if (finalTextValue.length() > 0) {
                finalTextValue.append(" ");
            }
            finalTextValue.append(currentLine);
        }
        return finalTextValue.toString();
    }

    public static Node nestedNodeRetrieval(Node node, String[][] nodeNames) {
        return SMLCommonUtil.nestedNodeRetrieval(node, nodeNames, false, true, null);
    }

    public static Node nestedNodeRetrieval(Node node, String[][] nodeNames, boolean create, boolean append, Node siblingToInsertBefore) {
        Node currentNode = node;
        int i = 0;
        while (i < nodeNames.length) {
            if (currentNode == null) {
                return null;
            }
            Node childNode = SMLCommonUtil.retrieveChildNode(currentNode, nodeNames[i][0], nodeNames[i][1]);
            if (childNode == null && create) {
                childNode = SMLCommonUtil.createFormattedElement(currentNode, nodeNames[i][0], nodeNames[i][1], append, siblingToInsertBefore);
            }
            currentNode = childNode;
            ++i;
        }
        return currentNode;
    }

    public static Node createElement(Node parentNode, String uri, String localName) {
        Element node = parentNode.getOwnerDocument().createElementNS(uri, localName);
        node.setPrefix(parentNode.getPrefix());
        parentNode.appendChild(node);
        return node;
    }

    public static Node createFormattedElement(Node parentNode, String uri, String localName, boolean append, Node siblingToInsertBefore) {
        Element childNode = null;
        Document ownerDocument = parentNode.getOwnerDocument();
        childNode = ownerDocument.createElementNS(uri, localName);
        childNode.setPrefix(parentNode.getPrefix());
        Node sibling = append ? parentNode.getLastChild() : siblingToInsertBefore;
        Node indentNode = null;
        while (sibling != null && sibling.getNodeType() != 1) {
            sibling = sibling.getPreviousSibling();
        }
        if (sibling != null && sibling.getNodeType() == 1 && SMLValidatorUtil.isWhitespace((Node)(indentNode = sibling.getPreviousSibling()))) {
            Node lastChildNode;
            if (append && SMLValidatorUtil.isWhitespace((Node)(lastChildNode = parentNode.getLastChild()))) {
                parentNode.removeChild(lastChildNode);
            }
            org.w3c.dom.Text indent = ownerDocument.createTextNode(indentNode.getNodeValue());
            if (append) {
                parentNode.appendChild(indent);
            } else {
                parentNode.insertBefore(indent, siblingToInsertBefore);
            }
        }
        if (append) {
            parentNode.appendChild(childNode);
        } else if (indentNode != null) {
            parentNode.insertBefore(childNode, indentNode.getNextSibling());
        } else {
            parentNode.insertBefore(childNode, siblingToInsertBefore);
        }
        Node parentIndent = parentNode.getPreviousSibling();
        if (append && SMLValidatorUtil.isWhitespace((Node)parentIndent)) {
            parentNode.insertBefore(ownerDocument.createTextNode(parentIndent.getNodeValue()), childNode.getNextSibling());
        }
        return childNode;
    }

    public static String[] retrieveAliases(Map<String, String[]> userDefinedAliases, ISMLDocument document) {
        String[] userAliases = userDefinedAliases.get(document.getMetadata().getId());
        userAliases = userAliases == null ? new String[]{} : userAliases;
        String[] fileAliases = document.getMetadata().getAliases();
        fileAliases = fileAliases == null ? new String[]{} : fileAliases;
        String[] finalAliases = new String[userAliases.length + fileAliases.length];
        System.arraycopy(userAliases, 0, finalAliases, 0, userAliases.length);
        System.arraycopy(fileAliases, 0, finalAliases, userAliases.length, fileAliases.length);
        return finalAliases;
    }

    public static void addURIValidator(final Text textField, final SMLPage page) {
        textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String baseURI = textField.getText();
                if (baseURI.equals("")) {
                    return;
                }
                String message = null;
                try {
                    new URI(baseURI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    message = NLS.bind((String)SMLMessages.errorInvalidBaseURIFormat, (Object)baseURI);
                }
                page.setErrorMessage(message);
            }
        });
    }

    public static void openErrorWithDetail(Shell parent, String title, String message, String cause) {
        class CustomErrorDialog
        extends ErrorDialog {
            private String cause;
            private static final int LIST_ITEM_COUNT = 7;
            private List list;
            private boolean isListDisplayed;
            private Clipboard clipboard;

            public CustomErrorDialog(Shell parentShell, int severity, String dialogTitle, String message, String cause) {
                super(parentShell, dialogTitle, cause == null ? null : message, (IStatus)new Status(severity, "org.eclipse.cosmos.rm.validation", severity, message, cause == null ? null : new Throwable(cause)), 7);
                this.cause = cause;
                this.isListDisplayed = false;
            }

            public void openErrorDialog() {
                this.open();
            }

            protected List createDropDownList(Composite parent) {
                if (this.isListDisplayed) {
                    this.isListDisplayed = false;
                    this.list.dispose();
                    return this.list;
                }
                this.isListDisplayed = true;
                this.list = new List(parent, 2818);
                if (this.cause != null) {
                    StringTokenizer st = new StringTokenizer(this.cause, "\n");
                    String indents = "";
                    boolean addedIndentation = false;
                    while (st.hasMoreTokens()) {
                        String currentToken = st.nextToken();
                        currentToken = currentToken.replace('\r', ' ');
                        currentToken = currentToken.trim();
                        if (!addedIndentation && currentToken.startsWith("at")) {
                            indents = String.valueOf(indents) + "  ";
                            addedIndentation = true;
                        } else if (addedIndentation && !currentToken.startsWith("at")) {
                            addedIndentation = false;
                        }
                        this.list.add(String.valueOf(indents) + currentToken);
                    }
                }
                GridData data = new GridData(1808);
                data.heightHint = this.list.getItemHeight() * 7;
                data.horizontalSpan = 2;
                this.list.setLayoutData((Object)data);
                this.list.setFont(parent.getFont());
                Menu copyMenu = new Menu((Control)this.list);
                MenuItem copyItem = new MenuItem(copyMenu, 0);
                copyItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }
                });
                copyItem.setText(SMLValidationMessages.commonCopy);
                this.list.setMenu(copyMenu);
                return this.list;
            }

            private void copyToClipboard() {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
                StringBuffer clipBoardBuffer = new StringBuffer();
                String[] listEntrySelections = this.list.getSelection();
                int i = 0;
                while (i < listEntrySelections.length) {
                    clipBoardBuffer.append(String.valueOf(listEntrySelections[i]) + IValidationConstants.LINE_SEPARATOR);
                    ++i;
                }
                this.clipboard = new Clipboard(this.list.getDisplay());
                this.clipboard.setContents(new Object[]{clipBoardBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
        CustomErrorDialog errorDialog = new CustomErrorDialog(parent, 4, title, message, cause);
        errorDialog.openErrorDialog();
    }

    public static void openErrorWithDetail(String title, String message, Throwable t) {
        SMLCommonUtil.openErrorWithDetail(title, message, t, true);
    }

    public static void openErrorWithDetail(final String title, final String message, Throwable t, final boolean defaultParent) {
        Object exceptionCause = null;
        String stackTrace = null;
        if (t != null) {
            stackTrace = SMLValidatorUtil.getExceptionStackTrace((Throwable)t);
            exceptionCause = t.getCause() != null ? t.getCause() : t;
        }
        final String cause = exceptionCause == null ? null : String.valueOf(exceptionCause.getClass().getName()) + "\n" + ((Throwable)exceptionCause).getMessage() + "\n" + stackTrace;
        SMLPlugin.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                SMLCommonUtil.openErrorWithDetail(defaultParent ? SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell() : null, title, message, cause);
            }
        });
    }
}

