/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLIFIdentity;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.operations.ISMLOperation;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.eclipse.cosmos.rm.smlif.internal.SMLImages;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLRepositoryManager;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportResourceTreeContentProvider;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportResourceTreeLabelProvider;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizard;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizardPage2;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizardPage3;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportWizardRuleBinding;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBinding;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToSMLIFWizardPage
extends WizardPage {
    private static final String DEFAULT_SMLIF_FILE_NAME = "smlif.xml";
    protected Text projectText;
    protected Text smlifText;
    protected IStructuredSelection selection;
    protected ContainerCheckedTreeViewer fileTree;

    public ExportToSMLIFWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setTitle(pageName);
        this.setSelection(selection);
    }

    public void createControl(Composite parent) {
        Composite topComponent = new Composite(parent, 0);
        GridData topComponentData = new GridData(768);
        topComponent.setLayoutData((Object)topComponentData);
        GridLayout topComponentLayout = new GridLayout();
        topComponentLayout.numColumns = 2;
        topComponentLayout.makeColumnsEqualWidth = false;
        topComponent.setLayout((Layout)topComponentLayout);
        this.createProjectPromptComposite(topComponent);
        this.createSelectedResourcesLabel(topComponent);
        this.createFileTree(topComponent);
        this.createSelectionButtons(topComponent);
        Group destGroup = this.createDestinationGroup(topComponent);
        this.createDestinationText(destGroup);
        this.createBrowseButtons(destGroup);
        this.setControl((Control)topComponent);
        this.updatePageForSelection();
        this.updatePageComplete();
        Dialog.applyDialogFont((Control)topComponent);
    }

    protected void updatePageForSelection() {
        if (!this.selection.isEmpty()) {
            this.projectText.setText(((IResource)this.selection.getFirstElement()).getProject().getName());
        }
        this.initCheckedItems();
    }

    protected void createProjectPromptComposite(Composite topComponent) {
        Composite projectComposite = new Composite(topComponent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        projectComposite.setLayout((Layout)layout);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = 4;
        compositeData.horizontalSpan = 2;
        projectComposite.setLayoutData((Object)compositeData);
        Label projectLabel = new Label(projectComposite, 0);
        projectLabel.setText(SMLMessages.exportWizardMainPageProjectLabel);
        GridData labelData = new GridData(768);
        labelData.grabExcessHorizontalSpace = true;
        labelData.horizontalSpan = 2;
        projectLabel.setLayoutData((Object)labelData);
        this.projectText = new Text(projectComposite, 2052);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExportToSMLIFWizardPage.this.updateFileTree();
            }
        });
        GridData projectTextData = new GridData(768);
        projectTextData.grabExcessHorizontalSpace = true;
        this.projectText.setLayoutData((Object)projectTextData);
        Button projectBrowseButton = new Button(projectComposite, 8);
        projectBrowseButton.setText(SMLMessages.exportWizardMainPageBrowseButton);
        projectBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportToSMLIFWizardPage.this.promptForProject();
            }
        });
    }

    protected void promptForProject() {
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setTitle(SMLMessages.exportWizardMainPageProjectPrompterTitle);
        dialog.setMessage(SMLMessages.exportWizardMainPageProjectPrompterMessage);
        IProject[] choices = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IProject)element).getName();
            }

            public Image getImage(Object element) {
                return SMLImages.INSTANCE.getImage("project.gif");
            }
        });
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput((Object)choices);
        if (dialog.open() == 0) {
            Object[] selections = dialog.getResult();
            this.projectText.setText(((IProject)selections[0]).getName());
            this.updateFileTree();
        }
    }

    protected void updateFileTree() {
        if ("".equals(this.projectText.getText())) {
            this.fileTree.getControl().setEnabled(false);
            return;
        }
        IProject selectedProject = this.getSelectedProject();
        if (selectedProject == null || !selectedProject.exists()) {
            this.setMessage(NLS.bind((String)SMLMessages.exportWizardMainPageErrorProjectNameNotValid, (Object)this.projectText.getText()));
            this.fileTree.getControl().setEnabled(false);
            return;
        }
        this.fileTree.setInput((Object)selectedProject);
        this.fileTree.getControl().setEnabled(true);
    }

    public IProject getSelectedProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectText.getText());
    }

    protected void createSelectedResourcesLabel(Composite topComponent) {
        Label selectedResourcesLabel = new Label(topComponent, 0);
        selectedResourcesLabel.setText(SMLMessages.exportWizardMainPageSelectedResourcesLabel);
        GridData selectedResourcesLabelData = new GridData(768);
        selectedResourcesLabelData.grabExcessHorizontalSpace = true;
        selectedResourcesLabelData.horizontalSpan = 2;
        selectedResourcesLabel.setLayoutData((Object)selectedResourcesLabelData);
    }

    protected void createBrowseButtons(Group destGroup) {
        Composite browseButtonRow = new Composite((Composite)destGroup, 0);
        GridLayout browseButtonRowLayout = new GridLayout();
        browseButtonRowLayout.numColumns = 2;
        browseButtonRowLayout.marginHeight = 0;
        browseButtonRowLayout.marginWidth = 0;
        browseButtonRowLayout.makeColumnsEqualWidth = true;
        GridData gd = new GridData(128);
        gd.horizontalSpan = 4;
        browseButtonRow.setLayoutData((Object)gd);
        browseButtonRow.setLayout((Layout)browseButtonRowLayout);
        Button browseWorkspaceButton = new Button(browseButtonRow, 8);
        browseWorkspaceButton.setText(SMLMessages.exportWizardMainPageBrowseWorkspaceButton);
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportToSMLIFWizardPage.this.promptForWorkspaceDestinationFile();
            }
        });
        Button browseFileSystemButton = new Button(browseButtonRow, 8);
        browseFileSystemButton.setText(SMLMessages.exportWizardMainPageBrowseFileSystemButton);
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportToSMLIFWizardPage.this.promptForExternalDestinationFile();
            }
        });
    }

    protected void createDestinationText(Group destGroup) {
        this.smlifText = new Text((Composite)destGroup, 2048);
        this.smlifText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportToSMLIFWizardPage.this.smlifText.getText().length();
                ExportToSMLIFWizardPage.this.updatePageComplete();
            }
        });
        GridData smlifGridData = new GridData(768);
        smlifGridData.grabExcessHorizontalSpace = true;
        smlifGridData.horizontalSpan = 4;
        this.smlifText.setLayoutData((Object)smlifGridData);
        IPath fileSuggestion = this.getTargetFileSuggestion();
        if (fileSuggestion != null) {
            this.smlifText.setText(fileSuggestion.toString());
        }
    }

    protected void promptForWorkspaceDestinationFile() {
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        dialog.setTitle(SMLMessages.exportWizardMainPageSaveAsDialogTitle);
        IPath path = this.getTargetFileSuggestion();
        if (path == null || path.equals((Object)"")) {
            dialog.setOriginalName(DEFAULT_SMLIF_FILE_NAME);
        } else {
            dialog.setOriginalFile(ResourcesPlugin.getWorkspace().getRoot().getFile(path));
        }
        if (dialog.open() == 1) {
            return;
        }
        IPath name = dialog.getResult();
        String relativePathToFile = name.toString();
        if (relativePathToFile != null) {
            this.smlifText.setText(relativePathToFile);
            this.updatePageComplete();
        }
    }

    private IPath getTargetFileSuggestion() {
        IResource firstSelection = (IResource)this.selection.getFirstElement();
        if (firstSelection == null) {
            return null;
        }
        if (firstSelection instanceof IContainer) {
            return firstSelection.getFullPath().append(DEFAULT_SMLIF_FILE_NAME);
        }
        return firstSelection.getParent().getFullPath().append(DEFAULT_SMLIF_FILE_NAME);
    }

    protected void createSelectionButtons(Composite topComponent) {
        Composite buttonComposite = new Composite(topComponent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttonCompositeData = new GridData();
        buttonCompositeData.verticalAlignment = 4;
        buttonComposite.setLayoutData((Object)buttonCompositeData);
        Button selectAllButton = new Button(buttonComposite, 0);
        selectAllButton.setText(SMLMessages.exportWizardMainPageSelectAllButton);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportToSMLIFWizardPage.this.getFileTree().setAllChecked(true);
                ExportToSMLIFWizardPage.this.getExportWizard().allFilesChecked(true);
            }
        });
        GridData buttonData = new GridData(256);
        selectAllButton.setLayoutData((Object)buttonData);
        Button deselectAllButton = new Button(buttonComposite, 0);
        deselectAllButton.setText(SMLMessages.exportWizardMainPageDeselectAllButton);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExportToSMLIFWizardPage.this.getFileTree().setAllChecked(false);
                ExportToSMLIFWizardPage.this.getExportWizard().allFilesChecked(false);
            }
        });
        deselectAllButton.setLayoutData((Object)buttonData);
    }

    protected void createFileTree(Composite topComponent) {
        this.setFileTree(new ContainerCheckedTreeViewer(topComponent));
        ExportResourceTreeContentProvider contentProvider = new ExportResourceTreeContentProvider();
        this.getFileTree().setContentProvider((IContentProvider)contentProvider);
        this.getFileTree().setLabelProvider((IBaseLabelProvider)new ExportResourceTreeLabelProvider());
        this.getFileTree().addCheckStateListener((ICheckStateListener)((ExportToSMLIFWizard)this.getWizard()));
        GridData fileTreeData = new GridData(1808);
        fileTreeData.verticalSpan = 2;
        fileTreeData.grabExcessVerticalSpace = true;
        this.getFileTree().getControl().setLayoutData((Object)fileTreeData);
        this.initCheckedItems();
    }

    protected void initCheckedItems() {
        for (IResource element : this.selection) {
            if (element instanceof IProject) {
                Object[] kids = ((ExportResourceTreeContentProvider)this.getFileTree().getContentProvider()).getChildren(element);
                int i = 0;
                while (i < kids.length) {
                    this.getFileTree().setChecked((Object)((IResource)kids[i]), true);
                    ++i;
                }
            } else {
                this.getFileTree().setChecked((Object)element, true);
            }
            this.getExportWizard().addFileToSelected(element);
        }
    }

    public boolean doExport() {
        IFile file;
        this.getPage2().initFromMetadata();
        String smlifFileName = this.smlifText.getText();
        if (this.fileIsWorkspacePath(smlifFileName) && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(smlifFileName))) != null) {
            IPath location = file.getLocation();
            if (location == null) {
                String projectName = SMLRepositoryUtil.firstSegment((String)smlifFileName, (int)1);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project.exists()) {
                    try {
                        project.create((IProgressMonitor)new NullProgressMonitor());
                        project.open((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        SMLCommonUtil.openErrorWithDetail(SMLMessages.errorCreatingProjectTitle, SMLMessages.errorCreatingProject, e);
                        return false;
                    }
                }
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(smlifFileName));
                smlifFileName = file.getLocation().toString();
            } else {
                smlifFileName = location.toString();
            }
        }
        try {
            ISMLOperation operation = SMLRepositoryManager.getRepository().getOperation("org.eclipse.cosmos.rm.repository.provisional.operations.ISMLExportOperation");
            SMLIFIdentity identity = new SMLIFIdentity(smlifFileName, this.getPage2().getSMLIFName(), this.getPage2().getSMLIFDescription(), this.getPage2().getDisplayName(), this.getPage2().getVersion(), this.getPage2().getBaseURI());
            operation.setArguments(new Object[]{this.getSelectedModelUnits(), this.getExportWizard().getPage2().getAliases(), this.getRuleBindings().toArray(new RuleBinding[this.getRuleBindings().size()]), identity});
            operation.run();
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(smlifFileName));
            if (workspaceFile != null) {
                workspaceFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (RepositoryOperationException ex) {
            SMLCommonUtil.openErrorWithDetail(SMLMessages.exportErrorTitle, ex.getMessage(), ex);
            return false;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return true;
        }
    }

    protected List<RuleBinding> getRuleBindings() {
        List<ExportWizardRuleBinding> bindings = this.getPage3().getRuleBindings();
        ArrayList<RuleBinding> result = new ArrayList<RuleBinding>();
        for (RuleBinding ruleBinding : bindings) {
            if (!ruleBinding.isValid()) continue;
            result.add(new RuleBinding("<all>".equals(ruleBinding.getAlias()) ? null : ruleBinding.getAlias(), ruleBinding.getRule()));
        }
        return result;
    }

    private ExportToSMLIFWizardPage3 getPage3() {
        return ((ExportToSMLIFWizard)this.getWizard()).page3;
    }

    protected ExportToSMLIFWizardPage2 getPage2() {
        return ((ExportToSMLIFWizard)this.getWizard()).page2;
    }

    protected boolean fileIsWorkspacePath(String smlifFileName) {
        if (Platform.getOS().equals("win32")) {
            return new Path(smlifFileName).getDevice() == null;
        }
        return true;
    }

    protected ISMLDocument[] getSelectedModelUnits() {
        Collection<ISMLDocument> selectedFiles = this.getExportWizard().getSelectedFiles().values();
        return selectedFiles.toArray(new ISMLDocument[selectedFiles.size()]);
    }

    protected ExportToSMLIFWizard getExportWizard() {
        return (ExportToSMLIFWizard)this.getWizard();
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    protected Group createDestinationGroup(Composite topComposite) {
        Group destinationGroup = new Group(topComposite, 0);
        destinationGroup.setText(SMLMessages.exportWizardDestinationGroupTitle);
        GridData destinationGroupData = new GridData(768);
        destinationGroupData.horizontalSpan = 2;
        destinationGroup.setLayoutData((Object)destinationGroupData);
        GridLayout destinationGroupLayout = new GridLayout();
        destinationGroupLayout.numColumns = 2;
        destinationGroupLayout.makeColumnsEqualWidth = false;
        destinationGroupLayout.marginWidth = 5;
        destinationGroupLayout.marginHeight = 5;
        destinationGroup.setLayout((Layout)destinationGroupLayout);
        return destinationGroup;
    }

    protected void updatePageComplete() {
        this.setPageComplete(this.smlifText.getText().length() > 0 && this.getCheckedCount() > 0);
    }

    protected int getCheckedCount() {
        return ((ExportToSMLIFWizard)this.getWizard()).getSelectedFiles().size();
    }

    protected void promptForExternalDestinationFile() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(SMLMessages.exportWizardMainPageSaveAsDialogTitle);
        dialog.setFileName(DEFAULT_SMLIF_FILE_NAME);
        dialog.setFilterExtensions(new String[]{"*.xml", "*"});
        String name = dialog.open();
        if (name != null) {
            this.smlifText.setText(name);
            this.updatePageComplete();
        }
    }

    public void setFileTree(ContainerCheckedTreeViewer fileTree) {
        this.fileTree = fileTree;
    }

    public ContainerCheckedTreeViewer getFileTree() {
        return this.fileTree;
    }

    public String getProjectName() {
        return this.projectText.getText();
    }
}

