/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.importing.ui;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.operations.OperationEvent;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.operations.IProgressListener;
import org.eclipse.cosmos.rm.repository.provisional.operations.ISMLOperation;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLRepositoryManager;
import org.eclipse.cosmos.rm.smlif.internal.dialogs.ResourceSelectionDialog;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class ImportFromSMLIFWizardPage
extends WizardPage {
    private static final int FILE_OVERWRITE = 0;
    protected IStructuredSelection selection;
    protected Text modelDirText;
    protected Text smlifFileText;
    protected Button importFromWorkspaceButton;
    protected Button importFromFileSystemButton;
    protected Button createFolderStructureButton;
    protected Button overwriteFilesWithoutWarningButton;
    protected String initialDestinationDir;

    public ImportFromSMLIFWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setTitle(pageName);
        this.setSelection(selection);
    }

    public void createControl(Composite parent) {
        String dirNameSuggestion;
        Composite topComposite = new Composite(parent, 0);
        GridLayout topCompositeLayout = new GridLayout();
        topCompositeLayout.numColumns = 1;
        topCompositeLayout.makeColumnsEqualWidth = false;
        topComposite.setLayout((Layout)topCompositeLayout);
        Group pathsGroup = this.createPathsGroup(topComposite);
        this.createSourceFileSection(pathsGroup);
        this.createDestinationLocationSection(pathsGroup);
        this.createCheckBoxOptions(topComposite);
        this.setControl((Control)topComposite);
        String string = dirNameSuggestion = this.getInitialDestinationDir() == null ? SMLPlugin.getDefault().getPreferenceStore().getString("import.output") : this.getInitialDestinationDir();
        if (dirNameSuggestion == null || dirNameSuggestion.length() <= 0) {
            dirNameSuggestion = this.selection == null || this.selection.size() == 0 ? (dirNameSuggestion = "/") : ((IFile)this.selection.getFirstElement()).getParent().getFullPath().toString();
        }
        this.modelDirText.setText(dirNameSuggestion);
        this.smlifFileText.setText(this.getInitialSourceFileName());
        this.updatePageComplete();
        Dialog.applyDialogFont((Control)topComposite);
    }

    protected String getInitialSourceFileName() {
        if (this.selection == null || this.selection.isEmpty()) {
            return "";
        }
        IResource sel = (IResource)this.selection.getFirstElement();
        return sel.getFullPath().toString();
    }

    protected void createCheckBoxOptions(Composite topComposite) {
        this.overwriteFilesWithoutWarningButton = new Button(topComposite, 32);
        this.overwriteFilesWithoutWarningButton.setText(SMLMessages.importWizardOptionOverwriteFiles);
        this.overwriteFilesWithoutWarningButton.setSelection(true);
        this.createFolderStructureButton = new Button(topComposite, 32);
        this.createFolderStructureButton.setText(SMLMessages.importWizardOptionCreateStructure);
        this.createFolderStructureButton.setSelection(true);
    }

    protected Group createPathsGroup(Composite topComposite) {
        Group pathsGroup = new Group(topComposite, 0);
        pathsGroup.setText(SMLMessages.importWizardPathsGroupTitle);
        GridData pathsGroupData = new GridData(768);
        pathsGroup.setLayoutData((Object)pathsGroupData);
        GridLayout pathsGroupLayout = new GridLayout();
        pathsGroupLayout.numColumns = 3;
        pathsGroupLayout.makeColumnsEqualWidth = false;
        pathsGroup.setLayout((Layout)pathsGroupLayout);
        return pathsGroup;
    }

    protected void createDestinationLocationSection(Group pathsGroup) {
        Label modelDirLabel = new Label((Composite)pathsGroup, 0);
        modelDirLabel.setText(SMLMessages.importWizardLabelDestinationDirectory);
        this.modelDirText = new Text((Composite)pathsGroup, 2048);
        this.modelDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportFromSMLIFWizardPage.this.setPageComplete(ImportFromSMLIFWizardPage.this.modelDirText.getText().length() > 0);
            }
        });
        this.modelDirText.setLayoutData((Object)new GridData(768));
        Button browseForDirectoryButton = new Button((Composite)pathsGroup, 8);
        browseForDirectoryButton.setText(SMLMessages.importWizardBrowseButton);
        browseForDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportFromSMLIFWizardPage.this.promptForDestinationDirectory();
            }
        });
    }

    protected void createSourceFileSection(Group pathsGroup) {
        Label smlifFileLabel = new Label((Composite)pathsGroup, 0);
        smlifFileLabel.setText(SMLMessages.importWizardLabelSourceFile);
        this.smlifFileText = new Text((Composite)pathsGroup, 2048);
        this.smlifFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportFromSMLIFWizardPage.this.updatePageComplete();
                if ("/".equals(ImportFromSMLIFWizardPage.this.modelDirText.getText()) && !"".equals(ImportFromSMLIFWizardPage.this.smlifFileText.getText())) {
                    Path smlifFilePath = new Path(ImportFromSMLIFWizardPage.this.smlifFileText.getText());
                    IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)smlifFilePath);
                    String calculatedDirName = smlifFilePath.removeLastSegments(1).toString();
                    if (workspaceFile != null && ImportFromSMLIFWizardPage.this.checkWorkspaceDirName(calculatedDirName)) {
                        ImportFromSMLIFWizardPage.this.modelDirText.setText(calculatedDirName);
                    }
                }
            }
        });
        GridData smlifFileData = new GridData(768);
        smlifFileData.horizontalSpan = 2;
        this.smlifFileText.setLayoutData((Object)smlifFileData);
        this.createBrowseButtonRow(pathsGroup);
    }

    protected void createBrowseButtonRow(Group pathsGroup) {
        Composite browseButtonRow = new Composite((Composite)pathsGroup, 0);
        GridLayout browseButtonRowLayout = new GridLayout();
        browseButtonRowLayout.numColumns = 2;
        browseButtonRowLayout.marginHeight = 0;
        browseButtonRowLayout.marginWidth = 0;
        browseButtonRowLayout.makeColumnsEqualWidth = true;
        GridData gd = new GridData(128);
        gd.horizontalSpan = 4;
        browseButtonRow.setLayoutData((Object)gd);
        browseButtonRow.setLayout((Layout)browseButtonRowLayout);
        Button importFromWorkspaceButton = new Button(browseButtonRow, 8);
        importFromWorkspaceButton.setText(SMLMessages.importWizardBrowseWorkspaceButtonText);
        importFromWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String selectedSourceFile = ImportFromSMLIFWizardPage.this.promptForFileInWorkspace();
                ImportFromSMLIFWizardPage.this.updateSourceFileText(selectedSourceFile);
            }
        });
        Button importFromFileSystemButton = new Button(browseButtonRow, 8);
        importFromFileSystemButton.setText(SMLMessages.importWizardBrowseFileSystemButtonText);
        importFromFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String selectedSourceFile = ImportFromSMLIFWizardPage.this.promptForFileOnSystem();
                ImportFromSMLIFWizardPage.this.updateSourceFileText(selectedSourceFile);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doImport() {
        String targetDirectory = this.modelDirText.getText();
        SMLPlugin.getDefault().getPreferenceStore().setValue("import.output", targetDirectory);
        if (!this.checkSourceFileName()) {
            this.setErrorMessage(NLS.bind((String)SMLMessages.importWizardErrorInvalidSourceFile, (Object)this.smlifFileText.getText()));
            return false;
        }
        if (targetDirectory.charAt(0) != '/') {
            this.modelDirText.setText(String.valueOf('/') + targetDirectory);
        }
        if (!this.checkWorkspaceDirName(targetDirectory = this.modelDirText.getText())) {
            this.setErrorMessage(NLS.bind((String)SMLMessages.importWizardErrorInvalidDestinationDirectory, (Object)targetDirectory));
            return false;
        }
        ISMLRepository repository = null;
        String projectName = SMLRepositoryUtil.firstSegment((String)targetDirectory, (int)1);
        try {
            String remainingPath;
            String fileName;
            block25: {
                fileName = SMLValidatorUtil.retrieveAbsolutePath((String)this.smlifFileText.getText());
                int smlifFileType = SMLValidatorUtil.identifyDocumentType((File)new File(fileName));
                if (smlifFileType != 2) {
                    SMLCommonUtil.openErrorWithDetail(SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), SMLMessages.importErrorTitle, NLS.bind((String)SMLMessages.importWizardErrorNotSMLIFFile, (Object)fileName), null);
                    return false;
                }
                int projectSuffixIndex = targetDirectory.indexOf(projectName) + projectName.length() + 1;
                remainingPath = targetDirectory.length() > projectSuffixIndex ? targetDirectory.substring(projectSuffixIndex) : "";
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project.exists()) {
                    if (this.createFolderStructureButton.getSelection()) {
                        try {
                            project.create((IProgressMonitor)new NullProgressMonitor());
                            project.open((IProgressMonitor)new NullProgressMonitor());
                            break block25;
                        }
                        catch (CoreException e) {
                            SMLCommonUtil.openErrorWithDetail(SMLMessages.errorCreatingProjectTitle, SMLMessages.errorCreatingProject, e);
                            return false;
                        }
                    }
                    SMLCommonUtil.openErrorWithDetail(SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), SMLMessages.errorMissingProjectTitle, SMLMessages.errorMissingProject, null);
                    return false;
                }
            }
            repository = SMLRepositoryManager.getRepository(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString());
            ISMLOperation operation = repository.getOperation("org.eclipse.cosmos.rm.repository.provisional.operations.ISMLImportOperation");
            operation.setArguments(new Object[]{fileName, remainingPath, new Boolean(this.overwriteFilesWithoutWarningButton.getSelection()), new Boolean(this.createFolderStructureButton.getSelection())});
            operation.addProgressListener((IProgressListener)new ProgressListener());
            operation.run();
            return true;
        }
        catch (RepositoryOperationException e) {
            SMLCommonUtil.openErrorWithDetail(SMLMessages.importErrorTitle, e.getMessage(), e);
            return false;
        }
        catch (IOException e) {
            SMLCommonUtil.openErrorWithDetail(SMLMessages.importErrorTitle, e.getMessage(), e);
            return false;
        }
        catch (CoreException e) {
            SMLCommonUtil.openErrorWithDetail(SMLMessages.importErrorTitle, e.getMessage(), e);
            return false;
        }
        finally {
            if (repository != null) {
                repository.disconnect();
            }
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.exists()) {
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean checkWorkspaceDirName(String dirName) {
        boolean okForFolder = ResourcesPlugin.getWorkspace().validatePath(dirName, 2).isOK();
        if (!okForFolder) {
            okForFolder = ResourcesPlugin.getWorkspace().validatePath(dirName, 4).isOK();
        }
        return okForFolder;
    }

    protected boolean checkWorkspaceResourceName(String resourceName) {
        return ResourcesPlugin.getWorkspace().validatePath(resourceName, 1).isOK();
    }

    protected boolean checkSourceFileName() {
        File srcFile = new File(this.smlifFileText.getText());
        if (srcFile.exists()) {
            return true;
        }
        Path srcPath = new Path(this.smlifFileText.getText());
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)srcPath).exists();
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    protected void updatePageComplete() {
        this.setPageComplete(this.smlifFileText.getText().length() > 0 && this.modelDirText.getText().length() > 0);
    }

    protected void promptForDestinationDirectory() {
        ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, SMLMessages.importWizardDestinationDirectoryDialogTitle);
        containerDialog.setMessage(SMLMessages.importWizardDestinationDirectoryDialogMessage);
        if (containerDialog.open() == 1) {
            return;
        }
        String name = ((IPath)containerDialog.getResult()[0]).toString();
        this.modelDirText.setText(name);
    }

    protected String promptForFileInWorkspace() {
        ResourceSelectionDialog resourceDialog = new ResourceSelectionDialog(this.getShell(), 2);
        resourceDialog.setMultiSelection(false);
        resourceDialog.setTitle(SMLMessages.importWizardSourceFileDialogTitle);
        resourceDialog.setMessage(SMLMessages.importWizardFileInstruction);
        IFile[] results = resourceDialog.open();
        if (results.length == 0) {
            return null;
        }
        return results[0].getFullPath().toString();
    }

    protected String promptForFileOnSystem() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(SMLMessages.importWizardSourceFileDialogTitle);
        if (this.smlifFileText.getText().length() > 0) {
            fileDialog.setFileName(new File(this.smlifFileText.getText()).getName());
            fileDialog.setFilterPath(new File(this.smlifFileText.getText()).getParentFile().getAbsolutePath());
        }
        fileDialog.setFilterExtensions(new String[]{"*.xml", "*"});
        return fileDialog.open();
    }

    protected void updateSourceFileText(String relativePathToFile) {
        if (relativePathToFile == null) {
            return;
        }
        this.smlifFileText.setText(relativePathToFile);
    }

    public void setInitialDestinationDir(String initialDestinationDir) {
        this.initialDestinationDir = initialDestinationDir;
    }

    public String getInitialDestinationDir() {
        if (this.initialDestinationDir == null || "".equals(this.initialDestinationDir)) {
            return null;
        }
        return this.initialDestinationDir;
    }

    public static class ProgressListener
    implements IProgressListener {
        private boolean displayedWarning;

        public void operationInterrupted(OperationEvent event) {
            switch (event.type) {
                case 1: {
                    if (this.displayedWarning) break;
                    this.displayedWarning = true;
                    MessageDialog.openWarning((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.importMissingStructureTitle, (String)NLS.bind((String)SMLMessages.importMissingStructure, (Object)((String)event.data)));
                    break;
                }
                case 0: {
                    MessageDialog dialog = new MessageDialog(SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), SMLMessages.importWizardExistingFilePrompterTitle, null, NLS.bind((String)SMLMessages.importWizardExistingFilePrompterMessage, (Object)((String)event.data)), 0, new String[]{SMLMessages.importWizardExistingFileOverwriteButtonLabel, SMLMessages.importWizardExistingFileSkipButtonLabel}, 0);
                    event.doit = dialog.open() == 0;
                }
            }
        }
    }
}

