/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.newfile.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.rm.repository.internal.ISMLRepositoryConstants;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLIFIdentity;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLIFIdentity;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.newfile.ui.NewFileWizardIdentityPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewFileWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection initialSelection;
    private WizardNewFileCreationPage wizardNewFileCreationPage;
    private IWorkbench workbench;
    private NewFileWizardIdentityPage newFileWizardIdentityPage;
    private IFile file;

    public boolean performFinish() {
        this.file = this.wizardNewFileCreationPage.createNewFile();
        if (this.file == null) {
            return false;
        }
        this.fillInContents(this.file);
        Runnable runnable = new Runnable(){

            public void run() {
                NewFileWizard.this.openEditor();
            }
        };
        BusyIndicator.showWhile(null, (Runnable)runnable);
        return true;
    }

    private void fillInContents(IFile file) {
        StringBuffer buffer = new StringBuffer();
        SMLRepositoryUtil.appendSMLIFIdentityInformation((StringBuffer)buffer, (ISMLIFIdentity)new SMLIFIdentity(null, this.newFileWizardIdentityPage.getNameText().getText(), this.newFileWizardIdentityPage.getDescriptionText().getText(), this.newFileWizardIdentityPage.getDisplayNameText().getText(), this.newFileWizardIdentityPage.getVersionText().getText(), this.newFileWizardIdentityPage.getBaseURIText().getText()));
        buffer.append(ISMLRepositoryConstants.smlifEnd);
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer.toString().getBytes());
        try {
            file.appendContents((InputStream)stream, 1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void addPages() {
        this.setWindowTitle(SMLMessages.newFileWizardTitle);
        this.wizardNewFileCreationPage = new WizardNewFileCreationPage(SMLMessages.newFileWizardCreationPageName, this.initialSelection);
        this.wizardNewFileCreationPage.setTitle(SMLMessages.newFileWizardCreationPageTitle);
        this.wizardNewFileCreationPage.setDescription(SMLMessages.newFileWizardCreationPageDescription);
        this.addPage((IWizardPage)this.wizardNewFileCreationPage);
        this.newFileWizardIdentityPage = new NewFileWizardIdentityPage();
        this.addPage((IWizardPage)this.newFileWizardIdentityPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.initialSelection = selection;
    }

    private void openEditor() {
        IWorkbenchWindow dw = this.workbench.getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)this.file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            SMLCommonUtil.openErrorWithDetail(SMLMessages.newFileWizardErrorOpeningEditor, e.getMessage(), e);
        }
    }
}

