/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.DocumentNode;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementEdge;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationException;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AcyclicDataTypesList;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ReferenceGraphDataBuilder;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcyclicValidator
extends AbstractSMLValidator {
    private Map<TypeNode, Map<Integer, Integer>> nodeOrder;
    private Map<String, Node> treeForest = new Hashtable<String, Node>();
    private List<String> cycle;

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.instance();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.AcyclicDataTypesList", new AcyclicDataTypesList());
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ReferenceGraphDataBuilder", new ReferenceGraphDataBuilder());
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationAcyclic);
        Iterator acyclicTypes = (Iterator)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.AcyclicDataTypesList");
        Map referenceGraph = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ReferenceGraphDataBuilder");
        IDataBuilder<?> inheritanceDataBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        IValidationOutput<String, Object> output = this.getValidationOutput();
        if (referenceGraph == null || acyclicTypes == null) {
            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, SMLValidationMessages.acyclicUnknown));
            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, referenceGraph == null ? SMLValidationMessages.acyclicNoReferenceGraph : (acyclicTypes == null ? SMLValidationMessages.acyclicNoAcyclicTypeList : SMLValidationMessages.acyclicNoInheritanceMap)));
            if (this.shouldAbortOnError()) {
                return false;
            }
        }
        if (!inheritanceDataBuilder.isStructureValid()) {
            output.reportMessage(inheritanceDataBuilder.getErrorMessage());
            if (this.shouldAbortOnError()) {
                return false;
            }
        }
        String[] graphNodes = new String[referenceGraph.size()];
        int counter = 0;
        Iterator iterator = referenceGraph.keySet().iterator();
        while (iterator.hasNext()) {
            graphNodes[counter++] = (String)iterator.next();
        }
        Edge backEdge = null;
        this.cycle = null;
        Iterator iter = acyclicTypes;
        while (iter.hasNext() && backEdge == null) {
            TypeNode elementType = (TypeNode)iter.next();
            this.treeForest.clear();
            int i = 0;
            while (i < graphNodes.length && backEdge == null) {
                block16: {
                    if (this.nodeOrder != null) {
                        this.nodeOrder.remove(elementType);
                    }
                    if (this.getNodeOrder(referenceGraph, graphNodes[i], elementType) == -1) {
                        try {
                            backEdge = this.dfsSearch(referenceGraph, elementType, graphNodes[i]);
                        }
                        catch (SMLValidationException e) {
                            String message = SMLValidationMessages.errorInvalidURI;
                            if (e.getMessage() != null) {
                                message = String.valueOf(message) + ". " + e.getMessage();
                            }
                            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(e.getLineNumber(), message));
                            if (!this.shouldAbortOnError()) break block16;
                            return false;
                        }
                    }
                }
                ++i;
            }
        }
        if (backEdge != null) {
            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(backEdge.lineNumber, NLS.bind((String)SMLValidationMessages.acyclicCycleFound, (Object)backEdge.referenceType)));
            if (this.cycle != null && this.cycle.size() > 0) {
                String cycleString = "";
                int i = 0;
                int cycleNodeCount = this.cycle.size();
                while (i < cycleNodeCount) {
                    cycleString = String.valueOf(cycleString) + this.cycle.get(i) + ", ";
                    ++i;
                }
                cycleString = cycleString.substring(0, cycleString.length() - 2);
                output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(backEdge.lineNumber, NLS.bind((String)SMLValidationMessages.acyclicDetectedCycle, (Object)cycleString)));
            }
            if (this.shouldAbortOnError()) {
                return false;
            }
            return false;
        }
        return true;
    }

    private int getNodeOrder(Map<String, DocumentNode> referenceGraph, String node, TypeNode elementType) {
        DocumentNode documentNode = referenceGraph.get(node);
        if (this.nodeOrder == null || documentNode == null) {
            return -1;
        }
        Map<Integer, Integer> ordersPerElement = this.nodeOrder.get(elementType);
        Integer order = ordersPerElement == null ? null : ordersPerElement.get(new Integer(documentNode.hashCode()));
        return order == null ? -1 : order;
    }

    private void incrementNodeOrder(Map<String, DocumentNode> referenceGraph, TypeNode elementType, String node) {
        Integer order;
        DocumentNode documentNode = referenceGraph.get(node);
        if (documentNode == null) {
            return;
        }
        if (this.nodeOrder == null) {
            this.nodeOrder = new Hashtable<TypeNode, Map<Integer, Integer>>();
        }
        Integer hashcode = new Integer(documentNode.hashCode());
        Map<Integer, Integer> ordersPerElement = this.nodeOrder.get(elementType);
        if (ordersPerElement == null) {
            ordersPerElement = new Hashtable<Integer, Integer>();
            this.nodeOrder.put(elementType, ordersPerElement);
        }
        ordersPerElement.put(hashcode, (order = ordersPerElement.get(hashcode)) == null ? new Integer(0) : new Integer(order + 1));
    }

    private Edge dfsSearch(Map<String, DocumentNode> referenceGraph, TypeNode elementType, String documentAlias) throws SMLValidationException {
        DocumentNode documentNode = referenceGraph.get(documentAlias);
        if (documentNode == null) {
            return null;
        }
        this.incrementNodeOrder(referenceGraph, elementType, documentAlias);
        ElementEdge[] edges = documentNode.getEdges(elementType.getUri(), elementType.getType());
        Edge backEdge = null;
        Node node = this.treeForest.get(documentAlias);
        if (node == null) {
            node = new Node();
            this.treeForest.put(documentAlias, node);
        }
        int i = 0;
        while (i < edges.length) {
            String document;
            try {
                document = edges[i].getDocument();
            }
            catch (URISyntaxException e) {
                SMLValidationException validationException = new SMLValidationException(e);
                validationException.setLineNumber(edges[i].getLineNumber());
                throw validationException;
            }
            if (this.getNodeOrder(referenceGraph, document, elementType) != -1) {
                backEdge = new Edge(documentAlias, document, String.valueOf(elementType.getUri()) + elementType.getType(), edges[i].getLineNumber());
                ArrayList<String> cycle = new ArrayList<String>();
                cycle.add(documentAlias);
                cycle.add(document);
                this.findCycle(document, documentAlias, cycle);
                if (documentAlias.equals(cycle.get(cycle.size() - 1))) {
                    this.cycle = cycle;
                }
                return backEdge;
            }
            node.addEdge(new Edge(documentAlias, document, String.valueOf(elementType.getUri()) + elementType.getType(), edges[i].getLineNumber()));
            backEdge = this.dfsSearch(referenceGraph, elementType, document);
            ++i;
        }
        return backEdge;
    }

    private void findCycle(String source, String target, List<String> cycle) {
        Node node = this.treeForest.get(source);
        if (node == null) {
            return;
        }
        int i = 0;
        int edgeCount = node.edges.size();
        while (i < edgeCount) {
            Edge currentEdge = node.edges.get(i);
            cycle.add(currentEdge.targetDocument);
            if (target.equals(currentEdge.targetDocument)) break;
            this.findCycle(currentEdge.targetDocument, target, cycle);
            if (cycle.size() > 0 && target.equals(cycle.get(cycle.size() - 1))) break;
            cycle.remove(currentEdge.targetDocument);
            ++i;
        }
    }

    private static class Edge {
        public String sourceDocument;
        public String targetDocument;
        public String referenceType;
        public int lineNumber;

        public Edge(String sourceDocument, String targetDocument, String referenceType, int lineNumber) {
            this.sourceDocument = sourceDocument;
            this.targetDocument = targetDocument;
            this.referenceType = referenceType;
            this.lineNumber = lineNumber;
        }
    }

    private static class Node {
        public List<Edge> edges = new ArrayList<Edge>();

        public void addEdge(Edge edge) {
            this.edges.add(edge);
        }
    }
}

