/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ReferenceDescriptor;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.ReferenceExtractor;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.reference.URIReference;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointer;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceValidator
extends AbstractValidator {
    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.instance();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ReferenceExtractor", new ReferenceExtractor());
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationReferences);
        List references = (List)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ReferenceExtractor");
        int i = 0;
        int refCount = references.size();
        while (i < refCount) {
            NodeList nodeList;
            Node context;
            URIReference uriReference;
            ReferenceDescriptor currentReference;
            block5: {
                currentReference = null;
                try {
                    currentReference = (ReferenceDescriptor)references.get(i);
                    uriReference = new URIReference(currentReference.getReference());
                    context = uriReference.retrieveDocumentDOM();
                    if (context != null) break block5;
                    this.showWarning(currentReference);
                    return false;
                }
                catch (Exception e) {
                    this.showWarning(currentReference, e);
                    return false;
                }
            }
            String fragment = uriReference.getFragment();
            if (fragment != null && fragment.length() > 0 && ((nodeList = (NodeList)XPointer.compile(uriReference.getFragment()).evaluate(context)) == null || nodeList.getLength() <= 0)) {
                this.showWarning(currentReference);
                return false;
            }
            ++i;
        }
        return true;
    }

    private void showWarning(ReferenceDescriptor uriReference) {
        this.showWarning(uriReference, null);
    }

    private void showWarning(ReferenceDescriptor uriReference, Exception e) {
        IValidationOutput<String, Object> output = this.getValidationOutput();
        if (e == null) {
            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(uriReference.getFilePath(), uriReference.getLineNumber(), NLS.bind((String)SMLValidationMessages.warningUnresolvedReference, (Object)uriReference.getReference())));
        } else {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            output.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(uriReference.getFilePath(), uriReference.getLineNumber(), String.valueOf(NLS.bind((String)SMLValidationMessages.warningReferenceResolving, (Object)uriReference.getReference())) + " " + sw.getBuffer().toString()));
        }
    }
}

