/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import java.net.URI;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.ResponseArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IRecord;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.w3c.dom.Node;

public class CMDBfUtil {
    public static INodes retrieveRepositoryDocs(ISMLRepository repository, IItemTemplate template) throws RepositoryOperationException {
        INodes nodes = ResponseArtifactFactory.createNodes((IItemTemplate)template);
        ISMLDocument[] documents = repository.fetchDocuments(new SMLFileMetadata(null, 1, null, null, null));
        int i = 0;
        while (i < documents.length) {
            if (documents[i] instanceof IItemConvertible) {
                nodes.addItem((IItemConvertible)documents[i]);
            }
            ++i;
        }
        return nodes;
    }

    public static SMLFileInstanceDocument retrieveDocument(ISMLRepository repository, IItem item) throws RepositoryOperationException {
        IRecord[] records = item.getRecords();
        String recordId = "";
        if (records != null && records.length > 0) {
            URI id = records[0].getRecordId();
            recordId = CMDBfServicesUtil.toString((URI)id);
        }
        if (recordId == null) {
            return null;
        }
        ISMLDocument[] documents = repository.fetchDocuments(new SMLFileMetadata(recordId, -1, null, null, null));
        if (documents != null && documents.length > 0) {
            return (SMLFileInstanceDocument)documents[0];
        }
        return null;
    }

    public static Node retrieveDocumentNode(ISMLRepository repository, IItem item) throws RepositoryOperationException {
        SMLFileInstanceDocument document = CMDBfUtil.retrieveDocument(repository, item);
        return document == null ? null : document.getDOMDocument().getFirstChild();
    }
}

