/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.exceptions.SelectorHandleException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IOperator;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IProperty;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IPropertyValueSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ISelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.AbstractSMLSelectorHandler;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.CMDBfUtil;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.NullSMLProperty;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.SMLPropertyFactory;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemPropertyHandler
extends AbstractSMLSelectorHandler {
    @Override
    public INodes handle(INodes context, ISelector selector) throws SelectorHandleException {
        try {
            INodes result = this.retrieveContext(context);
            IPropertyValueSelector propertySelector = (IPropertyValueSelector)selector;
            IGraphElement[] elements = result.getElements();
            IOperator[] operators = propertySelector.getOperators();
            if (operators == null) {
                return context;
            }
            ISMLRepository repository = this.getRepository();
            ArrayList<IGraphElement> revisedList = new ArrayList<IGraphElement>();
            boolean matchAny = propertySelector.isMatchAny();
            int i = 0;
            while (i < elements.length) {
                Node rootNode = CMDBfUtil.retrieveDocumentNode(repository, (IItem)elements[i]);
                if (rootNode != null) {
                    boolean overallResult = !matchAny;
                    ArrayList<Object> matches = new ArrayList<Object>();
                    ItemPropertyHandler.retrieveProperty(rootNode, propertySelector.getNamespace(), propertySelector.getLocalName(), matches, true);
                    if (matches.isEmpty()) {
                        matches.add((Object)new NullSMLProperty());
                    }
                    int j = 0;
                    while (j < operators.length) {
                        boolean operationResult = false;
                        Object value = operators[j].getValue();
                        boolean caseSensitive = operators[j].isCaseSensitive();
                        int k = 0;
                        int propertyCount = matches.size();
                        while (!operationResult && k < propertyCount) {
                            IProperty property = (IProperty)matches.get(k);
                            switch (operators[j].getType()) {
                                case 6: {
                                    if (!(value instanceof String)) break;
                                    operationResult = property.contains((String)value, caseSensitive);
                                    break;
                                }
                                case 0: {
                                    operationResult = property.equals(value, caseSensitive);
                                    break;
                                }
                                case 1: {
                                    operationResult = property.greater(value);
                                    break;
                                }
                                case 3: {
                                    operationResult = property.greaterOrEqual(value);
                                    break;
                                }
                                case 2: {
                                    operationResult = property.less(value);
                                    break;
                                }
                                case 4: {
                                    operationResult = property.lessOrEqual(value);
                                    break;
                                }
                                case 5: {
                                    if (!(value instanceof String)) break;
                                    operationResult = property.like((String)value, caseSensitive);
                                    break;
                                }
                                case 7: {
                                    operationResult = property.isNull();
                                }
                            }
                            if (!(property instanceof NullSMLProperty) && operators[j].isNegated()) {
                                operationResult = !operationResult;
                            }
                            ++k;
                        }
                        if (matchAny) {
                            if (operationResult) {
                                overallResult = true;
                                break;
                            }
                        } else if (!operationResult) {
                            overallResult = false;
                            break;
                        }
                        ++j;
                    }
                    if (overallResult) {
                        revisedList.add(elements[i]);
                    }
                }
                ++i;
            }
            result.setElements(revisedList.toArray(new IGraphElement[revisedList.size()]));
            return result;
        }
        catch (RepositoryOperationException e) {
            throw new SelectorHandleException((Throwable)e);
        }
    }

    public static void retrieveProperty(Node node, URI namespace, String localName, List<Object> matches, boolean storageType) {
        int i;
        String namespaceStr = CMDBfServicesUtil.toString((URI)namespace);
        if (namespaceStr.equals(node.getNamespaceURI()) && localName.equals(node.getLocalName())) {
            matches.add(storageType ? SMLPropertyFactory.create(node) : node);
            if (!storageType) {
                return;
            }
        }
        boolean namespaceMatch = namespaceStr.equals(node.getNamespaceURI());
        if (node.getNodeType() == 1) {
            NamedNodeMap attributes = node.getAttributes();
            i = 0;
            int attCount = attributes.getLength();
            while (i < attCount) {
                if ((namespaceMatch || namespaceStr.equals(attributes.item(i).getNamespaceURI())) && localName.equals(attributes.item(i).getLocalName())) {
                    if (storageType) {
                        matches.add(SMLPropertyFactory.create(attributes.item(i)));
                    } else {
                        matches.add(node);
                        return;
                    }
                }
                ++i;
            }
        }
        NodeList children = node.getChildNodes();
        i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            ItemPropertyHandler.retrieveProperty(children.item(i), namespace, localName, matches, storageType);
            ++i;
        }
    }
}

