/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.exceptions.SelectorHandleException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IPrefixMapping;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ISelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IXPath1Selector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.AbstractSMLSelectorHandler;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.CMDBfUtil;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.MappedNamespaceContext;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.w3c.dom.Node;

public class ItemXPathHandler
extends AbstractSMLSelectorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodes handle(INodes context, ISelector selector) throws SelectorHandleException {
        try {
            INodes result = this.retrieveContext(context);
            IGraphElement[] elements = result.getElements();
            IXPath1Selector xpathSelector = (IXPath1Selector)selector;
            MappedNamespaceContext namespaceContext = new MappedNamespaceContext();
            IPrefixMapping[] prefixMapping = xpathSelector.getPrefixMappings();
            int i = 0;
            while (i < prefixMapping.length) {
                namespaceContext.addEntry(prefixMapping[i].getPrefix(), prefixMapping[i].getNamespace().toString());
                ++i;
            }
            ISMLRepository repository = this.getRepository();
            ArrayList<IGraphElement> revisedList = new ArrayList<IGraphElement>();
            int i2 = 0;
            while (i2 < elements.length) {
                XPath xPath = SMLValidatorUtil.xpath;
                synchronized (xPath) {
                    SMLValidatorUtil.xpath.setNamespaceContext((NamespaceContext)namespaceContext);
                    XPathExpression fieldXPath = SMLValidatorUtil.xpath.compile(xpathSelector.getXpathExpression());
                    Node rootNode = CMDBfUtil.retrieveDocumentNode(repository, (IItem)elements[i2]);
                    if (rootNode == null) {
                    } else {
                        String xpathResult = fieldXPath.evaluate(rootNode);
                        if (xpathResult == null || xpathResult.length() <= 0 || "false".equals(xpathResult)) {
                        } else {
                            revisedList.add(elements[i2]);
                        }
                    }
                }
                ++i2;
            }
            result.setElements(revisedList.toArray(new IGraphElement[revisedList.size()]));
            return result;
        }
        catch (XPathExpressionException e) {
            throw new SelectorHandleException((Throwable)e);
        }
        catch (RepositoryOperationException e) {
            throw new SelectorHandleException((Throwable)e);
        }
    }
}

