/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.ISensor;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.impl.SensorStatus;
import org.eclipse.hyades.logging.adapter.util.BasicFilterExit;
import org.eclipse.hyades.logging.adapter.util.FilterExitLoaderUtil;
import org.eclipse.hyades.logging.adapter.util.IFilterExit;
import org.eclipse.hyades.logging.adapter.util.ITimeFilterExit;
import org.eclipse.hyades.logging.adapter.util.InvalidFilterSpecification;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;

public abstract class Sensor
extends ProcessUnit
implements ISensor {
    private String type = null;
    protected int maximumBlocking = 1;
    protected boolean flushingMode = false;
    private boolean initialized = false;
    private String filter = null;
    private String filterExitClass = null;
    private IFilterExit filterExitClassInstance = null;
    protected int confidenceBufferSize = 1024;
    protected int fileFooterSize = 90;

    public Sensor() {
        this.status = new SensorStatus();
    }

    public Object[] getNext() {
        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Sensor_getNext_INFO_");
        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID()});
        event.setSeverity((short)10);
        this.log(event);
        return null;
    }

    public Object[] testGetNext() {
        return null;
    }

    public Object[] flush() {
        if (!this.initialized) {
            return null;
        }
        this.flushingMode = true;
        Object[] temp = this.getNext();
        this.flushingMode = false;
        return temp;
    }

    public void update() throws AdapterInvalidConfig {
        String attrValue;
        super.update();
        Element element = this.getConfiguration();
        String attrName = "maximumBlocking";
        if (element != null) {
            this.setType(element.getAttribute("type"));
            if (element.hasAttribute(attrName)) {
                attrValue = element.getAttribute(attrName);
                try {
                    this.maximumBlocking = Integer.valueOf(attrValue);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Integer_Attribute_Value_ERROR_", attrValue, attrName, this.getName()));
                }
            } else {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Required_Attribute_Missing_ERROR_", attrName, this.getName()));
            }
        }
        if (this.maximumBlocking <= 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Integer_Attribute_Value_ERROR_", Integer.toString(this.maximumBlocking), attrName, this.getName()));
        }
        attrName = "confidenceBufferSize";
        if (element != null && element.hasAttribute(attrName)) {
            attrValue = element.getAttribute(attrName);
            try {
                this.confidenceBufferSize = Integer.valueOf(attrValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Positive_Integer_Attribute_Value_ERROR_", attrValue, attrName, this.getName()));
            }
        }
        if (this.confidenceBufferSize < 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Positive_Integer_Attribute_Value_ERROR_", Integer.toString(this.confidenceBufferSize), attrName, this.getName()));
        }
        attrName = "fileFooterSize";
        if (element != null && element.hasAttribute(attrName)) {
            attrValue = element.getAttribute(attrName);
            try {
                this.fileFooterSize = Integer.valueOf(attrValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Positive_Integer_Attribute_Value_ERROR_", attrValue, attrName, this.getName()));
            }
        }
        if (this.fileFooterSize < 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Positive_Integer_Attribute_Value_ERROR_", Integer.toString(this.fileFooterSize), attrName, this.getName()));
        }
        Hashtable sensorProperties = this.getProperties();
        if (sensorProperties != null && !sensorProperties.isEmpty()) {
            block31: {
                this.filter = (String)sensorProperties.get("filter");
                this.filterExitClass = (String)sensorProperties.get("filterExitClass");
                if (this.filter != null) {
                    this.filter = this.filter.trim();
                    if (this.filter.length() == 0) {
                        this.filter = null;
                    }
                }
                if (this.filterExitClass != null) {
                    this.filterExitClass = this.filterExitClass.trim();
                    if (this.filterExitClass.length() == 0) {
                        this.filterExitClass = null;
                    }
                }
                if (this.filterExitClass != null && !this.filterExitClass.equals("")) {
                    try {
                        this.filterExitClassInstance = FilterExitLoaderUtil.instantiate(this.filterExitClass);
                        if (this.filter == null || this.filter.equals("")) break block31;
                        try {
                            this.filterExitClassInstance.setFilterSpecification(this.filter);
                            break block31;
                        }
                        catch (InvalidFilterSpecification ex) {
                            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_FilterExit_Invalid_FilterSpecification_ERROR_", this.filter), ex);
                        }
                    }
                    catch (AdapterInvalidConfig aicex) {
                        throw aicex;
                    }
                    catch (Exception exception) {
                        throw new AdapterInvalidConfig(Messages.getString("HyadesGA_FilterExit_GetFilterExit_Failure_ERROR_", this.filterExitClass));
                    }
                }
                if (this.filter != null && !this.filter.equals("")) {
                    this.filterExitClassInstance = new BasicFilterExit();
                    try {
                        this.filterExitClassInstance.setFilterSpecification(this.filter);
                    }
                    catch (InvalidFilterSpecification ex) {
                        throw new AdapterInvalidConfig(Messages.getString("HyadesGA_FilterExit_Invalid_FilterSpecification_ERROR_", this.filter), ex);
                    }
                }
            }
            if (this.filterExitClassInstance != null && this.filterExitClassInstance instanceof ITimeFilterExit) {
                ITimeFilterExit exit = (ITimeFilterExit)this.filterExitClassInstance;
                IComponent current = this;
                while (current != null) {
                    if (current instanceof Context) {
                        Context context = (Context)current;
                        exit.setDay(context.getDay());
                        exit.setMonth(context.getMonth());
                        exit.setYear(context.getYear());
                        exit.setTimezone(context.getTimezone());
                        exit.setLocale(context.getLocale());
                        exit.setULocale(context.getULocale());
                        break;
                    }
                    current = current.getParent();
                }
            }
        }
        this.initialized = true;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getType() {
        return this.type;
    }

    public IFilterExit getFilterExitClassInstance() {
        return this.filterExitClassInstance;
    }

    public int getMaximumBlocking() {
        return this.maximumBlocking;
    }

    public void setMaximumBlocking(int maximumBlocking) {
        this.maximumBlocking = maximumBlocking;
        this.updateConfigurationAttribute("maximumBlocking", Integer.toString(maximumBlocking));
    }

    public int getConfidenceBufferSize() {
        return this.confidenceBufferSize;
    }

    public void setConfidenceBufferSize(int confidenceBufferSize) {
        this.confidenceBufferSize = confidenceBufferSize;
        this.updateConfigurationAttribute("confidenceBufferSize", Integer.toString(confidenceBufferSize));
    }

    public int getFileFooterSize() {
        return this.fileFooterSize;
    }

    public void setFileFooterSize(int fileFooterSize) {
        this.fileFooterSize = fileFooterSize;
        this.updateConfigurationAttribute("fileFooterSize", Integer.toString(fileFooterSize));
    }
}

