/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.sample.components.query;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.event.RowHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.common.api.IDataResponseService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.api.impl.AbstractQuery;
import org.eclipse.cosmos.dc.common.api.impl.SimpleDataQueryResult;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.Dimension;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.sample.persistence.impl.StatisticalDatasetImpl;
import org.eclipse.cosmos.dc.sample.persistence.impl.StatisticalObservationImpl;
import org.eclipse.cosmos.dc.spec.capabilitiy.StatisticalQueryCapability;
import org.eclipse.cosmos.dc.spec.types.StatisticalObservation;
import org.eclipse.cosmos.dc.spec.types.StatisticalTuple;
import org.w3c.dom.Element;

@ManagedResource
public class StatisticalQuery
extends AbstractQuery
implements StatisticalQueryCapability {
    private static final Dimension[] EMPTY_DIMENSION_ARRAY = new Dimension[0];
    private SqlMapClient sqlMapper;
    private ProviderRegistry registry;
    private static Class[] supportedTypes = new Class[]{StatisticalTuple.class};
    private static String[] supportedDialects = new String[]{"StatPOJO"};

    public StatisticalQuery(ContributionManager manager, SqlMapClient sqlMapper, ProviderRegistry registry, Element binding) {
        super(manager);
        this.sqlMapper = sqlMapper;
        this.registry = registry;
        this.queryMap.put("StatisticalTuple", new ArrayList());
    }

    public Class[] getOutputTypes() {
        return supportedTypes;
    }

    public boolean acceptWireTarget(IWireTarget target) throws Exception {
        if (target instanceof IDataFilterService) {
            Class[] classArray = supportedTypes;
            int n = supportedTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class type = classArray[n2];
                if (((IDataFilterService)target).acceptType(type)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (target instanceof IDataTransformService) {
            Class[] classArray = supportedTypes;
            int n = supportedTypes.length;
            int n3 = 0;
            while (n3 < n) {
                Class type = classArray[n3];
                if (((IDataTransformService)target).acceptType(type)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        if (target instanceof IDataResponseService) {
            Class[] classArray = supportedTypes;
            int n = supportedTypes.length;
            int n4 = 0;
            while (n4 < n) {
                Class type = classArray[n4];
                if (((IDataResponseService)target).acceptType(type)) {
                    return true;
                }
                ++n4;
            }
            return false;
        }
        return false;
    }

    public String[] getSupportedDialects() {
        return supportedDialects;
    }

    public String[] getSupportedResponses() {
        return this.queryMap.keySet().toArray(new String[0]);
    }

    public boolean supportedQuery(String dialect, String response) {
        return this.queryMap.get(response) != null;
    }

    public IDataQueryResult query(String dialect, String response, String queryString, String source) throws Exception {
        throw new Exception("Unsupported dialalect/response request:" + dialect + "/" + response);
    }

    public IDataQueryResult pageQuery(String dialect, String response, String queryString, String source, int max, int start) throws Exception {
        throw new Exception("Unsupported dialalect/response request:" + dialect + "/" + response);
    }

    public IDataQueryResult dimensionQuery(String response, String dataset, String keyset, String dimension, Date start, Date stop) throws Exception {
        StatisticalDatasetImpl ds = (StatisticalDatasetImpl)this.sqlMapper.queryForObject("getStatisticalDataset", (Object)dataset);
        if (ds == null) {
            throw new Exception("Invalid Statistical Dataset requested:" + dataset);
        }
        DataSet set = this.registry.getDataSet(dataset);
        DimensionSet dimset = set.getDataFlow().getDimensionSet();
        if (!keyset.equals(dimset.getName())) {
            throw new Exception("Invalid Keyset for Statistical Dataset:" + dataset + " keyset is " + dimset.getName() + ", specified " + keyset);
        }
        Dimension[] dims = dimset.getDimensions().toArray(EMPTY_DIMENSION_ARRAY);
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        int dimIndex = -1;
        int currIndex = 1;
        Dimension[] dimensionArray = dims;
        int n = dims.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension dim = dimensionArray[n2];
            if (dim.getName().equals(dimension)) {
                dimIndex = currIndex;
                break;
            }
            ++currIndex;
            ++n2;
        }
        HashMap<String, Integer> queryMap = new HashMap<String, Integer>();
        queryMap.put("id", ds.getId());
        queryMap.put("keyEntry", dimIndex);
        List obs = this.sqlMapper.queryForList("getObservationsForDatasetKey", queryMap);
        result.setRawResponseCollection(new ArrayList());
        StatisticalTuple tuple = null;
        for (StatisticalObservationImpl ob : obs) {
            if (tuple == null || ob.getTimeStamp().after(tuple.getTimeStamp())) {
                if (tuple != null) {
                    result.add(tuple);
                }
                tuple = new StatisticalTuple();
                tuple.setTimeStamp(ob.getTimeStamp());
            }
            Dimension dim = dims[ob.getKeyEntry() - 1];
            StatisticalObservation stat = null;
            stat = "integral".equals(dim.getType()) ? new StatisticalObservation(dim.getName(), (Object)ob.getIntegralValue()) : ("continuous".equals(dim.getType()) ? new StatisticalObservation(dim.getName(), (Object)ob.getContinuousValue()) : new StatisticalObservation(dim.getName(), (Object)ob.getStringValue()));
            tuple.add(stat);
        }
        return result;
    }

    public IDataQueryResult keysetQuery(String response, String dataset, String keyset, Date start, Date stop) throws Exception {
        StatisticalDatasetImpl ds = (StatisticalDatasetImpl)this.sqlMapper.queryForObject("getStatisticalDataset", (Object)dataset);
        if (ds == null) {
            throw new Exception("Invalid Statistical Dataset requested:" + dataset);
        }
        DataSet set = this.registry.getDataSet(dataset);
        DimensionSet dimset = set.getDataFlow().getDimensionSet();
        if (!keyset.equals(dimset.getName())) {
            throw new Exception("Invalid Keyset for Statistical Dataset:" + dataset + " keyset is " + dimset.getName() + ", specified " + keyset);
        }
        Dimension[] dims = dimset.getDimensions().toArray(EMPTY_DIMENSION_ARRAY);
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        List obs = this.sqlMapper.queryForList("getObservationsForDataset", (Object)ds.getId());
        result.setRawResponseCollection(new ArrayList());
        StatisticalTuple tuple = null;
        for (StatisticalObservationImpl ob : obs) {
            if (tuple == null || ob.getTimeStamp().after(tuple.getTimeStamp())) {
                if (tuple != null) {
                    result.add(tuple);
                }
                tuple = new StatisticalTuple();
                tuple.setTimeStamp(ob.getTimeStamp());
            }
            Dimension dim = dims[ob.getKeyEntry() - 1];
            StatisticalObservation stat = null;
            stat = "integral".equals(dim.getType()) ? new StatisticalObservation(dim.getName(), (Object)ob.getIntegralValue()) : ("continuous".equals(dim.getType()) ? new StatisticalObservation(dim.getName(), (Object)ob.getContinuousValue()) : new StatisticalObservation(dim.getName(), (Object)ob.getStringValue()));
            tuple.add(stat);
        }
        return result;
    }

    public IDataQueryResult partialKeysetQuery(String response, String dataset, String keyset, String[] dimensions, Date start, Date stop) throws Exception {
        StatisticalDatasetImpl ds = (StatisticalDatasetImpl)this.sqlMapper.queryForObject("getStatisticalDataset", (Object)dataset);
        if (ds == null) {
            throw new Exception("Invalid Statistical Dataset requested:" + dataset);
        }
        DataSet set = this.registry.getDataSet(dataset);
        DimensionSet dimset = set.getDataFlow().getDimensionSet();
        if (!keyset.equals(dimset.getName())) {
            throw new Exception("Invalid Keyset for Statistical Dataset:" + dataset + " keyset is " + dimset.getName() + ", specified " + keyset);
        }
        Dimension[] dims = dimset.getDimensions().toArray(EMPTY_DIMENSION_ARRAY);
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        int currIndex = 1;
        HashMap<String, String> dimsMap = new HashMap<String, String>();
        String[] stringArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            String dimName = stringArray[n2];
            dimsMap.put(dimName, dimName);
            ++n2;
        }
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        Dimension[] dimensionArray = dims;
        int n3 = dims.length;
        n = 0;
        while (n < n3) {
            Dimension dim = dimensionArray[n];
            if (dimsMap.get(dim.getName()) != null) {
                keyList.add(new Integer(currIndex));
            }
            ++currIndex;
            ++n;
        }
        HashMap<String, Serializable> queryMap = new HashMap<String, Serializable>();
        queryMap.put("id", Integer.valueOf(ds.getId()));
        queryMap.put("keyList", keyList);
        List obs = this.sqlMapper.queryForList("getObservationsForDatasetPartialKeyset", queryMap);
        result.setRawResponseCollection(new ArrayList());
        StatisticalTuple tuple = null;
        for (StatisticalObservationImpl ob : obs) {
            if (tuple == null || ob.getTimeStamp().after(tuple.getTimeStamp())) {
                if (tuple != null) {
                    result.add(tuple);
                }
                tuple = new StatisticalTuple();
                tuple.setTimeStamp(ob.getTimeStamp());
            }
            Dimension dim = dims[ob.getKeyEntry() - 1];
            StatisticalObservation stat = null;
            stat = "integral".equals(dim.getType()) ? new StatisticalObservation(dim.getName(), (Object)ob.getIntegralValue()) : ("continuous".equals(dim.getType()) ? new StatisticalObservation(dim.getName(), (Object)ob.getContinuousValue()) : new StatisticalObservation(dim.getName(), (Object)ob.getStringValue()));
            tuple.add(stat);
        }
        return result;
    }

    public IDataQueryResult pagedDimensionQuery(String response, String dataset, String keyset, String dimension, Date start, Date stop, int pageStart, int pageSize) throws Exception {
        StatisticalDatasetImpl ds = (StatisticalDatasetImpl)this.sqlMapper.queryForObject("getStatisticalDataset", (Object)dataset);
        if (ds == null) {
            throw new Exception("Invalid Statistical Dataset requested:" + dataset);
        }
        DataSet set = this.registry.getDataSet(dataset);
        DimensionSet dimset = set.getDataFlow().getDimensionSet();
        if (!keyset.equals(dimset.getName())) {
            throw new Exception("Invalid Keyset for Statistical Dataset:" + dataset + " keyset is " + dimset.getName() + ", specified " + keyset);
        }
        Dimension[] dims = dimset.getDimensions().toArray(EMPTY_DIMENSION_ARRAY);
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        int dimIndex = -1;
        int currIndex = 1;
        Dimension[] dimensionArray = dims;
        int n = dims.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension dim = dimensionArray[n2];
            if (dim.getName().equals(dimension)) {
                dimIndex = currIndex;
                break;
            }
            ++currIndex;
            ++n2;
        }
        HashMap<String, Integer> queryMap = new HashMap<String, Integer>();
        queryMap.put("id", ds.getId());
        queryMap.put("keyEntry", dimIndex);
        result.setRawResponseCollection(new ArrayList());
        StatRowHandler rowHandler = new StatRowHandler(pageStart, pageSize, dims, (IDataQueryResult)result);
        this.sqlMapper.queryWithRowHandler("getObservationsForDatasetKey", queryMap, (RowHandler)rowHandler);
        return result;
    }

    public IDataQueryResult pagedKeysetQuery(String response, String dataset, String keyset, Date start, Date stop, int pageStart, int pageSize) throws Exception {
        StatisticalDatasetImpl ds = (StatisticalDatasetImpl)this.sqlMapper.queryForObject("getStatisticalDataset", (Object)dataset);
        if (ds == null) {
            throw new Exception("Invalid Statistical Dataset requested:" + dataset);
        }
        DataSet set = this.registry.getDataSet(dataset);
        DimensionSet dimset = set.getDataFlow().getDimensionSet();
        if (!keyset.equals(dimset.getName())) {
            throw new Exception("Invalid Keyset for Statistical Dataset:" + dataset + " keyset is " + dimset.getName() + ", specified " + keyset);
        }
        Dimension[] dims = dimset.getDimensions().toArray(EMPTY_DIMENSION_ARRAY);
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        result.setRawResponseCollection(new ArrayList());
        StatRowHandler rowHandler = new StatRowHandler(pageStart, pageSize, dims, (IDataQueryResult)result);
        this.sqlMapper.queryWithRowHandler("getObservationsForDataset", (Object)this.queryMap, (RowHandler)rowHandler);
        return result;
    }

    public IDataQueryResult pagedPartialKeysetQuery(String response, String dataset, String keyset, String[] dimensions, Date start, Date stop, int pageStart, int pageSize) throws Exception {
        StatisticalDatasetImpl ds = (StatisticalDatasetImpl)this.sqlMapper.queryForObject("getStatisticalDataset", (Object)dataset);
        if (ds == null) {
            throw new Exception("Invalid Statistical Dataset requested:" + dataset);
        }
        DataSet set = this.registry.getDataSet(dataset);
        DimensionSet dimset = set.getDataFlow().getDimensionSet();
        if (!keyset.equals(dimset.getName())) {
            throw new Exception("Invalid Keyset for Statistical Dataset:" + dataset + " keyset is " + dimset.getName() + ", specified " + keyset);
        }
        Dimension[] dims = dimset.getDimensions().toArray(EMPTY_DIMENSION_ARRAY);
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        int currIndex = 1;
        HashMap<String, String> dimsMap = new HashMap<String, String>();
        String[] stringArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            String dimName = stringArray[n2];
            dimsMap.put(dimName, dimName);
            ++n2;
        }
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        Dimension[] dimensionArray = dims;
        int n3 = dims.length;
        n = 0;
        while (n < n3) {
            Dimension dim = dimensionArray[n];
            if (dimsMap.get(dim.getName()) != null) {
                keyList.add(new Integer(currIndex));
            }
            ++currIndex;
            ++n;
        }
        HashMap<String, Serializable> queryMap = new HashMap<String, Serializable>();
        queryMap.put("id", Integer.valueOf(ds.getId()));
        queryMap.put("keyList", keyList);
        result.setRawResponseCollection(new ArrayList());
        StatRowHandler rowHandler = new StatRowHandler(pageStart, pageSize, dims, (IDataQueryResult)result);
        this.sqlMapper.queryWithRowHandler("getObservationsForDatasetPartialKeyset", (Object)ds.getId(), (RowHandler)rowHandler);
        return result;
    }

    private class StatRowHandler
    implements RowHandler {
        private Dimension[] dims;
        private IDataQueryResult result;
        private int start;
        private int size;
        private int current = 0;
        private int count = 0;
        private StatisticalTuple tuple = null;

        public StatRowHandler(int start, int size, Dimension[] dims, IDataQueryResult result) {
            this.start = start;
            this.size = size;
            this.result = result;
            this.dims = dims;
        }

        public void handleRow(Object valueObject) {
            ++this.current;
            if (this.count < this.size && this.current > this.start) {
                StatisticalObservationImpl ob = (StatisticalObservationImpl)valueObject;
                if (this.tuple == null || ob.getTimeStamp().after(this.tuple.getTimeStamp())) {
                    if (this.tuple != null) {
                        this.result.add((Object)this.tuple);
                        ++this.count;
                    }
                    this.tuple = new StatisticalTuple();
                    this.tuple.setTimeStamp(ob.getTimeStamp());
                }
                Dimension dim = this.dims[ob.getKeyEntry() - 1];
                StatisticalObservation stat = null;
                stat = "integral".equals(dim.getType()) ? new StatisticalObservation(dim.getName(), (Object)ob.getIntegralValue()) : ("continuous".equals(dim.getType()) ? new StatisticalObservation(dim.getName(), (Object)ob.getContinuousValue()) : new StatisticalObservation(dim.getName(), (Object)ob.getStringValue()));
                this.tuple.add(stat);
            }
        }
    }
}

