/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.api.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataQueryComponent;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.api.IDataResponseService;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.spi.IWireSource;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.mgmt.annotations.CreateManagedRelation;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery
implements IDataQueryService,
IWireSource {
    protected IDataQueryService _proxy;
    private static Class[] EMPTY_LIST = new Class[0];
    private HashMap<Class, Method> methodMap = new HashMap();
    private Method wireMethod;
    protected ArrayList<IWireTarget> targetList = new ArrayList();
    protected ArrayList<IDataResponseService> responseList = new ArrayList();
    protected HashMap<String, ArrayList<IDataQueryComponent>> queryMap = new HashMap();

    public AbstractQuery(ContributionManager manager) {
        this._proxy = (IDataQueryService)manager.manage((Object)this);
    }

    public abstract boolean acceptWireTarget(IWireTarget var1) throws Exception;

    private void constructWirePath(ArrayList<IDataQueryComponent> list, IDataQueryComponent current) {
        list.add(current);
        IWireSource source = current.getWireSource();
        if (source instanceof IDataQueryComponent) {
            this.constructWirePath(list, (IDataQueryComponent)((Object)source));
        }
    }

    @Override
    public void prepare() throws Exception {
        for (IDataResponseService response : this.responseList) {
            ArrayList<IDataQueryComponent> list = new ArrayList<IDataQueryComponent>();
            this.constructWirePath(list, response);
            this.queryMap.put(response.getResponseType(), list);
        }
    }

    @Override
    public void addResponse(IDataResponseService response) {
        this.responseList.add(response);
    }

    @Override
    @CreateManagedRelation(type="WireTarget", namespace="http://www.eclipse.org/xmlns/cosmos/1.0")
    public void addWireTarget(IWireTarget target) throws Exception {
        if (!(target instanceof IDataFilterService || target instanceof IDataTransformService || target instanceof IDataSinkService)) {
            throw new Exception("Invalid wire target type for DataQuery");
        }
        this.targetList.add(target);
        target.setWireSource(this);
    }

    @Override
    public IWireTarget[] getWireTargets() {
        return this.targetList.toArray(new IWireTarget[0]);
    }

    public void setWireMethod(Method wireMethod) {
        this.wireMethod = wireMethod;
    }

    public Method getWireMethod() {
        return this.wireMethod;
    }

    public void dispatch(Object obj) {
        Object[] args = new Object[]{obj};
        for (IWireTarget target : this.targetList) {
            if (!(target instanceof IDataQueryComponent)) {
                return;
            }
            if (!((IDataQueryComponent)target).isActive()) {
                return;
            }
            Method targetMethod = target.getWireMethod();
            if (targetMethod == null) continue;
            try {
                targetMethod.invoke((Object)target, args);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

