/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.remote.wsdm.registry;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.notification.remote.NotificationConsumerClient;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.DataSourceType;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.registry.util.RegistrySerializer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderRegistryClient
extends NotificationConsumerClient {
    private static final QName GET_DATASETS_FOR_SOURCE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "getDataSetsForSourceRequestType");
    private static final QName GET_DATASETS_FOR_FLOW_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "getDataSetsForFlowRequestType");
    private static final QName GET_DATA_SOURCE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "getDataSourceRequestType");
    private static final QName GET_DATA_SET_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "getDataSetRequestType");
    private static final QName GET_DATA_FLOW_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "getDataFlowRequestType");
    private static final QName GET_DATA_SOURCE_TYPE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "getDataSourceTypeRequestType");
    private static final QName GET_KEY_SET_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "getDimensionSetRequestType");
    private static final QName GET_LATEST_DATASET_FOR_SOURCE_KEYSET_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "getLatestDataSetForSourceKeysetType");
    private static final QName REGISTER_DATA_SET_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDataSetRequestType");
    private static final QName REGISTER_DATA_SET_RESPONSE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDataSetResponseType");
    private static final QName REGISTER_DATA_FLOW_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDataFlowRequestType");
    private static final QName REGISTER_DATA_FLOW_RESPONSE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDataFlowResponseType");
    private static final QName REGISTER_DATA_SOURCE_TYPE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDataSourceTypeRequestType");
    private static final QName REGISTER_DATA_SOURCE_TYPE_RESPONSE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDataSourceTypeResponseType");
    private static final QName REGISTER_DATA_SOURCE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDataSourceRequestType");
    private static final QName REGISTER_DATA_SOURCE_RESPONSE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDataSourceResponseType");
    private static final QName REGISTER_KEYSET_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDimensionSetRequestType");
    private static final QName REGISTER_KEYSET_RESPONSE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "registerDimensionSetResponseType");
    private static final QName UPDATE_DATA_SET_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "updateDataSetRequestType");
    private static final QName UPDATE_DATA_SET_RESPONSE_QNAME = new QName("http://cosmos.eclipse.org/capabilities/registry", "updateDataSetResponseType");
    private static final QName PARAMETER_1 = new QName("http://cosmos.eclipse.org/capabilities/registry", "parm1");
    private static final QName PARAMETER_2 = new QName("http://cosmos.eclipse.org/capabilities/registry", "parm2");

    public ProviderRegistryClient(EndpointReference ref) {
        super(ref);
    }

    public Collection<DataFlow> getAllDataFlows() {
        return null;
    }

    public Collection<DataSet> getAllDataSets() {
        return null;
    }

    public Collection<DataSource> getAllDataSources() {
        return null;
    }

    public DataSet getDataSet(String name) throws Exception {
        DataSet ds = null;
        String action = "http://cosmos.eclipse.org/capabilities/registry/getDataSet";
        Element soapBody = XmlUtils.createElement((QName)GET_DATA_SET_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(name);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://cosmos.eclipse.org/capabilities/registry", (String)"DataSet");
        if (children != null && children.length == 1) {
            ds = (DataSet)RegistrySerializer.getDataSetSerializer().fromXML(children[0]);
        }
        return ds;
    }

    public DataFlow getDataFlow(String name) throws Exception {
        DataFlow df = null;
        String action = "http://cosmos.eclipse.org/capabilities/registry/getDataFlow";
        Element soapBody = XmlUtils.createElement((QName)GET_DATA_FLOW_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(name);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://cosmos.eclipse.org/capabilities/registry", (String)"DataFlow");
        if (children != null && children.length == 1) {
            df = (DataFlow)RegistrySerializer.getDataFlowSerializer().fromXML(children[0]);
        }
        return df;
    }

    public Collection<DataSet> getDataSetsForFlow(String flow) throws Exception {
        String action = "http://cosmos.eclipse.org/capabilities/registry/getDataSetsForFlow";
        Element soapBody = XmlUtils.createElement((QName)GET_DATASETS_FOR_FLOW_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(flow);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://cosmos.eclipse.org/capabilities/registry", (String)"DataSet");
        ArrayList<DataSet> sets = new ArrayList<DataSet>();
        Element[] elementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Element child = elementArray[n2];
            sets.add((DataSet)RegistrySerializer.getDataSetSerializer().fromXML(child));
            ++n2;
        }
        return sets;
    }

    public Collection<DataSet> getDataSetsForSource(String source) throws Exception {
        String action = "http://cosmos.eclipse.org/capabilities/registry/getDataSetsForSource";
        Element soapBody = XmlUtils.createElement((QName)GET_DATASETS_FOR_SOURCE_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(source);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        System.out.println(XmlUtils.toString((Node)result));
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://cosmos.eclipse.org/capabilities/registry", (String)"DataSet");
        ArrayList<DataSet> sets = new ArrayList<DataSet>();
        Element[] elementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Element child = elementArray[n2];
            sets.add((DataSet)RegistrySerializer.getDataSetSerializer().fromXML(child));
            ++n2;
        }
        return sets;
    }

    public DataSource getDataSource(String name) throws Exception {
        DataSource ds = null;
        String action = "http://cosmos.eclipse.org/capabilities/registry/getDataSource";
        Element soapBody = XmlUtils.createElement((QName)GET_DATA_SOURCE_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(name);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://cosmos.eclipse.org/capabilities/registry", (String)"DataSource");
        if (children != null && children.length == 1) {
            ds = (DataSource)RegistrySerializer.getDataSourceSerializer().fromXML(children[0]);
        }
        return ds;
    }

    public DataSourceType getDataSourceType(String name) throws Exception {
        DataSourceType dst = null;
        String action = "http://cosmos.eclipse.org/capabilities/registry/getDataSourceType";
        Element soapBody = XmlUtils.createElement((QName)GET_DATA_SOURCE_TYPE_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(name);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://cosmos.eclipse.org/capabilities/registry", (String)"DataSourceType");
        if (children != null && children.length == 1) {
            dst = (DataSourceType)RegistrySerializer.getDataSourceTypeSerializer().fromXML(children[0]);
        }
        return dst;
    }

    public DimensionSet getDimensionSet(String name) throws Exception {
        DimensionSet dims = null;
        String action = "http://cosmos.eclipse.org/capabilities/registry/getDimensionSetType";
        Element soapBody = XmlUtils.createElement((QName)GET_KEY_SET_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(name);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://cosmos.eclipse.org/capabilities/registry", (String)"KeySet");
        if (children != null && children.length == 1) {
            dims = (DimensionSet)RegistrySerializer.getKeySetSerializer().fromXML(children[0]);
        }
        return dims;
    }

    public boolean registerDataFlow(DataFlow flow) throws Exception {
        Element flowElement = RegistrySerializer.getDataFlowSerializer().toXML((Object)flow, ProviderRegistry.DATAFLOW_QNAME);
        String action = "http://cosmos.eclipse.org/capabilities/registry/registerDataFlowType";
        Element soapBody = XmlUtils.createElement((QName)REGISTER_DATA_FLOW_QNAME);
        soapBody.appendChild(flowElement);
        Element result = this.invoke(action, soapBody);
        result = XmlUtils.getElement((Node)result, (QName)REGISTER_DATA_FLOW_RESPONSE_QNAME);
        return result != null && "true".equals(result.getTextContent());
    }

    public boolean registerDataSet(DataSet ds) throws Exception {
        Element setElement = RegistrySerializer.getDataSetSerializer().toXML((Object)ds, ProviderRegistry.DATASET_QNAME);
        String action = "http://cosmos.eclipse.org/capabilities/registry/registerDataSet";
        Element soapBody = XmlUtils.createElement((QName)REGISTER_DATA_SET_QNAME);
        soapBody.appendChild(setElement);
        Element result = this.invoke(action, soapBody);
        result = XmlUtils.getElement((Node)result, (QName)REGISTER_DATA_SET_RESPONSE_QNAME);
        return result != null && "true".equals(result.getTextContent());
    }

    public boolean registerDataSourceType(DataSourceType src) throws Exception {
        Element srcElement = RegistrySerializer.getDataSourceTypeSerializer().toXML((Object)src, ProviderRegistry.DATASOURCE_QNAME);
        String action = "http://cosmos.eclipse.org/capabilities/registry/registerDataSourceType";
        Element soapBody = XmlUtils.createElement((QName)REGISTER_DATA_SOURCE_TYPE_QNAME);
        soapBody.appendChild(srcElement);
        Element result = this.invoke(action, soapBody);
        result = XmlUtils.getElement((Node)result, (QName)REGISTER_DATA_SOURCE_TYPE_RESPONSE_QNAME);
        return result != null && "true".equals(result.getTextContent());
    }

    public boolean registerDimensionSet(DimensionSet dims) throws Exception {
        Element dimsElement = RegistrySerializer.getKeySetSerializer().toXML((Object)dims, ProviderRegistry.KEYSET_QNAME);
        String action = "http://cosmos.eclipse.org/capabilities/registry/registerDimensionSet";
        Element soapBody = XmlUtils.createElement((QName)REGISTER_KEYSET_QNAME);
        soapBody.appendChild(dimsElement);
        Element result = this.invoke(action, soapBody);
        result = XmlUtils.getElement((Node)result, (QName)REGISTER_KEYSET_RESPONSE_QNAME);
        return result != null && "true".equals(result.getTextContent());
    }

    public boolean registerDataSource(DataSource src) throws Exception {
        Element srcElement = RegistrySerializer.getDataSourceSerializer().toXML((Object)src, ProviderRegistry.DATASOURCE_QNAME);
        String action = "http://cosmos.eclipse.org/capabilities/registry/registerDataSource";
        Element soapBody = XmlUtils.createElement((QName)REGISTER_DATA_SOURCE_QNAME);
        soapBody.appendChild(srcElement);
        Element result = this.invoke(action, soapBody);
        result = XmlUtils.getElement((Node)result, (QName)REGISTER_DATA_SOURCE_RESPONSE_QNAME);
        return result != null && "true".equals(result.getTextContent());
    }

    public boolean updateDataSet(DataSet ds) throws Exception {
        Element setElement = RegistrySerializer.getDataSetSerializer().toXML((Object)ds, ProviderRegistry.DATASET_QNAME);
        String action = "http://cosmos.eclipse.org/capabilities/registry/updateDataSet";
        Element soapBody = XmlUtils.createElement((QName)UPDATE_DATA_SET_QNAME);
        soapBody.appendChild(setElement);
        Element result = this.invoke(action, soapBody);
        result = XmlUtils.getElement((Node)result, (QName)UPDATE_DATA_SET_RESPONSE_QNAME);
        return result != null && "true".equals(result.getTextContent());
    }

    public DataSet getLatestDataSetForSourceKeyset(String source, String keyset) throws Exception {
        DataSet ds = null;
        String action = "http://cosmos.eclipse.org/capabilities/registry/getLatestDataSetForSourceKeyset";
        Element soapBody = XmlUtils.createElement((QName)GET_LATEST_DATASET_FOR_SOURCE_KEYSET_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(source);
        soapBody.appendChild(parm);
        parm = XmlUtils.createElement((QName)PARAMETER_2);
        parm.setTextContent(keyset);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://cosmos.eclipse.org/capabilities/registry", (String)"DataSet");
        if (children != null && children.length == 1) {
            ds = (DataSet)RegistrySerializer.getDataSetSerializer().fromXML(children[0]);
        }
        return ds;
    }
}

