/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.remote.wsdm.spec;

import java.net.InetAddress;
import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.eclipse.cosmos.dc.remote.wsdm.api.ContextClient;
import org.eclipse.cosmos.dc.remote.wsdm.spec.DataBrokerClient;
import org.eclipse.cosmos.dc.remote.wsdm.spec.UtilityClient;
import org.eclipse.cosmos.dc.remote.wsdm.spi.RuntimeHostClient;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ManagementDomainClient
extends WsResourceClient {
    public static final String MANAGEMENT_DOMAIN_CONTEXT_NAME = "ManagementDomain.xml";
    public static final String MANAGEMENT_DOMAIN_EP = "/cosmos/services/org.eclipse.cosmos.dc.local.registry.ManagementDomain";
    public static final String MANAGEMENT_DOMAIN_RES_ID = "ManagementDomainIdentifierValue";
    public static final QName DOMAIN_GETBROKERS_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "getBrokers");
    public static final QName DOMAIN_REGISTER_BROKER_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "registerBroker");
    public static final QName DOMAIN_DEREGISTER_BROKER_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "deregisterBroker");
    public static final QName DOMAIN_PING_MANAGEMENTDOMAIN_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "pingManagementDomain");

    public ManagementDomainClient(EndpointReference epr) {
        super(epr);
    }

    public static EndpointReference getManagementDomainEPR(String hostAddress, int runtimePort) throws Exception {
        URI uri = UtilityClient.getURIAddress(hostAddress, MANAGEMENT_DOMAIN_EP, runtimePort);
        EndpointReference epr = new EndpointReference(uri);
        epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, (Object)MANAGEMENT_DOMAIN_RES_ID);
        return epr;
    }

    public static synchronized WsResourceClient loadManagementDomainContext(String hostAddress, int runtimePort) throws Exception {
        URI uri = UtilityClient.getURIAddress(hostAddress, UtilityClient.OSGI_RUNTIME_HOST, runtimePort);
        EndpointReference epr = new EndpointReference(uri);
        epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, (Object)"RuntimeIdentifierValue");
        RuntimeHostClient client = new RuntimeHostClient(epr);
        ContextClient context = client.loadContext(MANAGEMENT_DOMAIN_CONTEXT_NAME);
        client.getContexts();
        return context;
    }

    public DataBrokerClient getBrokerClientFromDomain(String brokerName) throws Exception {
        Element element;
        Element result = this.getBrokers(brokerName, null);
        String brokerAddress = null;
        String brokerResid = null;
        NodeList nodeList = result.getElementsByTagName("Address");
        int nodeCount = nodeList.getLength();
        int index = 0;
        while (index < nodeCount) {
            if (nodeList.item(index).getNodeType() == 1) {
                element = (Element)nodeList.item(index);
                brokerAddress = XmlUtils.extractText((Element)element);
            }
            ++index;
        }
        nodeList = result.getElementsByTagName("ResourceId");
        nodeCount = nodeList.getLength();
        index = 0;
        while (index < nodeCount) {
            if (nodeList.item(index).getNodeType() == 1) {
                element = (Element)nodeList.item(index);
                brokerResid = XmlUtils.extractText((Element)element);
            }
            ++index;
        }
        if (brokerAddress == null) {
            System.out.println("getBrokerFromDomain error: broker '" + brokerName + "' not found");
            return null;
        }
        URI brokerURI = URI.create(brokerAddress);
        EndpointReference brokerEPR = new EndpointReference(brokerURI);
        brokerEPR.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, brokerResid);
        String brokerHost = brokerURI.getHost();
        int brokerPort = brokerURI.getPort();
        if (brokerHost.equalsIgnoreCase("localhost") || brokerHost.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
            DataBrokerClient.loadDataBrokerContext(brokerHost, new Integer(brokerPort));
        }
        return new DataBrokerClient(brokerEPR);
    }

    public Element getBrokers(String brokerName, String classification) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability/getBrokers";
        Element soapBody = XmlUtils.createElement((QName)DOMAIN_GETBROKERS_QNAME);
        Element parmName = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "brokerName"));
        if (brokerName != null) {
            parmName.setTextContent(brokerName);
        }
        soapBody.appendChild(parmName);
        Element parmClass = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "classification"));
        if (classification != null) {
            parmClass.setTextContent(classification);
        }
        soapBody.appendChild(parmClass);
        Element result = this.invoke(action, soapBody);
        return result;
    }

    public Element registerBroker(String endpointAddress, String endpointResourceId, String brokerName, String classification) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability/registerBroker";
        Element soapBody = XmlUtils.createElement((QName)DOMAIN_REGISTER_BROKER_QNAME);
        Element elepr = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "endpointAddress"));
        if (endpointAddress != null) {
            elepr.setTextContent(endpointAddress);
        }
        Element elresid = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "endpointResourceId"));
        if (endpointResourceId != null) {
            elresid.setTextContent(endpointResourceId);
        }
        Element elName = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "brokerName"));
        if (brokerName != null) {
            elName.setTextContent(brokerName);
        }
        Element elClassification = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "classification"));
        if (classification != null) {
            elClassification.setTextContent(classification);
        }
        soapBody.appendChild(elepr);
        soapBody.appendChild(elresid);
        soapBody.appendChild(elName);
        soapBody.appendChild(elClassification);
        Element result = this.invoke(action, soapBody);
        return result;
    }

    public Element deregisterBroker(String brokerName) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability/deregisterBroker";
        Element soapBody = XmlUtils.createElement((QName)DOMAIN_DEREGISTER_BROKER_QNAME);
        Element elName = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "brokerName"));
        if (brokerName != null) {
            elName.setTextContent(brokerName);
        }
        soapBody.appendChild(elName);
        Element result = this.invoke(action, soapBody);
        return result;
    }

    public Element pingManagementDomain(String brokerName) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability/pingManagementDomain";
        Element soapBody = XmlUtils.createElement((QName)DOMAIN_PING_MANAGEMENTDOMAIN_QNAME);
        Element elName = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/ManagementDomainCapability", "brokerName"));
        if (brokerName != null) {
            elName.setTextContent(brokerName);
        }
        soapBody.appendChild(elName);
        Element result = this.invoke(action, soapBody);
        return result;
    }
}

