/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.remote.wsdm.spi;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.notification.remote.NotificationConsumerClient;
import org.eclipse.cosmos.dc.remote.wsdm.api.ContextClient;
import org.eclipse.cosmos.dc.remote.wsdm.api.InboundContextClient;
import org.eclipse.cosmos.dc.remote.wsdm.api.OutboundContextClient;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeHostClient
extends NotificationConsumerClient {
    private static final QName GET_CONTEXT_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost", "getContextForNameRequestType");
    private static final QName GET_CONTEXTS_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost", "getContextsRequestType");
    private static final QName LOAD_CONTEXT_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost", "loadContextRequestType");
    private static final QName UNLOAD_CONTEXT_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost", "unloadContextRequestType");
    private static final QName PARAMETER_1 = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost", "parm1");

    public RuntimeHostClient(EndpointReference destination) {
        super(destination);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public ContextClient loadContext(String name) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost/loadContext";
        Element soapBody = XmlUtils.createElement((QName)LOAD_CONTEXT_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(name);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://www.eclipse.org/xmlns/cosmos/1.0", (String)"context");
        if (children != null && children.length == 1) {
            Element child = children[0];
            Element epr = XmlUtils.getElement((Node)child, (QName)WsaConstants.EPR_QNAME);
            if ("in".equals(child.getAttribute("direction"))) {
                return new InboundContextClient(new EndpointReference(epr), child.getAttribute("name"));
            }
            return new OutboundContextClient(new EndpointReference(epr), child.getAttribute("name"));
        }
        return null;
    }

    public void unloadContext(String name) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost/unloadContext";
        Element soapBody = XmlUtils.createElement((QName)UNLOAD_CONTEXT_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(name);
        soapBody.appendChild(parm);
        this.invoke(action, soapBody);
    }

    public ContextClient getContextForName(String name) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost/getContextForName";
        Element soapBody = XmlUtils.createElement((QName)GET_CONTEXT_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        parm.setTextContent(name);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://www.eclipse.org/xmlns/cosmos/1.0", (String)"context");
        if (children != null && children.length == 1) {
            Element child = children[0];
            Element epr = XmlUtils.getElement((Node)child, (QName)WsaConstants.EPR_QNAME);
            if ("in".equals(child.getAttribute("direction"))) {
                return new InboundContextClient(new EndpointReference(epr), child.getAttribute("name"));
            }
            return new OutboundContextClient(new EndpointReference(epr), child.getAttribute("name"));
        }
        return null;
    }

    public Collection<ContextClient> getContexts() throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost/getContexts";
        Element soapBody = XmlUtils.createElement((QName)GET_CONTEXTS_QNAME);
        Element parm = XmlUtils.createElement((QName)PARAMETER_1);
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        Element[] children = XmlUtils.getAllElements((Node)result, (String)"http://www.eclipse.org/xmlns/cosmos/1.0", (String)"context");
        ArrayList<ContextClient> clients = new ArrayList<ContextClient>();
        Element[] elementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Element child = elementArray[n2];
            Element epr = XmlUtils.getElement((Node)child, (QName)WsaConstants.EPR_QNAME);
            if ("in".equals(child.getAttribute("direction"))) {
                clients.add(new InboundContextClient(new EndpointReference(epr), child.getAttribute("name")));
            } else {
                clients.add(new OutboundContextClient(new EndpointReference(epr), child.getAttribute("name")));
            }
            ++n2;
        }
        return clients;
    }
}

