/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.routing;

import java.io.File;
import java.io.IOException;
import org.apache.muse.core.AbstractFilePersistence;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.routing.RouterPersistence;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RouterFilePersistence
extends AbstractFilePersistence
implements RouterPersistence {
    protected void createResourceFile(EndpointReference epr, Resource resource, File resourceFile) throws SoapFault {
        try {
            Element eprXML = epr.toXML();
            Element params = XmlUtils.getElement(eprXML, WsaConstants.PARAMETERS_QNAME);
            if (params == null) {
                params = XmlUtils.createElement(WsaConstants.PARAMETERS_QNAME);
            }
            XmlUtils.toFile(params, resourceFile);
        }
        catch (IOException error) {
            throw new SoapFault(error);
        }
    }

    protected String getFilePrefix() {
        return "resource-instance-";
    }

    protected Resource reloadResource(String contextPath, Element resourceXML) throws SoapFault {
        ResourceManager manager = this.getResourceManager();
        Document doc = resourceXML.getOwnerDocument();
        Element eprXML = XmlUtils.createElement(doc, WsaConstants.EPR_QNAME);
        eprXML.appendChild(resourceXML);
        String address = manager.getEnvironment().getDefaultURI();
        int lastSlash = address.lastIndexOf(47);
        address = address.substring(0, lastSlash + 1) + contextPath;
        XmlUtils.setElement(eprXML, WsaConstants.ADDRESS_QNAME, address);
        EndpointReference epr = new EndpointReference(eprXML);
        Resource resource = manager.createResource(contextPath);
        resource.setEndpointReference(epr);
        resource.initialize();
        manager.addResource(epr, resource);
        return resource;
    }

    public void resourceAdded(EndpointReference epr, Resource resource) throws SoapFault {
        String contextPath = resource.getContextPath();
        if (this.getResourceManager().isUsingPersistence(contextPath)) {
            this.createResourceFile(epr, resource);
        }
    }

    public void resourceRemoved(EndpointReference epr) throws SoapFault {
        String contextPath = this.getContextPath(epr);
        if (this.getResourceManager().isUsingPersistence(contextPath)) {
            this.destroyResourceFile(epr);
        }
    }
}

