/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.OlapQueryUtil;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.ICubeQueryUtil;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.DataRequestSessionImpl;
import org.eclipse.birt.report.data.adapter.impl.DataSetIterator;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;

public class CubeQueryUtil
implements ICubeQueryUtil {
    private DataRequestSessionImpl session;

    public CubeQueryUtil(DataRequestSessionImpl session) {
        this.session = session;
    }

    public List getReferableBindings(String targetLevel, ICubeQueryDefinition cubeDefn, boolean isSort) throws AdapterException {
        try {
            List bindings = cubeDefn.getBindings();
            if (bindings == null) {
                return new ArrayList();
            }
            DimLevel target = OlapExpressionUtil.getTargetDimLevel((String)targetLevel);
            ArrayList<IBinding> result = new ArrayList<IBinding>();
            int i = 0;
            while (i < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(i);
                Set refDimLevel = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)binding.getExpression(), (List)bindings, (boolean)isSort);
                if (refDimLevel.size() <= 1) {
                    if (!refDimLevel.contains(target)) {
                        List aggrOns = binding.getAggregatOns();
                        if (aggrOns.size() == 0 && this.getReferencedMeasureName(binding.getExpression()) != null) {
                            result.add(binding);
                        } else {
                            int j = 0;
                            while (j < aggrOns.size()) {
                                DimLevel dimLevel = OlapExpressionUtil.getTargetDimLevel((String)aggrOns.get(j).toString());
                                if (dimLevel.equals((Object)target)) {
                                    if (j == aggrOns.size() - 1) {
                                        result.add(binding);
                                        break;
                                    }
                                    DimLevel next = OlapExpressionUtil.getTargetDimLevel((String)aggrOns.get(j + 1).toString());
                                    if (this.getAxisQualifierLevel(next, cubeDefn.getEdge(this.getAxisQualifierEdgeType(dimLevel, cubeDefn))) != null) {
                                        result.add(binding);
                                        break;
                                    }
                                }
                                ++j;
                            }
                        }
                    } else {
                        result.add(binding);
                    }
                }
                ++i;
            }
            return result;
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    public List getReferencedLevels(String targetLevel, String bindingExpr, ICubeQueryDefinition queryDefn) throws AdapterException {
        try {
            ArrayList<ILevelDefinition> result = new ArrayList<ILevelDefinition>();
            DimLevel target = OlapExpressionUtil.getTargetDimLevel((String)targetLevel);
            String bindingName = OlapExpressionCompiler.getReferencedScriptObject((String)bindingExpr, (String)"data");
            if (bindingName == null) {
                return result;
            }
            IBinding binding = null;
            List bindings = queryDefn.getBindings();
            int i = 0;
            while (i < bindings.size()) {
                IBinding bd = (IBinding)bindings.get(i);
                if (bd.getBindingName().equals(bindingName)) {
                    binding = bd;
                    break;
                }
                ++i;
            }
            if (binding == null) {
                return result;
            }
            List aggrOns = binding.getAggregatOns();
            boolean isMeasure = false;
            if (aggrOns.size() == 0) {
                isMeasure = this.getReferencedMeasureName(binding.getExpression()) != null;
            }
            IEdgeDefinition axisQualifierEdge = queryDefn.getEdge(this.getAxisQualifierEdgeType(target, queryDefn));
            if (isMeasure) {
                int i2 = 0;
                while (i2 < axisQualifierEdge.getDimensions().size()) {
                    IHierarchyDefinition hier = (IHierarchyDefinition)((IDimensionDefinition)axisQualifierEdge.getDimensions().get(i2)).getHierarchy().get(0);
                    result.addAll(hier.getLevels());
                    ++i2;
                }
            } else {
                int i3 = 0;
                while (i3 < aggrOns.size()) {
                    DimLevel dimLevel = OlapExpressionUtil.getTargetDimLevel((String)aggrOns.get(i3).toString());
                    ILevelDefinition lvl = this.getAxisQualifierLevel(dimLevel, axisQualifierEdge);
                    if (lvl != null) {
                        result.add(lvl);
                    }
                    ++i3;
                }
            }
            return result;
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private ILevelDefinition getAxisQualifierLevel(DimLevel dimLevel, IEdgeDefinition edge) {
        if (edge == null) {
            return null;
        }
        List dims = edge.getDimensions();
        int i = 0;
        while (i < dims.size()) {
            IDimensionDefinition dim = (IDimensionDefinition)dims.get(i);
            if (!dim.getName().equals(dimLevel.getDimensionName())) {
                return null;
            }
            IHierarchyDefinition hier = (IHierarchyDefinition)dim.getHierarchy().get(0);
            List levels = hier.getLevels();
            int j = 0;
            while (j < levels.size()) {
                ILevelDefinition level = (ILevelDefinition)levels.get(j);
                if (level.getName().equals(dimLevel.getLevelName())) {
                    return level;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private int getAxisQualifierEdgeType(DimLevel dimLevel, ICubeQueryDefinition queryDefn) {
        IEdgeDefinition edge = queryDefn.getEdge(2);
        if (edge == null) {
            return 1;
        }
        List dims = edge.getDimensions();
        int i = 0;
        while (i < dims.size()) {
            IDimensionDefinition dim = (IDimensionDefinition)dims.get(i);
            if (dim.getName().equals(dimLevel.getDimensionName())) {
                return 1;
            }
            ++i;
        }
        return 2;
    }

    public String getReferencedMeasureName(String expr) {
        return OlapExpressionCompiler.getReferencedScriptObject((String)expr, (String)"measure");
    }

    private String getReferencedMeasureName(IBaseExpression expr) {
        return OlapExpressionCompiler.getReferencedScriptObject((IBaseExpression)expr, (String)"measure");
    }

    public Iterator getMemberValueIterator(TabularCubeHandle cubeHandle, String dataBindingExpr, ICubeQueryDefinition queryDefn) throws AdapterException {
        Set dimLevels;
        block5: {
            block4: {
                try {
                    if (cubeHandle != null && dataBindingExpr != null && queryDefn != null) break block4;
                    return null;
                }
                catch (BirtException e) {
                    throw new AdapterException(e.getLocalizedMessage(), e);
                }
            }
            dimLevels = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)new ScriptExpression(dataBindingExpr), (List)queryDefn.getBindings(), (boolean)true);
            if (dimLevels.size() != 0 && dimLevels.size() <= 1) break block5;
            return null;
        }
        DimLevel target = (DimLevel)dimLevels.iterator().next();
        TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)cubeHandle.getDimension(target.getDimensionName()).getContent("hierarchies", 0);
        this.defineDataSourceAndDataSet(hierHandle.getDataSet());
        HashMap levelValueMap = new HashMap();
        DataSetIterator it = new DataSetIterator(this.session, hierHandle);
        return new MemberValueIterator(it, levelValueMap, target.getLevelName());
    }

    public Iterator getMemberValueIterator(TabularCubeHandle cubeHandle, String targetLevel, ILevelDefinition[] higherLevelDefns, Object[] values) throws AdapterException {
        block6: {
            if (!(higherLevelDefns == null && values != null || higherLevelDefns != null && values == null || cubeHandle == null) && targetLevel != null) break block6;
            return null;
        }
        try {
            DimLevel target = OlapExpressionUtil.getTargetDimLevel((String)targetLevel);
            TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)cubeHandle.getDimension(target.getDimensionName()).getContent("hierarchies", 0);
            this.defineDataSourceAndDataSet(hierHandle.getDataSet());
            HashMap<String, Object> levelValueMap = new HashMap<String, Object>();
            if (higherLevelDefns != null) {
                int i = 0;
                while (i < higherLevelDefns.length) {
                    if (target.getDimensionName().equals(higherLevelDefns[i].getHierarchy().getDimension().getName())) {
                        levelValueMap.put(higherLevelDefns[i].getName(), values[i]);
                    }
                    ++i;
                }
            }
            DataSetIterator it = new DataSetIterator(this.session, hierHandle);
            return new MemberValueIterator(it, levelValueMap, target.getLevelName());
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private void defineDataSourceAndDataSet(DataSetHandle dataSet) throws BirtException {
        IModelAdapter modelAdaptor = this.session.getModelAdaptor();
        DataSourceHandle dataSource = dataSet.getDataSource();
        if (dataSource != null) {
            this.session.defineDataSource((IBaseDataSourceDesign)modelAdaptor.adaptDataSource(dataSource));
        }
        if (dataSet instanceof JointDataSetHandle) {
            JointDataSetHandle jointDataSet = (JointDataSetHandle)dataSet;
            Iterator iter = jointDataSet.dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle childDataSet = (DataSetHandle)iter.next();
                if (childDataSet == null) continue;
                DataSourceHandle childDataSource = childDataSet.getDataSource();
                if (childDataSource != null) {
                    this.session.defineDataSource((IBaseDataSourceDesign)modelAdaptor.adaptDataSource(childDataSource));
                }
                this.defineDataSourceAndDataSet(childDataSet);
            }
        }
        this.session.defineDataSet((IBaseDataSetDesign)modelAdaptor.adaptDataSet(dataSet));
    }

    public List getInvalidBindings(ICubeQueryDefinition queryDefn) throws AdapterException {
        try {
            ArrayList<String> invalidBindingNameList = new ArrayList<String>();
            List invalidBinding = OlapQueryUtil.validateBinding((ICubeQueryDefinition)queryDefn, (boolean)true);
            int i = 0;
            while (i < invalidBinding.size()) {
                IBinding binding = (IBinding)invalidBinding.get(i);
                invalidBindingNameList.add(binding.getBindingName());
                ++i;
            }
            return invalidBindingNameList;
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private class MemberValueIterator
    implements Iterator {
        private IDatasetIterator dataSetIterator;
        private boolean hasNext;
        private Map levelValueMap;
        private String targetLevelName;
        private Object currentValue;

        public MemberValueIterator(IDatasetIterator it, Map levelValueMap, String targetLevelName) {
            this.dataSetIterator = it;
            this.hasNext = true;
            this.levelValueMap = levelValueMap;
            this.targetLevelName = targetLevelName;
            this.next();
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            block5: {
                if (this.hasNext) break block5;
                return null;
            }
            try {
                Object result = this.currentValue;
                boolean accept = false;
                while (this.dataSetIterator.next()) {
                    accept = true;
                    Iterator it = this.levelValueMap.keySet().iterator();
                    while (it.hasNext()) {
                        String key = it.next().toString();
                        Object value = this.levelValueMap.get(key);
                        if (ScriptEvalUtil.compare(value, (Object)this.dataSetIterator.getValue(this.dataSetIterator.getFieldIndex(key))) == 0) continue;
                        accept = false;
                        break;
                    }
                    if (!accept) continue;
                    this.currentValue = this.dataSetIterator.getValue(this.dataSetIterator.getFieldIndex(this.targetLevelName));
                    break;
                }
                this.hasNext = accept;
                return result;
            }
            catch (BirtException birtException) {
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

