/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.layout.TextStyle;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.w3c.dom.css.CSSValue;

public class PDFPage
implements IPage {
    private PdfWriter writer = null;
    private static PdfTemplate totalPageTemplate = null;
    private PdfContentByte contentByte;
    private PdfContentByte cbUnder = null;
    private float pageHeight = 0.0f;
    private Logger logger;
    static /* synthetic */ Class class$0;

    public PDFPage(int pageWidth, int pageHeight, Document document, PdfWriter writer) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.pdf.PDFPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = Logger.getLogger(clazz.getName());
        float ratio = 1000.0f;
        this.pageHeight = (float)pageHeight / ratio;
        this.writer = writer;
        try {
            Rectangle pageSize = new Rectangle((float)pageWidth / ratio, (float)pageHeight / ratio);
            document.setPageSize(pageSize);
            if (!document.isOpen()) {
                document.open();
            } else {
                document.newPage();
            }
            this.contentByte = writer.getDirectContent();
            this.cbUnder = writer.getDirectContentUnder();
        }
        catch (DocumentException de) {
            this.logger.log(Level.SEVERE, de.getMessage(), de);
        }
    }

    static void reset() {
        totalPageTemplate = null;
    }

    public void clip(int startX, int startY, int width, int height) {
        this.clip(this.convertToPoint(startX), this.convertToPoint(startY), this.convertToPoint(width), this.convertToPoint(height));
    }

    private void clip(float startX, float startY, float width, float height) {
        startY = this.transformY(startY, height);
        this.contentByte.clip();
        this.contentByte.rectangle(startX, startY, width, height);
        this.contentByte.newPath();
        this.cbUnder.clip();
        this.cbUnder.rectangle(startX, startY, width, height);
        this.cbUnder.newPath();
    }

    public void clipRestore() {
        this.cbUnder.restoreState();
        this.contentByte.restoreState();
    }

    public void clipSave() {
        this.cbUnder.saveState();
        this.contentByte.saveState();
    }

    public void dispose() {
    }

    public void drawBackgroundColor(Color color, int x, int y, int width, int height) {
        this.drawBackgroundColor(color, this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height));
    }

    private void drawBackgroundColor(Color color, float x, float y, float width, float height) {
        if (color == null) {
            return;
        }
        y = this.transformY(y, height);
        this.cbUnder.saveState();
        this.cbUnder.setColorFill(color);
        this.cbUnder.rectangle(x, y, width, height);
        this.cbUnder.fill();
        this.cbUnder.restoreState();
    }

    public void drawBackgroundImage(int x, int y, int width, int height, String repeat, String imageUrl, int absPosX, int absPosY) throws IOException {
        this.drawBackgroundImage(this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height), repeat, imageUrl, this.convertToPoint(absPosX), this.convertToPoint(absPosY));
    }

    /*
     * Unable to fully structure code
     */
    public void drawBackgroundImage(float x, float y, float width, float height, String repeat, String imageUrl, float absPosX, float absPosY) throws IOException {
        block26: {
            y = this.transformY(y);
            this.cbUnder.saveState();
            img = null;
            try {
                img = Image.getInstance((String)imageUrl);
                if ("no-repeat".equalsIgnoreCase(repeat)) {
                    triple = this.computeTplHorizontalValPair(absPosX, x, width, img.scaledWidth());
                    tplOriginX = triple.getTplOrigin();
                    tplWidth = triple.getTplSize();
                    translationX = triple.getTranslation();
                    triple = this.computeTplVerticalValTriple(absPosY, y, height, img.scaledHeight());
                    tplOrininY = triple.getTplOrigin();
                    tplHeight = triple.getTplSize();
                    translationY = triple.getTranslation();
                    templateWhole = this.cbUnder.createTemplate(tplWidth, tplHeight);
                    templateWhole.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), translationX, translationY);
                    this.cbUnder.addTemplate(templateWhole, tplOriginX, tplOrininY);
                    break block26;
                }
                if ("repeat-x".equalsIgnoreCase(repeat)) {
                    remainX = width;
                    template = null;
                    if (width > img.scaledWidth()) {
                        if (height - absPosY > img.scaledHeight()) {
                            template = this.cbUnder.createTemplate(img.scaledWidth(), img.scaledHeight());
                            template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                        } else {
                            template = this.cbUnder.createTemplate(img.scaledWidth(), height);
                            template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + height);
                        }
                    }
                    while (remainX > 0.0f) {
                        if (remainX < img.scaledWidth()) {
                            if (height - absPosY > img.scaledHeight()) {
                                templateX = this.cbUnder.createTemplate(remainX, img.scaledHeight());
                                templateX.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                                this.cbUnder.addTemplate(templateX, x + width - remainX, y - absPosY - img.scaledHeight());
                            } else {
                                templateX = this.cbUnder.createTemplate(remainX, height);
                                templateX.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + height - absPosY);
                                this.cbUnder.addTemplate(templateX, x + width - remainX, y - absPosY - height);
                            }
                            remainX = 0.0f;
                            continue;
                        }
                        if (height - absPosY > img.scaledHeight()) {
                            this.cbUnder.addTemplate(template, x + width - remainX, y - absPosY - img.scaledHeight());
                        } else {
                            this.cbUnder.addTemplate(template, x + width - remainX, y - absPosY - height);
                        }
                        remainX -= img.scaledWidth();
                    }
                    break block26;
                }
                if ("repeat-y".equalsIgnoreCase(repeat)) {
                    remainY = height;
                    template = null;
                    if (height > img.scaledHeight()) {
                        template = this.cbUnder.createTemplate(width - absPosX > img.scaledWidth() ? img.scaledWidth() : width - absPosX, img.scaledHeight());
                        template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                    }
                    while (remainY > 0.0f) {
                        if (remainY < img.scaledHeight()) {
                            templateY = this.cbUnder.createTemplate(width - absPosX > img.scaledWidth() ? img.scaledWidth() : width - absPosX, remainY);
                            templateY.addImage(img, width > img.scaledWidth() ? img.scaledWidth() : width - absPosX, 0.0f, 0.0f, img.scaledHeight(), 0.0f, -(img.scaledHeight() - remainY));
                            this.cbUnder.addTemplate(templateY, x + absPosX, y - height);
                            remainY = 0.0f;
                            continue;
                        }
                        this.cbUnder.addTemplate(template, x + absPosX, y - height + remainY - img.scaledHeight());
                        remainY -= img.scaledHeight();
                    }
                    break block26;
                }
                if (!"repeat".equalsIgnoreCase(repeat)) break block26;
                remainX = width;
                remainY = height;
                template = null;
                if (width > img.scaledWidth() && height > img.scaledHeight()) {
                    template = this.cbUnder.createTemplate(img.scaledWidth(), img.scaledHeight());
                    template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                }
                while (remainY > 0.0f) {
                    remainX = width;
                    if (!(remainY < img.scaledHeight())) ** GOTO lbl97
                    while (remainX > 0.0f) {
                        if (remainX < img.scaledWidth()) {
                            templateXY = this.cbUnder.createTemplate(remainX, remainY);
                            templateXY.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + remainY);
                            this.cbUnder.addTemplate(templateXY, x + width - remainX, y - height);
                            remainX = 0.0f;
                            continue;
                        }
                        templateY = this.cbUnder.createTemplate(img.scaledWidth(), remainY);
                        templateY.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + remainY);
                        this.cbUnder.addTemplate(templateY, x + width - remainX, y - height);
                        remainX -= img.scaledWidth();
                    }
                    remainY = 0.0f;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        if (remainX < img.scaledWidth()) {
                            templateX = this.cbUnder.createTemplate(remainX, img.scaledHeight());
                            templateX.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                            this.cbUnder.addTemplate(templateX, x + width - remainX, y - height + remainY - img.scaledHeight());
                            remainX = 0.0f;
                            continue;
                        }
                        this.cbUnder.addTemplate(template, x + width - remainX, y - height + remainY - img.scaledHeight());
                        remainX -= img.scaledWidth();
lbl97:
                        // 3 sources

                        ** while (remainX > 0.0f)
                    }
lbl98:
                    // 1 sources

                    remainY -= img.scaledHeight();
                }
            }
            catch (IOException ioe) {
                this.logger.log(Level.WARNING, ioe.getMessage(), ioe);
            }
            catch (BadElementException bee) {
                this.logger.log(Level.WARNING, bee.getMessage(), bee);
            }
            catch (DocumentException de) {
                this.logger.log(Level.WARNING, de.getMessage(), de);
            }
            catch (RuntimeException re) {
                this.logger.log(Level.WARNING, re.getMessage(), re);
            }
        }
        this.cbUnder.restoreState();
    }

    public void drawImage(byte[] imageData, int imageX, int imageY, int height, int width, String helpText) throws Exception {
        Image image = Image.getInstance((byte[])imageData);
        this.drawImage(image, this.convertToPoint(imageX), this.convertToPoint(imageY), this.convertToPoint(height), this.convertToPoint(width), helpText);
    }

    public void drawImage(String uri, int imageX, int imageY, int height, int width, String helpText) throws Exception {
        Image image = Image.getInstance((URL)new URL(uri));
        this.drawImage(image, this.convertToPoint(imageX), this.convertToPoint(imageY), this.convertToPoint(height), this.convertToPoint(width), helpText);
    }

    public void drawLine(int startX, int startY, int endX, int endY, int width, Color color, String lineStyle) {
        this.drawLine(this.convertToPoint(startX), this.convertToPoint(startY), this.convertToPoint(endX), this.convertToPoint(endY), this.convertToPoint(width), color, lineStyle);
    }

    private void drawLine(float startX, float startY, float endX, float endY, float width, Color color, String lineStyle) {
        if (color == null || 0.0f == width || "none".equalsIgnoreCase(lineStyle)) {
            return;
        }
        this.contentByte.saveState();
        if ("solid".equalsIgnoreCase(lineStyle)) {
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        }
        if ("dashed".equalsIgnoreCase(lineStyle)) {
            this.contentByte.setLineDash(3.0f * width, 2.0f * width, 0.0f);
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        } else if ("dotted".equalsIgnoreCase(lineStyle)) {
            this.contentByte.setLineDash(width, width, 0.0f);
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        } else {
            if ("double".equalsIgnoreCase(lineStyle)) {
                return;
            }
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        }
        this.contentByte.restoreState();
    }

    public void drawText(String text, int textX, int textY, int width, int height, TextStyle fontStyle) {
        this.drawText(text, this.convertToPoint(textX), this.convertToPoint(textY), this.convertToPoint(width), this.convertToPoint(height), fontStyle.getFontInfo(), this.convertToPoint(fontStyle.getLetterSpacing()), this.convertToPoint(fontStyle.getWordSpacing()), fontStyle.getColor(), fontStyle.isLinethrough(), fontStyle.isOverline(), fontStyle.isUnderline(), fontStyle.getAlign(), false);
    }

    private void drawText(String text, float textX, float textY, float width, float height, FontInfo fontInfo, float characterSpacing, float wordSpacing, Color color, boolean linethrough, boolean overline, boolean underline, CSSValue align, boolean isTotoalPage) {
        this.drawText(text, textX, textY, fontInfo, characterSpacing, wordSpacing, color, align, isTotoalPage);
        PdfTemplate currentContentByte = isTotoalPage ? totalPageTemplate : this.contentByte;
        float lineWidth = fontInfo.getLineWidth();
        if (linethrough) {
            this.drawLine(textX, textY, width, lineWidth, this.convertToPoint(fontInfo.getLineThroughPosition()), color, (PdfContentByte)currentContentByte);
        }
        if (overline) {
            this.drawLine(textX, textY, width, lineWidth, this.convertToPoint(fontInfo.getOverlinePosition()), color, (PdfContentByte)currentContentByte);
        }
        if (underline) {
            this.drawLine(textX, textY, width, lineWidth, this.convertToPoint(fontInfo.getUnderlinePosition()), color, (PdfContentByte)currentContentByte);
        }
    }

    public void drawTotalPage(String text, int textX, int textY, int width, int height, TextStyle textInfo) {
        if (totalPageTemplate != null) {
            this.drawTotalPage(text, this.convertToPoint(textX), this.convertToPoint(textY), this.convertToPoint(width), this.convertToPoint(height), textInfo);
        }
    }

    private void drawTotalPage(String text, float textX, float textY, float width, float height, TextStyle textInfo) {
        this.drawText(text, textX, textY, width, height, textInfo.getFontInfo(), textInfo.getLetterSpacing(), textInfo.getWordSpacing(), textInfo.getColor(), textInfo.isLinethrough(), textInfo.isOverline(), textInfo.isUnderline(), textInfo.getAlign(), true);
    }

    public void createBookmark(String bookmark, int x, int y, int width, int height) {
        this.createBookmark(bookmark, this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height));
    }

    private void createBookmark(String bookmark, float x, float y, float width, float height) {
        this.contentByte.localDestination(bookmark, new PdfDestination(0, -1.0f, this.transformY(y), 0.0f));
    }

    public void createHyperlink(String hyperlink, String bookmark, String targetWindow, int type, int x, int y, int width, int height) {
        this.createHyperlink(hyperlink, bookmark, targetWindow, type, this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height));
    }

    private void createHyperlink(String hyperlink, String bookmark, String targetWindow, int type, float x, float y, float width, float height) {
        y = this.transformY(y, height);
        this.writer.addAnnotation(new PdfAnnotation(this.writer, x, y, x + width, y + height, this.createPdfAction(hyperlink, bookmark, targetWindow, type)));
    }

    public void createTotalPageTemplate(int x, int y, int width, int height) {
        this.createTotalPageTemplate(this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height));
    }

    private void createTotalPageTemplate(float x, float y, float width, float height) {
        if (totalPageTemplate == null) {
            totalPageTemplate = this.contentByte.createTemplate(width, height);
        }
        y = this.transformY(y, height);
        this.contentByte.saveState();
        this.contentByte.addTemplate(totalPageTemplate, x, y);
        this.contentByte.restoreState();
    }

    private void drawRawLine(float startX, float startY, float endX, float endY, float width, Color color, PdfContentByte contentByte) {
        startY = this.transformY(startY);
        endY = this.transformY(endY);
        contentByte.moveTo(startX, startY);
        contentByte.setLineWidth(width);
        contentByte.lineTo(endX, endY);
        contentByte.setColorStroke(color);
        contentByte.stroke();
    }

    private void drawText(String text, float textX, float textY, FontInfo fontInfo, float characterSpacing, float wordSpacing, Color color, CSSValue align, boolean isTotalPage) {
        PdfTemplate currentContentByte = isTotalPage ? totalPageTemplate : this.contentByte;
        float containerHeight = isTotalPage ? totalPageTemplate.getHeight() : this.pageHeight;
        currentContentByte.saveState();
        currentContentByte.beginText();
        if (color != null) {
            currentContentByte.setColorFill(color);
            currentContentByte.setColorStroke(color);
        }
        BaseFont font = fontInfo.getBaseFont();
        float fontSize = fontInfo.getFontSize();
        currentContentByte.setFontAndSize(font, fontSize);
        currentContentByte.setCharacterSpacing(characterSpacing);
        currentContentByte.setWordSpacing(wordSpacing);
        float baseline = this.convertToPoint(fontInfo.getBaseline());
        float transformedY = this.transformY(textY, baseline, containerHeight);
        this.placeText((PdfContentByte)currentContentByte, fontInfo, textX, transformedY);
        if (font.getFontType() == 3 && IStyle.JUSTIFY_VALUE.equals(align) && wordSpacing > 0.0f) {
            int idx = text.indexOf(32);
            if (idx >= 0) {
                float spaceCorrection = -wordSpacing * 1000.0f / fontSize;
                PdfTextArray textArray = new PdfTextArray(text.substring(0, idx));
                int lastIdx = idx;
                while ((idx = text.indexOf(32, lastIdx + 1)) >= 0) {
                    textArray.add(spaceCorrection);
                    textArray.add(text.substring(lastIdx, idx));
                    lastIdx = idx;
                }
                textArray.add(spaceCorrection);
                textArray.add(text.substring(lastIdx));
                currentContentByte.showText(textArray);
            } else {
                currentContentByte.showText(text);
            }
        } else {
            currentContentByte.showText(text);
        }
        currentContentByte.endText();
        currentContentByte.restoreState();
    }

    private void drawLine(float textX, float textY, float width, float lineWidth, float verticalOffset, Color color, PdfContentByte contentByte) {
        this.drawLine(textX, textY += verticalOffset, textX + width, textY, lineWidth, color, "solid", contentByte);
    }

    private float transformY(float y) {
        return this.pageHeight - y;
    }

    private float transformY(float y, float height) {
        return this.pageHeight - y - height;
    }

    private float transformY(float y, float height, float containerHeight) {
        return containerHeight - y - height;
    }

    private void drawLine(float startX, float startY, float endX, float endY, float width, Color color, String lineStyle, PdfContentByte contentByte) {
        if (color == null || 0.0f == width || "none".equalsIgnoreCase(lineStyle)) {
            return;
        }
        contentByte.saveState();
        if ("solid".equalsIgnoreCase(lineStyle)) {
            this.drawRawLine(startX, startY, endX, endY, width, color, contentByte);
        }
        if ("dashed".equalsIgnoreCase(lineStyle)) {
            contentByte.setLineDash(3.0f * width, 2.0f * width, 0.0f);
            this.drawRawLine(startX, startY, endX, endY, width, color, contentByte);
        } else if ("dotted".equalsIgnoreCase(lineStyle)) {
            contentByte.setLineDash(width, width, 0.0f);
            this.drawRawLine(startX, startY, endX, endY, width, color, contentByte);
        } else {
            if ("double".equalsIgnoreCase(lineStyle)) {
                return;
            }
            this.drawRawLine(startX, startY, endX, endY, width, color, contentByte);
        }
        contentByte.restoreState();
    }

    private PdfAction createPdfAction(String hyperlink, String bookmark, String target, int type) {
        if ("_top".equalsIgnoreCase(target) || "_parent".equalsIgnoreCase(target) || "_blank".equalsIgnoreCase(target) || "_self".equalsIgnoreCase(target)) {
            return new PdfAction(hyperlink);
        }
        if (type == 2) {
            return PdfAction.gotoLocalPage((String)bookmark, (boolean)false);
        }
        return PdfAction.gotoRemotePage((String)hyperlink, (String)bookmark, (boolean)false, (boolean)false);
    }

    private void placeText(PdfContentByte cb, FontInfo fi, float x, float y) {
        if (!fi.getSimulation()) {
            cb.setTextMatrix(x, y);
            return;
        }
        switch (fi.getFontStyle()) {
            case 2: {
                this.simulateItalic(cb, x, y);
                break;
            }
            case 1: {
                this.simulateBold(cb, x, y);
                break;
            }
            case 3: {
                this.simulateBold(cb, x, y);
                this.simulateItalic(cb, x, y);
            }
        }
    }

    private void simulateBold(PdfContentByte cb, float x, float y) {
        cb.setTextRenderingMode(2);
        cb.setLineWidth(0.9f);
        cb.setTextMatrix(x, y);
    }

    private void simulateItalic(PdfContentByte cb, float x, float y) {
        float alpha = (float)Math.tan(0.0);
        float beta = (float)Math.tan(0.2617993877991494);
        cb.setTextMatrix(1.0f, alpha, beta, 1.0f, x, y);
    }

    private TplValueTriple computeTplVerticalValTriple(float absPos, float containerBaseAbsPos, float containerSize, float ImageSize) {
        float tplOrigin = 0.0f;
        float tplSize = 0.0f;
        float translation = 0.0f;
        if (absPos <= 0.0f) {
            if (ImageSize + absPos > 0.0f && ImageSize + absPos <= containerSize) {
                tplOrigin = containerBaseAbsPos - ImageSize - absPos;
                tplSize = ImageSize + absPos;
            } else if (ImageSize + absPos > containerSize) {
                tplOrigin = containerBaseAbsPos - containerSize;
                tplSize = containerSize;
                translation = containerSize - ImageSize - absPos;
            }
        } else if (!(absPos >= containerSize)) {
            if (ImageSize + absPos <= containerSize) {
                tplOrigin = containerBaseAbsPos - ImageSize - absPos;
                tplSize = ImageSize;
                translation = 0.0f;
            } else {
                tplOrigin = containerBaseAbsPos - containerSize;
                tplSize = containerSize - absPos;
                translation = containerSize - absPos - ImageSize;
            }
        }
        return new TplValueTriple(tplOrigin, tplSize, translation);
    }

    private void showHelpText(float x, float y, float width, float height, String helpText) {
        Rectangle rectangle = new Rectangle(x, y, x + width, y + height);
        PdfAnnotation annotation = PdfAnnotation.createSquareCircle((PdfWriter)this.writer, (Rectangle)rectangle, (String)helpText, (boolean)true);
        PdfBorderDictionary borderStyle = new PdfBorderDictionary(0.0f, 0, null);
        annotation.setBorderStyle(borderStyle);
        annotation.setFlags(288);
        this.writer.addAnnotation(annotation);
    }

    private TplValueTriple computeTplHorizontalValPair(float absPos, float containerBaseAbsPos, float containerSize, float ImageSize) {
        float tplOrigin = 0.0f;
        float tplSize = 0.0f;
        float translation = 0.0f;
        if (absPos <= 0.0f) {
            if (ImageSize + absPos > 0.0f && ImageSize + absPos <= containerSize) {
                tplOrigin = containerBaseAbsPos;
                tplSize = ImageSize + absPos;
            } else if (ImageSize + absPos > containerSize) {
                tplOrigin = containerBaseAbsPos;
                tplSize = containerSize;
            }
            translation = absPos;
        } else if (!(absPos >= containerSize)) {
            if (ImageSize + absPos <= containerSize) {
                tplOrigin = containerBaseAbsPos + absPos;
                tplSize = ImageSize;
            } else {
                tplOrigin = containerBaseAbsPos + absPos;
                tplSize = containerSize - absPos;
            }
            translation = 0.0f;
        }
        return new TplValueTriple(tplOrigin, tplSize, translation);
    }

    private void drawImage(Image image, float imageX, float imageY, float height, float width, String helpText) throws DocumentException {
        imageY = this.transformY(imageY, height);
        this.contentByte.saveState();
        this.contentByte.addImage(image, width, 0.0f, 0.0f, height, imageX, imageY);
        if (helpText != null) {
            this.showHelpText(imageX, imageY, width, height, helpText);
        }
        this.contentByte.restoreState();
    }

    private float convertToPoint(int value) {
        return (float)value / 1000.0f;
    }

    private final class TplValueTriple {
        private final float tplOrigin;
        private final float tplSize;
        private final float translation;

        public TplValueTriple(float val1, float val2, float val3) {
            this.tplOrigin = val1;
            this.tplSize = val2;
            this.translation = val3;
        }

        float getTplOrigin() {
            return this.tplOrigin;
        }

        float getTplSize() {
            return this.tplSize;
        }

        float getTranslation() {
            return this.translation;
        }
    }
}

