/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.ir.DimensionType;

public abstract class HTMLEmitter {
    protected HTMLReportEmitter parentEmitter;
    protected HTMLWriter writer;
    protected boolean isEmbeddable;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.html.HTMLEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public HTMLEmitter(HTMLReportEmitter parentEmitter, HTMLWriter writer, boolean isEmbeddable) {
        this.parentEmitter = parentEmitter;
        this.writer = writer;
        this.isEmbeddable = isEmbeddable;
    }

    public abstract void buildStyle(IContent var1, StringBuffer var2);

    public abstract void buildTableStyle(ITableContent var1, StringBuffer var2, String var3);

    public abstract void buildColumnStyle(IColumn var1, StringBuffer var2);

    public abstract void buildRowStyle(IRowContent var1, StringBuffer var2);

    public abstract void buildCellStyle(ICellContent var1, StringBuffer var2, boolean var3);

    public abstract void handleCellAlign(ICellContent var1);

    public abstract void openContainerTag(IContainerContent var1);

    public abstract void closeContainerTag();

    public abstract void buildContainerStyle(IContainerContent var1, StringBuffer var2);

    public abstract void buildTextStyle(ITextContent var1, StringBuffer var2, int var3, String var4);

    public abstract void buildForeignStyle(IForeignContent var1, StringBuffer var2, int var3, String var4);

    public abstract void buildImageStyle(IImageContent var1, StringBuffer var2, int var3);

    public abstract void handleVerticalAlign(IStyle var1);

    public abstract void handleHorizontalAlign(IStyle var1);

    public abstract void handleVerticalAlignBegine(IContent var1);

    public abstract void handleVerticalAlignEnd(IContent var1);

    public void buildSize(StringBuffer content, String name, DimensionType value) {
        if (value != null) {
            content.append(' ');
            content.append(name);
            content.append(": ");
            content.append(value.toString());
            content.append(';');
        }
    }

    protected void addDefaultTableStyles(StringBuffer styleBuffer) {
        styleBuffer.append("border-collapse: collapse; empty-cells: show;");
    }

    public int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null || height != null) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }

    protected boolean handleShrink(int type, IStyle style, DimensionType height, DimensionType width, StringBuffer styleBuffer) {
        boolean canShrink;
        boolean bl = canShrink = style != null && "true".equalsIgnoreCase(style.getCanShrink());
        if ((type & 1) > 0) {
            this.buildSize(styleBuffer, "width", width);
            if (!canShrink) {
                this.buildSize(styleBuffer, "min-height", height);
            }
        } else if ((type & 2) > 0) {
            this.buildSize(styleBuffer, "height", height);
            if (!canShrink) {
                this.buildSize(styleBuffer, "min-width", width);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return canShrink;
    }

    protected void openInlineBoxTag() {
        this.writer.openTag("table");
        this.writer.attribute("style", " display:-moz-inline-box !important; display:inline;");
        this.writer.openTag("tr");
        this.writer.openTag("td");
    }

    protected void closeInlineBoxTag() {
        this.writer.closeTag("td");
        this.writer.closeTag("tr");
        this.writer.closeTag("table");
    }
}

