/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import com.ibm.icu.util.ULocale;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.HTMLEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLPerformanceOptimize;
import org.eclipse.birt.report.engine.emitter.html.HTMLVisionOptimize;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.html.IDGenerator;
import org.eclipse.birt.report.engine.emitter.html.MetadataEmitter;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.css.HTMLProcessor;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSValue;

public class HTMLReportEmitter
extends ContentEmitterAdapter {
    public static final String OUTPUT_FORMAT_HTML = "HTML";
    public static final String REPORT_FILE = "report.html";
    public static final String IMAGE_FOLDER = "image";
    protected OutputStream out = null;
    protected IReportContent report;
    protected IReportRunnable runnable;
    protected IRenderOption renderOption;
    protected boolean outputMasterPageContent = true;
    protected boolean isEmbeddable = false;
    protected String urlEncoding = null;
    protected boolean htmlRtLFlag = false;
    protected boolean pageFooterFloatFlag = true;
    protected boolean enableMetadata = false;
    protected List ouputInstanceIDs = null;
    protected int pageNo = 0;
    protected HTMLWriter writer;
    protected IReportContext reportContext;
    protected Stack stack = new Stack();
    protected static Logger logger;
    protected IHTMLImageHandler imageHandler;
    protected IHTMLActionHandler actionHandler;
    protected IEmitterServices services;
    protected static final int DISPLAY_BLOCK = 1;
    protected static final int DISPLAY_INLINE = 2;
    protected static final int DISPLAY_INLINE_BLOCK = 4;
    protected static final int DISPLAY_NONE = 8;
    protected static final int DISPLAY_FLAG_ALL = 65535;
    protected ContentEmitterVisitor contentVisitor;
    private MetadataEmitter metadataEmitter;
    private IDGenerator idGenerator = new IDGenerator();
    static HashMap borderStyleMap;
    private ICellContent leafCell;
    private boolean cellFilled = false;
    private String layoutPreference;
    private boolean enableAgentStyleEngine;
    private HTMLEmitter htmlEmitter;
    protected Stack startedGroups = new Stack();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
        borderStyleMap = null;
        borderStyleMap = new HashMap();
        borderStyleMap.put("none", new Integer(0));
        borderStyleMap.put("inset", new Integer(1));
        borderStyleMap.put("groove", new Integer(2));
        borderStyleMap.put("outset", new Integer(3));
        borderStyleMap.put("ridge", new Integer(4));
        borderStyleMap.put("dotted", new Integer(5));
        borderStyleMap.put("dashed", new Integer(6));
        borderStyleMap.put("solid", new Integer(7));
        borderStyleMap.put("double", new Integer(8));
    }

    public HTMLReportEmitter() {
        this.contentVisitor = new ContentEmitterVisitor((IContentEmitter)this);
    }

    public void initialize(IEmitterServices services) {
        Object ac;
        Object im;
        Object emitterConfig;
        this.services = services;
        Object fd = services.getOption("outputFile");
        File file = null;
        try {
            if (fd != null) {
                file = new File(fd.toString());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                this.out = new BufferedOutputStream(new FileOutputStream(file));
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (this.out == null) {
            Object value = services.getOption("outputStream");
            if (value != null && value instanceof OutputStream) {
                this.out = (OutputStream)value;
            } else {
                try {
                    file = new File(REPORT_FILE);
                    this.out = new BufferedOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        if ((emitterConfig = services.getEmitterConfig().get("html")) != null && emitterConfig instanceof HTMLEmitterConfig) {
            this.imageHandler = ((HTMLEmitterConfig)emitterConfig).getImageHandler();
            this.actionHandler = ((HTMLEmitterConfig)emitterConfig).getActionHandler();
        }
        if ((im = services.getOption("imageHandler")) != null && im instanceof IHTMLImageHandler) {
            this.imageHandler = (IHTMLImageHandler)im;
        }
        if ((ac = services.getOption("actionHandler")) != null && ac instanceof IHTMLActionHandler) {
            this.actionHandler = (IHTMLActionHandler)ac;
        }
        this.reportContext = services.getReportContext();
        this.renderOption = services.getRenderOption();
        this.runnable = services.getReportRunnable();
        this.writer = new HTMLWriter();
        if (this.renderOption != null) {
            HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
            this.isEmbeddable = htmlOption.getEmbeddable();
            HashMap options = this.renderOption.getOutputSetting();
            if (options != null) {
                this.urlEncoding = (String)options.get("url-encoding");
            }
            this.outputMasterPageContent = htmlOption.getMasterPageContent();
            IHTMLActionHandler actHandler = htmlOption.getActionHandle();
            if (ac != null) {
                this.actionHandler = actHandler;
            }
            this.pageFooterFloatFlag = htmlOption.getPageFooterFloatFlag();
            this.htmlRtLFlag = htmlOption.getHtmlRtLFlag();
            this.enableMetadata = htmlOption.getEnableMetadata();
            this.ouputInstanceIDs = htmlOption.getInstanceIDs();
            this.metadataEmitter = new MetadataEmitter(this.writer, htmlOption, this.idGenerator);
            this.layoutPreference = htmlOption.getLayoutPreference();
            this.enableAgentStyleEngine = htmlOption.getEnableAgentStyleEngine();
        }
        this.htmlEmitter = this.enableAgentStyleEngine ? new HTMLPerformanceOptimize(this, this.writer, this.isEmbeddable) : new HTMLVisionOptimize(this, this.writer, this.isEmbeddable);
    }

    public IReportContent getReport() {
        return this.report;
    }

    public String getOutputFormat() {
        return OUTPUT_FORMAT_HTML;
    }

    protected void fixTransparentPNG() {
        this.writer.writeCode("<!--[if gte IE 5.5000]>");
        this.writer.writeCode("   <script language=\"JavaScript\"> var ie55up = true </script>");
        this.writer.writeCode("<![endif]-->");
        this.writer.writeCode("<script language=\"JavaScript\">");
        this.writer.writeCode("   function fixPNG(myImage) // correctly handle PNG transparency in Win IE 5.5 or higher.");
        this.writer.writeCode("      {");
        this.writer.writeCode("      if (window.ie55up)");
        this.writer.writeCode("         {");
        this.writer.writeCode("         var imgID = (myImage.id) ? \"id='\" + myImage.id + \"' \" : \"\"");
        this.writer.writeCode("         var imgClass = (myImage.className) ? \"class='\" + myImage.className + \"' \" : \"\"");
        this.writer.writeCode("         var imgTitle = (myImage.title) ? \"title='\" + myImage.title + \"' \" : \"title='\" + myImage.alt + \"' \"");
        this.writer.writeCode("         var imgStyle = \"display:inline-block;\" + myImage.style.cssText");
        this.writer.writeCode("         var strNewHTML = \"<span \" + imgID + imgClass + imgTitle");
        this.writer.writeCode("         strNewHTML += \" style=\\\"\" + \"width:\" + myImage.width + \"px; height:\" + myImage.height + \"px;\" + imgStyle + \";\"");
        this.writer.writeCode("         strNewHTML += \"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\"");
        this.writer.writeCode("         strNewHTML += \"(src=\\'\" + myImage.src + \"\\', sizingMethod='scale');\\\"></span>\"");
        this.writer.writeCode("         myImage.outerHTML = strNewHTML");
        this.writer.writeCode("         }");
        this.writer.writeCode("      }");
        this.writer.writeCode("</script>");
    }

    public void start(IReportContent report) {
        String reportStyleName;
        StringBuffer styleBuffer;
        ReportDesignHandle designHandle;
        Report reportDesign;
        IStyle style;
        String reportStyleName2;
        logger.log(Level.FINE, "[HTMLReportEmitter] Start emitter.");
        this.report = report;
        this.writer.open(this.out, "UTF-8");
        if (this.htmlRtLFlag) {
            String string = reportStyleName2 = report == null ? null : report.getDesign().getRootStyleName();
            if (reportStyleName2 != null) {
                style = report.findStyle(reportStyleName2);
                style.setProperty(26, (CSSValue)IStyle.RIGHT_VALUE);
            }
        }
        if (this.layoutPreference == null && report != null) {
            reportDesign = report.getDesign();
            designHandle = reportDesign.getReportDesign();
            String reportLayoutPreference = designHandle.getLayoutPreference();
            if ("fixed layout".equals(reportLayoutPreference)) {
                this.layoutPreference = "fixed";
            } else if ("auto layout".equals(reportLayoutPreference)) {
                this.layoutPreference = "auto";
            }
        }
        if (this.isEmbeddable) {
            this.fixTransparentPNG();
            this.writer.openTag("div");
            if (report != null && (reportStyleName2 = report.getDesign().getRootStyleName()) != null) {
                style = report.findStyle(reportStyleName2);
                styleBuffer = new StringBuffer();
                AttributeBuilder.buildStyle(styleBuffer, style, this);
                this.writer.attribute("style", styleBuffer.toString());
            }
            return;
        }
        this.writer.startWriter();
        this.writer.openTag("html");
        this.writer.openTag("head");
        reportDesign = null;
        if (report != null) {
            reportDesign = report.getDesign();
            designHandle = reportDesign.getReportDesign();
            String title = designHandle.getStringProperty("title");
            if (title == null && this.renderOption != null) {
                HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
                title = htmlOption.getHtmlTitle();
            }
            if (title != null) {
                this.writer.openTag("title");
                this.writer.text(title);
                this.writer.closeTag("title");
            }
        }
        this.writer.openTag("META");
        this.writer.attribute("http-equiv", "Content-Type");
        this.writer.attribute("content", "text/html; charset=UTF-8");
        this.writer.closeNoEndTag();
        this.writer.openTag("style");
        this.writer.attribute("type", "text/css");
        styleBuffer = new StringBuffer();
        if (report == null) {
            logger.log(Level.WARNING, "[HTMLReportEmitter] Report object is null.");
        } else {
            Map styles = reportDesign.getStyles();
            Iterator iter = styles.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String styleName = (String)entry.getKey();
                style = (IStyle)entry.getValue();
                styleBuffer.setLength(0);
                AttributeBuilder.buildStyle(styleBuffer, style, this);
                String value = style.getVerticalAlign();
                if (value != null) {
                    styleBuffer.append(" vertical-align:");
                    styleBuffer.append(value);
                    styleBuffer.append(";");
                }
                if ((value = style.getTextAlign()) != null) {
                    styleBuffer.append(" text-align:");
                    styleBuffer.append(value);
                    styleBuffer.append(";");
                }
                this.writer.style(String.valueOf('.') + styleName, styleBuffer.toString());
            }
        }
        this.writer.closeTag("style");
        this.fixTransparentPNG();
        this.writer.closeTag("head");
        this.writer.openTag("body");
        if (report != null && (reportStyleName = report.getDesign().getRootStyleName()) != null) {
            this.writer.attribute("class", reportStyleName);
            this.writer.attribute("style", " margin:0px;");
        }
    }

    private void appendErrorMessage(EngineResourceHandle rc, int index, ExecutionContext.ElementExceptionInfo info) {
        this.writer.writeCode("\t\t\t<div>");
        this.writer.writeCode("\t\t\t\t<div  id=\"error_title\" style=\"text-decoration:underline\">");
        String name = info.getName();
        if (name != null) {
            this.writer.text(rc.getMessage("Error.ReportErrorMessage", new Object[]{info.getType(), name}), false);
        } else {
            this.writer.text(rc.getMessage("Error.ReportErrorMessageWithID", new Object[]{info.getType(), info.getID()}), false);
        }
        this.writer.writeCode("</div>");
        ArrayList errorList = info.getErrorList();
        ArrayList countList = info.getCountList();
        int i = 0;
        while (i < errorList.size()) {
            String errorId = "document.getElementById('error_detail" + index + "_" + i + "')";
            String errorIcon = "document.getElementById('error_icon" + index + "_" + i + "')";
            String onClick = "if (" + errorId + ".style.display == 'none') { " + errorIcon + ".innerHTML = '- '; " + errorId + ".style.display = 'block'; }" + "else { " + errorIcon + ".innerHTML = '+ '; " + errorId + ".style.display = 'none'; }";
            this.writer.writeCode("<div>");
            BirtException ex = (BirtException)errorList.get(i);
            this.writer.writeCode("<span id=\"error_icon" + index + "_" + i + "\"  style=\"cursor:pointer\" onclick=\"" + onClick + "\" > + </span>");
            this.writer.text(ex.getLocalizedMessage());
            this.writer.writeCode("\t\t\t\t<pre id=\"error_detail" + index + "_" + i + "\" style=\"display:none;\" >");
            String messageTitle = rc.getMessage("Error.ReportErrorID", new Object[]{ex.getErrorCode(), countList.get(i)});
            String detailTag = rc.getMessage("Error.ReportErrorDetail");
            String messageBody = this.getDetailMessage((Throwable)ex);
            boolean indent = this.writer.isIndent();
            this.writer.setIndent(false);
            this.writer.text(messageTitle, false);
            this.writer.writeCode("\r\n");
            this.writer.text(detailTag, false);
            this.writer.text(messageBody, false);
            this.writer.setIndent(indent);
            this.writer.writeCode("\t\t\t\t</pre>");
            this.writer.writeCode("</div>");
            ++i;
        }
        this.writer.writeCode("</div>");
        this.writer.writeCode("<br>");
    }

    private String getDetailMessage(Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter print = new PrintWriter(out);
        try {
            t.printStackTrace(print);
        }
        catch (Throwable throwable) {}
        print.flush();
        return out.getBuffer().toString();
    }

    protected boolean outputErrors(List errors) {
        if (errors != null && !errors.isEmpty()) {
            this.writer.writeCode("\t<hr style=\"color:red\"/>");
            this.writer.writeCode("\t<div style=\"color:red\">");
            this.writer.writeCode("\t\t<div>");
            Locale locale = this.reportContext.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            EngineResourceHandle rc = new EngineResourceHandle(ULocale.forLocale((Locale)locale));
            this.writer.text(rc.getMessage("Error.ErrorOnReportPage"), false);
            this.writer.writeCode("</div>");
            this.writer.writeCode("<br>");
            Iterator it = errors.iterator();
            int index = 0;
            while (it.hasNext()) {
                this.appendErrorMessage(rc, index++, (ExecutionContext.ElementExceptionInfo)it.next());
            }
            this.writer.writeCode("</div>");
            return true;
        }
        return false;
    }

    public void end(IReportContent report) {
        List errors;
        logger.log(Level.FINE, "[HTMLReportEmitter] End body.");
        if (report != null && (errors = report.getErrors()) != null && !errors.isEmpty()) {
            this.outputErrors(errors);
        }
        if (!this.isEmbeddable) {
            this.writer.closeTag("body");
            this.writer.closeTag("html");
        } else {
            this.writer.closeTag("div");
        }
        this.writer.endWriter();
        this.writer.close();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void startPage(IPageContent page) {
        Object genBy;
        StringBuffer styleBuffer;
        ++this.pageNo;
        if (this.pageNo > 1 && !this.outputMasterPageContent) {
            this.writer.openTag("hr");
            this.writer.closeTag("hr");
        }
        this.writer.openTag("div");
        if (page != null) {
            Object genBy2;
            DimensionType width;
            IStyle classStyle = page.getStyle();
            StringBuffer styleBuffer2 = new StringBuffer();
            AttributeBuilder.buildBackgroundStyle(styleBuffer2, classStyle, this);
            if ("fixed".equals(this.layoutPreference) && (width = page.getPageWidth()) != null) {
                styleBuffer2.append(" width:");
                styleBuffer2.append(width.toString());
                styleBuffer2.append(";");
            }
            if ("fixed".equals(this.layoutPreference) && (genBy2 = page.getGenerateBy()) instanceof SimpleMasterPageDesign) {
                SimpleMasterPageDesign SimpleMasterPage = (SimpleMasterPageDesign)genBy2;
                String padding = SimpleMasterPage.getLeftMargin().toString();
                if (padding != null) {
                    styleBuffer2.append("padding-left: ");
                    styleBuffer2.append(padding);
                    styleBuffer2.append(";");
                }
                if ((padding = SimpleMasterPage.getTopMargin().toString()) != null) {
                    styleBuffer2.append("padding-top: ");
                    styleBuffer2.append(padding);
                    styleBuffer2.append(";");
                }
                if ((padding = SimpleMasterPage.getRightMargin().toString()) != null) {
                    styleBuffer2.append("padding-right: ");
                    styleBuffer2.append(padding);
                    styleBuffer2.append(";");
                }
                if ((padding = SimpleMasterPage.getBottomMargin().toString()) != null) {
                    styleBuffer2.append("padding-bottom: ");
                    styleBuffer2.append(padding);
                    styleBuffer2.append(";");
                }
            }
            this.writer.attribute("style", styleBuffer2.toString());
        }
        if (this.htmlRtLFlag) {
            this.writer.attribute("dir", "RTL");
        }
        if (this.pageNo > 1) {
            this.writer.attribute("style", "page-break-before: always;");
        }
        if (page != null && this.outputMasterPageContent) {
            SimpleMasterPageDesign masterPage;
            boolean showHeader = true;
            Object genBy3 = page.getGenerateBy();
            if (genBy3 instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy3).isShowHeaderOnFirst() && page.getPageNumber() == 1L) {
                showHeader = false;
            }
            if (showHeader) {
                this.writer.openTag("div");
                styleBuffer = new StringBuffer();
                if (this.isEmbeddable) {
                    AttributeBuilder.buildPageStyle(styleBuffer, page.getStyle(), this);
                } else {
                    this.writer.attribute("class", page.getStyleClass());
                    AttributeBuilder.buildPageStyle(styleBuffer, page.getInlineStyle(), this);
                }
                this.writer.attribute("style", styleBuffer.toString());
                this.contentVisitor.visitChildren(page.getPageHeader(), null);
                this.writer.closeTag("div");
            }
        }
        this.writer.openTag("div");
        if (page != null && (genBy = page.getGenerateBy()) instanceof MasterPageDesign) {
            MasterPageDesign masterPage = (MasterPageDesign)genBy;
            styleBuffer = new StringBuffer();
            if (!this.pageFooterFloatFlag) {
                this.htmlEmitter.buildSize(styleBuffer, "min-height", masterPage.getPageHeight());
            }
            this.writer.attribute("style", styleBuffer.toString());
        }
    }

    public void endPage(IPageContent page) {
        logger.log(Level.FINE, "[HTMLReportEmitter] End page.");
        this.writer.closeTag("div");
        if (page != null && this.outputMasterPageContent) {
            SimpleMasterPageDesign masterPage;
            boolean showFooter = true;
            Object genBy = page.getGenerateBy();
            if (genBy instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy).isShowFooterOnLast()) {
                long totalPage = page.getPageNumber();
                IReportContent report = page.getReportContent();
                if (report != null) {
                    totalPage = report.getTotalPage();
                }
                if (page.getPageNumber() == totalPage) {
                    showFooter = false;
                }
            }
            if (showFooter) {
                this.writer.openTag("div");
                StringBuffer styleBuffer = new StringBuffer();
                if (this.isEmbeddable) {
                    AttributeBuilder.buildPageStyle(styleBuffer, page.getStyle(), this);
                } else {
                    this.writer.attribute("class", page.getStyleClass());
                    AttributeBuilder.buildPageStyle(styleBuffer, page.getInlineStyle(), this);
                }
                this.writer.attribute("style", styleBuffer.toString());
                this.contentVisitor.visitChildren(page.getPageFooter(), null);
                this.writer.closeTag("div");
            }
        }
        this.writer.closeTag("div");
    }

    public void startTable(ITableContent table) {
        if (!$assertionsDisabled && table == null) {
            throw new AssertionError();
        }
        logger.log(Level.FINE, "[HTMLTableEmitter] Start table");
        if (this.enableMetadata) {
            this.metadataEmitter.startWrapTable(table);
        }
        this.writer.openTag("table");
        this.setStyleName(table.getStyleClass());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildTableStyle(table, styleBuffer, this.layoutPreference);
        this.writer.attribute("style", styleBuffer.toString());
        String bookmark = table.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            table.setBookmark(bookmark);
        }
        HTMLEmitterUtil.setBookmark(this.writer, null, bookmark);
        HTMLEmitterUtil.setActiveIDTypeIID(this.writer, this.ouputInstanceIDs, (IContent)table);
        String caption = table.getCaption();
        if (caption != null && caption.length() > 0) {
            this.writer.openTag("caption");
            this.writer.text(caption);
            this.writer.closeTag("caption");
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startTable(table);
        }
        this.writeColumns(table);
    }

    protected void writeColumns(ITableContent table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            IColumn column = table.getColumn(i);
            if (!this.isColumnHidden(column)) {
                InstanceID iid;
                this.writer.openTag("col");
                StringBuffer styleBuffer = new StringBuffer();
                this.htmlEmitter.buildColumnStyle(column, styleBuffer);
                this.writer.attribute("style", styleBuffer.toString());
                if (this.enableMetadata && (iid = column.getInstanceID()) != null) {
                    this.writer.attribute("iid", iid.toString());
                }
                this.writer.closeNoEndTag();
            }
            ++i;
        }
    }

    private boolean isColumnHidden(IColumn column) {
        String formats = column.getVisibleFormat();
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0);
    }

    public void endTable(ITableContent table) {
        if (this.enableMetadata) {
            this.metadataEmitter.endTable(table);
        }
        this.writer.closeTag("table");
        if (this.enableMetadata) {
            this.metadataEmitter.endWrapTable(table);
        }
        logger.log(Level.FINE, "[HTMLTableEmitter] End table");
    }

    public void startTableHeader(ITableBandContent band) {
        this.writer.openTag("thead");
    }

    public void endTableHeader(ITableBandContent band) {
        this.writer.closeTag("thead");
    }

    public void startTableBody(ITableBandContent band) {
        this.writer.openTag("tbody");
    }

    public void endTableBody(ITableBandContent band) {
        this.writer.closeTag("tbody");
    }

    public void startTableFooter(ITableBandContent band) {
        this.writer.openTag("tfoot");
    }

    public void endTableFooter(ITableBandContent band) {
        this.writer.closeTag("tfoot");
    }

    public void startRow(IRowContent row) {
        if (!$assertionsDisabled && row == null) {
            throw new AssertionError();
        }
        this.writer.openTag("tr");
        if (this.enableMetadata) {
            this.metadataEmitter.startRow(row);
            this.outputRowMetaData(row);
        }
        this.setStyleName(row.getStyleClass());
        HTMLEmitterUtil.setBookmark(this.writer, null, row.getBookmark());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildRowStyle(row, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
    }

    protected void outputRowMetaData(IRowContent rowContent) {
        IElement parent = rowContent.getParent();
        if (parent instanceof ITableBandContent) {
            ITableBandContent bandContent = (ITableBandContent)parent;
            IGroupContent group = rowContent.getGroup();
            String groupId = rowContent.getGroupId();
            if (groupId != null) {
                this.writer.attribute("group-id", groupId);
            }
            String rowType = null;
            String metaType = null;
            int bandType = bandContent.getBandType();
            if (bandType == 1) {
                metaType = "wrth";
                rowType = "header";
            } else if (bandType == 2) {
                metaType = "wrtf";
                rowType = "footer";
            } else if (bandType == 3) {
                rowType = "group-header";
                if (group != null) {
                    metaType = "wrgh" + group.getGroupLevel();
                }
            } else if (bandType == 4) {
                rowType = "group-footer";
                if (group != null) {
                    metaType = "wrgf" + group.getGroupLevel();
                }
            }
            this.writer.attribute("type", metaType);
            this.writer.attribute("row-type", rowType);
        }
    }

    public void endRow(IRowContent row) {
        if (this.enableMetadata) {
            this.metadataEmitter.endRow(row);
        }
        this.writer.closeTag("tr");
    }

    private boolean isCellInTableHead(ICellContent cell) {
        int type;
        IElement tableBand;
        IElement row = cell.getParent();
        return row instanceof IRowContent && (tableBand = row.getParent()) instanceof ITableBandContent && (type = ((ITableBandContent)tableBand).getBandType()) == 1;
    }

    public void startCell(ICellContent cell) {
        int rowSpan;
        this.leafCell = cell;
        this.cellFilled = false;
        logger.log(Level.FINE, "[HTMLTableEmitter] Start cell.");
        boolean isInTableHead = this.isCellInTableHead(cell);
        if (isInTableHead) {
            this.writer.openTag("th");
        } else {
            this.writer.openTag("td");
        }
        this.setStyleName(cell.getStyleClass());
        int colSpan = cell.getColSpan();
        if (colSpan > 1) {
            this.writer.attribute("colspan", colSpan);
        }
        if ((rowSpan = cell.getRowSpan()) > 1) {
            this.writer.attribute("rowspan", rowSpan);
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildCellStyle(cell, styleBuffer, isInTableHead);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleCellAlign(cell);
        if (!this.startedGroups.isEmpty()) {
            Iterator iter = this.startedGroups.iterator();
            while (iter.hasNext()) {
                IGroupContent group = (IGroupContent)iter.next();
                this.outputBookmark(group);
            }
            this.startedGroups.clear();
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startCell(cell);
        }
    }

    public void endCell(ICellContent cell) {
        this.leafCell = null;
        this.cellFilled = false;
        logger.log(Level.FINE, "[HTMLReportEmitter] End cell.");
        if (this.enableMetadata) {
            this.metadataEmitter.endCell(cell);
        }
        if (this.isCellInTableHead(cell)) {
            this.writer.closeTag("th");
        } else {
            this.writer.closeTag("td");
        }
    }

    public void startContainer(IContainerContent container) {
        IStyle mergedStyle = container.getStyle();
        logger.log(Level.FINE, "[HTMLReportEmitter] Start container");
        this.htmlEmitter.openContainerTag(container);
        this.setStyleName(container.getStyleClass());
        String bookmark = container.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            container.setBookmark(bookmark);
        }
        HTMLEmitterUtil.setBookmark(this.writer, "div", bookmark);
        HTMLEmitterUtil.setActiveIDTypeIID(this.writer, this.ouputInstanceIDs, (IContent)container);
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildContainerStyle(container, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleHorizontalAlign(mergedStyle);
    }

    public void endContainer(IContainerContent container) {
        this.htmlEmitter.closeContainerTag();
        logger.log(Level.FINE, "[HTMLContainerEmitter] End container");
    }

    public void startText(ITextContent text) {
        String tagName;
        IStyle mergedStyle = text.getStyle();
        logger.log(Level.FINE, "[HTMLReportEmitter] Start text");
        DimensionType x = text.getX();
        DimensionType y = text.getY();
        DimensionType width = text.getWidth();
        DimensionType height = text.getHeight();
        String textValue = text.getText();
        if (textValue == null || textValue == "") {
            textValue = " ";
        }
        int display = textValue != null && textValue.indexOf(10) >= 0 ? this.getElementType(x, y, width, height, mergedStyle) : this.getElementType(x, y, null, null, mergedStyle);
        String url = this.validate(text.getHyperlinkAction());
        boolean metadataOutput = false;
        if (url != null) {
            if (this.enableMetadata) {
                metadataOutput = this.metadataEmitter.startText(text, "span");
            }
            tagName = "a";
            this.outputAction(text.getHyperlinkAction(), url);
        } else {
            if (this.enableMetadata) {
                metadataOutput = this.metadataEmitter.startText(text, HTMLEmitterUtil.getTagByType(display, 65535));
            }
            tagName = this.openTagByType(display, 65535);
        }
        this.setStyleName(text.getStyleClass());
        if (!metadataOutput) {
            this.outputBookmark((IContent)text, tagName);
        }
        this.writer.attribute("title", text.getHelpText());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildTextStyle(text, styleBuffer, display, url);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleVerticalAlignBegine((IContent)text);
        this.writer.text(textValue);
        this.htmlEmitter.handleVerticalAlignEnd((IContent)text);
        this.writer.closeTag(tagName);
        if (this.enableMetadata) {
            this.metadataEmitter.endText(text);
        }
        this.cellFilled = true;
    }

    public void startForeign(IForeignContent foreign) {
        String tagName;
        String bookmark;
        IStyle mergedStyle = foreign.getStyle();
        logger.log(Level.FINE, "[HTMLReportEmitter] Start foreign");
        this.resizeTemplateElement((IContent)foreign);
        DimensionType x = foreign.getX();
        DimensionType y = foreign.getY();
        DimensionType width = foreign.getWidth();
        DimensionType height = foreign.getHeight();
        int display = this.getElementType(x, y, width, height, mergedStyle);
        if (foreign.getGenerateBy() instanceof TemplateDesign && (bookmark = foreign.getBookmark()) == null) {
            bookmark = this.idGenerator.generateUniqueID();
            foreign.setBookmark(bookmark);
        }
        boolean isTemplate = false;
        Object genBy = foreign.getGenerateBy();
        if (genBy instanceof TemplateDesign) {
            isTemplate = true;
            this.writer.openTag("div");
            this.writer.attribute("align", "middle");
        }
        String url = this.validate(foreign.getHyperlinkAction());
        boolean metadataOutput = false;
        if (url != null) {
            if (this.enableMetadata) {
                metadataOutput = this.metadataEmitter.startForeign(foreign, "span");
            }
            tagName = "a";
            this.outputAction(foreign.getHyperlinkAction(), url);
        } else {
            if (this.enableMetadata) {
                metadataOutput = this.metadataEmitter.startForeign(foreign, HTMLEmitterUtil.getTagByType(display, 65535));
            }
            tagName = this.openTagByType(display, 65535);
        }
        this.setStyleName(foreign.getStyleClass());
        if (!metadataOutput) {
            this.outputBookmark((IContent)foreign, tagName);
        }
        this.writer.attribute("title", foreign.getHelpText());
        if (this.isTalbeTemplateElement((IContent)foreign)) {
            mergedStyle.setProperty(10, (CSSValue)IStyle.DOTTED_VALUE);
            mergedStyle.setProperty(13, (CSSValue)IStyle.DOTTED_VALUE);
            mergedStyle.setProperty(11, (CSSValue)IStyle.DOTTED_VALUE);
            mergedStyle.setProperty(12, (CSSValue)IStyle.DOTTED_VALUE);
            mergedStyle.setProperty(49, (CSSValue)IStyle.SANS_SERIF_VALUE);
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildForeignStyle(foreign, styleBuffer, display, url);
        this.writer.attribute("style", styleBuffer.toString());
        String rawType = foreign.getRawType();
        boolean isHtml = "text/html".equalsIgnoreCase(rawType);
        if (isHtml) {
            this.htmlEmitter.handleVerticalAlignBegine((IContent)foreign);
            this.outputHtmlText(foreign);
            this.htmlEmitter.handleVerticalAlignEnd((IContent)foreign);
        }
        this.writer.closeTag(tagName);
        if (isTemplate) {
            this.writer.openTag("div");
        }
        if (this.enableMetadata) {
            this.metadataEmitter.endForeign(foreign);
        }
        this.cellFilled = true;
    }

    private void outputHtmlText(IForeignContent foreign) {
        NodeList bodys;
        Object rawValue = foreign.getRawValue();
        String text = rawValue == null ? null : rawValue.toString();
        Document doc = new TextParser().parse(text, TextParser.TEXT_TYPE_HTML);
        ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
        HTMLProcessor htmlProcessor = new HTMLProcessor(design);
        HashMap styleMap = new HashMap();
        Element body = null;
        if (doc != null && (bodys = doc.getElementsByTagName("body")).getLength() > 0) {
            body = (Element)bodys.item(0);
        }
        if (body != null) {
            htmlProcessor.execute(body, styleMap);
            this.processNodes(body, styleMap);
        }
    }

    private void processNodes(Element ele, HashMap cssStyles) {
        Node node = ele.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 1) {
                if (!node.getNodeName().equals("#text")) {
                    this.startNode(node, cssStyles);
                }
                if (node.getNodeType() == 3) {
                    if (this.isScriptText(node)) {
                        this.textForScript(node.getNodeValue());
                    } else {
                        this.writer.textForHtmlItem(node.getNodeValue());
                    }
                } else {
                    this.processNodes((Element)node, cssStyles);
                }
                if (!node.getNodeName().equals("#text")) {
                    this.endNode(node);
                }
            }
            node = node.getNextSibling();
        }
    }

    private boolean isScriptText(Node node) {
        String tag;
        Node parent = node.getParentNode();
        return parent != null && parent.getNodeType() == 1 && "script".equalsIgnoreCase(tag = parent.getNodeName());
    }

    private void textForScript(String text) {
        this.writer.text(text, false, false);
    }

    public void startNode(Node node, HashMap cssStyles) {
        String nodeName = node.getNodeName();
        HashMap cssStyle = (HashMap)cssStyles.get(node);
        this.writer.openTag(nodeName);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                String attrName = attribute.getNodeName();
                String attrValue = attribute.getNodeValue();
                if (attrValue != null) {
                    String attrValueTrue;
                    if ("img".equalsIgnoreCase(nodeName) && "src".equalsIgnoreCase(attrName) && (attrValueTrue = this.handleStyleImage(attrValue)) != null) {
                        attrValue = attrValueTrue;
                    }
                    this.writer.attribute(attrName, attrValue);
                }
                ++i;
            }
        }
        if (cssStyle != null) {
            StringBuffer buffer = new StringBuffer();
            Iterator ite = cssStyle.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry entry = ite.next();
                Object keyObj = entry.getKey();
                Object valueObj = entry.getValue();
                if (keyObj == null || valueObj == null) continue;
                String key = keyObj.toString();
                String value = valueObj.toString();
                buffer.append(key);
                buffer.append(":");
                if ("background-image".equalsIgnoreCase(key)) {
                    String valueTrue = this.handleStyleImage(value);
                    if (valueTrue != null) {
                        value = valueTrue;
                    }
                    buffer.append("url(");
                    buffer.append(value);
                    buffer.append(")");
                } else {
                    buffer.append(value.replaceAll(" ", ""));
                }
                buffer.append(";");
            }
            if (buffer.length() != 0) {
                this.writer.attribute("style", buffer.toString());
            }
        }
    }

    public void endNode(Node node) {
        this.writer.closeTag(node.getNodeName());
    }

    public void startLabel(ILabelContent label) {
        String bookmark = label.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            label.setBookmark(bookmark);
        }
        this.startText((ITextContent)label);
    }

    public void startData(IDataContent data) {
        this.startText((ITextContent)data);
    }

    public void startImage(IImageContent image) {
        boolean useSVG;
        if (!$assertionsDisabled && image == null) {
            throw new AssertionError();
        }
        IStyle mergedStyle = image.getStyle();
        logger.log(Level.FINE, "[HTMLImageEmitter] Start image");
        StringBuffer styleBuffer = new StringBuffer();
        int display = this.checkElementType(image.getX(), image.getY(), mergedStyle, styleBuffer);
        boolean isSelectHandleTableChart = false;
        if (this.enableMetadata) {
            isSelectHandleTableChart = this.metadataEmitter.startImage(image);
        }
        String tag = this.openTagByType(display, 1);
        boolean hasAction = this.handleAction(image.getHyperlinkAction());
        String imgUri = this.getImageURI(image);
        boolean bl = useSVG = image.getMIMEType() != null && image.getMIMEType().equalsIgnoreCase("image/svg+xml") || image.getExtension() != null && image.getExtension().equalsIgnoreCase(".svg") || image.getURI() != null && image.getURI().toLowerCase().endsWith(".svg");
        if (useSVG) {
            this.writer.openTag("embed");
            String bookmark = image.getBookmark();
            if (!isSelectHandleTableChart) {
                if (bookmark == null) {
                    bookmark = this.idGenerator.generateUniqueID();
                    image.setBookmark(bookmark);
                }
                this.outputBookmark((IContent)image, "img");
            }
            this.writer.attribute("onresize", String.valueOf(bookmark) + ".reload()");
            this.writer.attribute("type", "image/svg+xml");
            this.writer.attribute("src", imgUri);
            String altText = image.getAltText();
            if (altText == null) {
                this.writer.attributeAllowEmpty("alt", "");
            } else {
                this.writer.attribute("alt", altText);
            }
            this.setStyleName(image.getStyleClass());
            this.htmlEmitter.buildImageStyle(image, styleBuffer, display);
            this.writer.attribute("style", styleBuffer.toString());
            this.writer.closeNoEndTag();
        } else {
            String altText;
            boolean hasImageMap;
            Object imageMapObject = image.getImageMap();
            String imageMapId = imgUri;
            boolean bl2 = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
            if (hasImageMap) {
                this.writer.openTag("map");
                this.writer.attribute("name", imageMapId);
                this.writer.text((String)imageMapObject, true, false);
                this.writer.closeTag("map");
            }
            this.writer.openTag("img");
            this.setStyleName(image.getStyleClass());
            String bookmark = image.getBookmark();
            if (!isSelectHandleTableChart) {
                if (bookmark == null) {
                    bookmark = this.idGenerator.generateUniqueID();
                    image.setBookmark(bookmark);
                }
                this.outputBookmark((IContent)image, "img");
            }
            String ext = image.getExtension();
            this.writer.attribute("src", imgUri);
            if (hasImageMap) {
                if (!hasAction) {
                    IStyle style = image.getStyle();
                    if (style.getBorderTopStyle() == null) {
                        styleBuffer.append("border-top-style:none;");
                    } else if (style.getBorderTopColor() == null) {
                        styleBuffer.append("border-top-color:black");
                    }
                    if (style.getBorderBottomStyle() == null) {
                        styleBuffer.append("border-bottom-style:none;");
                    } else if (style.getBorderBottomColor() == null) {
                        styleBuffer.append("border-bottom-color:black");
                    }
                    if (style.getBorderLeftStyle() == null) {
                        styleBuffer.append("border-left-style:none;");
                    } else if (style.getBorderLeftColor() == null) {
                        styleBuffer.append("border-left-color:black");
                    }
                    if (style.getBorderRightStyle() == null) {
                        styleBuffer.append("border-right-style:none;");
                    } else if (style.getBorderRightColor() == null) {
                        styleBuffer.append("border-right-color:black");
                    }
                }
                this.writer.attribute("usemap", "#" + imageMapId);
            }
            if ((altText = image.getAltText()) == null) {
                this.writer.attributeAllowEmpty("alt", "");
            } else {
                this.writer.attribute("alt", altText);
            }
            this.writer.attribute("title", image.getHelpText());
            this.htmlEmitter.buildImageStyle(image, styleBuffer, display);
            this.writer.attribute("style", styleBuffer.toString());
            if (".PNG".equalsIgnoreCase(ext) && this.imageHandler != null) {
                this.writer.attribute("onload", "fixPNG(this)");
            }
            this.writer.closeNoEndTag();
        }
        if (hasAction) {
            this.writer.closeTag("a");
        }
        this.writer.closeTag(tag);
        if (this.enableMetadata) {
            this.metadataEmitter.endImage(image);
        }
        this.cellFilled = true;
    }

    protected String getImageURI(IImageContent image) {
        String imgUri = null;
        if (this.imageHandler != null) {
            Image img = new Image(image);
            img.setRenderOption(this.renderOption);
            img.setReportRunnable(this.runnable);
            switch (img.getSource()) {
                case 0: {
                    imgUri = this.imageHandler.onDesignImage((IImage)img, this.reportContext);
                    break;
                }
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)img, this.reportContext);
                    break;
                }
                case 1: {
                    imgUri = this.imageHandler.onDocImage((IImage)img, this.reportContext);
                    break;
                }
                case 4: {
                    imgUri = this.imageHandler.onCustomImage((IImage)img, this.reportContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)img, this.reportContext);
                    break;
                }
            }
        }
        return imgUri;
    }

    protected void setStyleName(String styleName) {
        if (this.isEmbeddable) {
            return;
        }
        if (styleName != null) {
            this.writer.attribute("class", styleName);
        }
    }

    protected void outputBookmark(IContent content, String tagName) {
        String bookmark = content.getBookmark();
        HTMLEmitterUtil.setBookmark(this.writer, tagName, bookmark);
    }

    protected int checkElementType(DimensionType x, DimensionType y, IStyle style, StringBuffer styleBuffer) {
        return this.checkElementType(x, y, null, null, style, styleBuffer);
    }

    protected int checkElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style, StringBuffer styleBuffer) {
        return this.getElementType(x, y, width, height, style);
    }

    public int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        return this.htmlEmitter.getElementType(x, y, width, height, style);
    }

    protected String openTagByType(int display, int mask) {
        String tag = HTMLEmitterUtil.getTagByType(display, mask);
        if (tag != null) {
            this.writer.openTag(tag);
        }
        return tag;
    }

    protected boolean handleAction(IHyperlinkAction action) {
        String url = this.validate(action);
        if (url != null) {
            this.outputAction(action, url);
        }
        return url != null;
    }

    protected void outputAction(IHyperlinkAction action, String url) {
        this.writer.openTag("a");
        this.writer.attribute("href", url);
        this.writer.attribute("target", action.getTargetWindow());
    }

    private String validate(IHyperlinkAction action) {
        if (action == null) {
            return null;
        }
        String systemId = this.runnable == null ? null : this.runnable.getReportName();
        Action act = new Action(systemId, action);
        if (this.actionHandler == null) {
            return null;
        }
        String link = this.actionHandler.getURL((IAction)act, this.reportContext);
        if (link != null && !link.equals("")) {
            return link;
        }
        return null;
    }

    public String handleStyleImage(String uri) {
        ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
        URL url = design.findResource(uri, 1);
        if (url == null) {
            return uri;
        }
        uri = url.toExternalForm();
        Image image = new Image(uri);
        image.setReportRunnable(this.runnable);
        image.setRenderOption(this.renderOption);
        String imgUri = null;
        if (this.imageHandler != null) {
            switch (image.getSource()) {
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)image, this.reportContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)image, this.reportContext);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
        return imgUri;
    }

    private void resizeTemplateElement(IContent content) {
        Object genBy = content.getGenerateBy();
        if (genBy instanceof TemplateDesign) {
            TemplateDesign template = (TemplateDesign)genBy;
            String allowedType = template.getAllowedType();
            if ("ExtendedItem".equals(allowedType)) {
                IStyle style = content.getStyle();
                style.setProperty(6, (CSSValue)IStyle.FALSE_VALUE);
                content.setWidth(new DimensionType(3.0, "in"));
                content.setHeight(new DimensionType(3.0, "in"));
            } else if ("Table".equals(allowedType)) {
                IStyle style = content.getStyle();
                style.setProperty(6, (CSSValue)IStyle.FALSE_VALUE);
                content.setWidth(new DimensionType(5.0, "in"));
            }
        }
    }

    private boolean isTalbeTemplateElement(IContent content) {
        TemplateDesign template;
        String allowedType;
        Object genBy = content.getGenerateBy();
        return genBy instanceof TemplateDesign && "Table".equals(allowedType = (template = (TemplateDesign)genBy).getAllowedType());
    }

    public void endGroup(IGroupContent group) {
    }

    public void endListBand(IListBandContent listBand) {
    }

    public void endListGroup(IListGroupContent group) {
    }

    public void endTableBand(ITableBandContent band) {
    }

    public void endTableGroup(ITableGroupContent group) {
    }

    public void startGroup(IGroupContent group) {
    }

    public void startListBand(IListBandContent listBand) {
    }

    public void startListGroup(IListGroupContent group) {
        this.outputBookmark((IGroupContent)group);
    }

    public void startTableBand(ITableBandContent band) {
    }

    public void startTableGroup(ITableGroupContent group) {
        this.startedGroups.push(group);
    }

    private void outputBookmark(IGroupContent group) {
        String bookmark = group.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            group.setBookmark(bookmark);
        }
        this.writer.openTag("span");
        this.writer.attribute("id", group.getBookmark());
        this.writer.closeTag("span");
    }
}

