/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.sample.components.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.api.impl.AbstractSource;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.spi.ComponentEventSource;
import org.eclipse.cosmos.dc.common.spi.ComponentListener;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.spec.types.StatisticalObservation;
import org.eclipse.cosmos.dc.spec.types.StatisticalTuple;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ManagedResource
public class JMXPollingSource
extends AbstractSource
implements ComponentEventSource {
    private static final String SAMPLE_NAMESPACE = "http://www.eclipse.org/xmlns/sample/1.0";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final AttributeDescriptor[] EMPTY_DESCRIPTOR_ARRAY = new AttributeDescriptor[0];
    private DataSource datasource;
    private HashMap<ObjectName, String[]> beanMap = new HashMap();
    private HashMap<ObjectName, AttributeDescriptor[]> descriptorMap = new HashMap();
    private String host;
    private String defaultDomain;
    private long interval;
    private JMXConnector jmxc;
    private MBeanServerConnection mbsc;
    private Thread pollingThread;
    private PollingThreadRunner runner;
    private static Class[] supportedTypes = new Class[]{StatisticalTuple.class};
    private ArrayList<ComponentListener> listenerList = new ArrayList();

    public JMXPollingSource(ContributionManager manager, Element binding) {
        super(manager);
        Element[] beans;
        this.host = binding.getAttribute("host");
        String intervalString = binding.getAttribute("interval");
        this.defaultDomain = binding.getAttribute("domain");
        Element[] elementArray = beans = XmlUtils.getAllElements((Node)binding, (String)SAMPLE_NAMESPACE, (String)"mbean");
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            Element bean = elementArray[n2];
            String domain = bean.getAttribute("domain");
            String keys = bean.getAttribute("keys");
            try {
                ObjectName mbeanName = new ObjectName(String.valueOf(domain) + ":" + keys);
                Element[] atts = XmlUtils.getAllElements((Node)bean, (String)SAMPLE_NAMESPACE, (String)"attribute");
                ArrayList<String> attList = new ArrayList<String>();
                ArrayList<AttributeDescriptor> descriptorList = new ArrayList<AttributeDescriptor>();
                Element[] elementArray2 = atts;
                int n3 = atts.length;
                int n4 = 0;
                while (n4 < n3) {
                    Element att = elementArray2[n4];
                    String name = att.getAttribute("name");
                    String compositeKey = "";
                    boolean isComposite = false;
                    if (name.indexOf(":") != -1) {
                        compositeKey = name.substring(name.indexOf(":") + 1, name.length());
                        name = name.substring(0, name.indexOf(":"));
                        isComposite = true;
                    }
                    attList.add(name);
                    att.getAttribute("key");
                    descriptorList.add(new AttributeDescriptor(isComposite, name, compositeKey));
                    ++n4;
                }
                this.beanMap.put(mbeanName, attList.toArray(EMPTY_STRING_ARRAY));
                this.descriptorMap.put(mbeanName, descriptorList.toArray(EMPTY_DESCRIPTOR_ARRAY));
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.interval = XsdUtils.getDuration((String)intervalString);
    }

    public boolean acceptWireTarget(IWireTarget target) throws Exception {
        if (target instanceof IDataFilterService) {
            Class[] classArray = supportedTypes;
            int n = supportedTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class type = classArray[n2];
                if (((IDataFilterService)target).acceptType(type)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (target instanceof IDataTransformService) {
            Class[] classArray = supportedTypes;
            int n = supportedTypes.length;
            int n3 = 0;
            while (n3 < n) {
                Class type = classArray[n3];
                if (((IDataTransformService)target).acceptType(type)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        if (target instanceof IDataSinkService) {
            Class[] classArray = supportedTypes;
            int n = supportedTypes.length;
            int n4 = 0;
            while (n4 < n) {
                Class type = classArray[n4];
                if (((IDataSinkService)target).acceptType(type)) {
                    return true;
                }
                ++n4;
            }
            return false;
        }
        return false;
    }

    public boolean cancel() throws Exception {
        Date stopDate = new Date(System.currentTimeMillis());
        for (ComponentListener listener : this.listenerList) {
            listener.event(3, (Object)this, (Object)stopDate);
        }
        return false;
    }

    public boolean connect() throws Exception {
        try {
            HashMap env = new HashMap();
            JMXServiceURL url = new JMXServiceURL(this.host);
            this.jmxc = JMXConnectorFactory.newJMXConnector(url, env);
            this.jmxc.connect();
            this.mbsc = this.jmxc.getMBeanServerConnection();
            for (ObjectName beanName : this.beanMap.keySet()) {
                if (this.mbsc.getObjectInstance(beanName) != null) continue;
                this.mbsc.createMBean(beanName.getCanonicalName(), beanName, null, null);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean disconnect() throws Exception {
        this.runner.setRunning(false);
        this.jmxc.close();
        return true;
    }

    public boolean pause() throws Exception {
        this.runner.setPaused(true);
        return true;
    }

    public boolean resume() throws Exception {
        this.runner.setPaused(false);
        return true;
    }

    public boolean run() throws Exception {
        this.runner = new PollingThreadRunner();
        this.pollingThread = new Thread(this.runner);
        Date startDate = new Date(System.currentTimeMillis());
        for (ComponentListener listener : this.listenerList) {
            listener.event(2, (Object)this, (Object)startDate);
        }
        this.pollingThread.start();
        return true;
    }

    public Class[] getOutputTypes() {
        return supportedTypes;
    }

    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public void addListener(ComponentListener listener) {
        this.listenerList.add(listener);
    }

    private class AttributeDescriptor {
        public boolean isComposite = false;
        public String name;
        public String compositeKey;

        public AttributeDescriptor(boolean isComposite, String name, String compositeKey) {
            this.isComposite = isComposite;
            this.name = name;
            this.compositeKey = compositeKey;
        }
    }

    private class PollingThreadRunner
    implements Runnable {
        private boolean running = true;
        private boolean paused = false;

        private PollingThreadRunner() {
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public void setPaused(boolean paused) {
            this.paused = paused;
        }

        public void run() {
            StatisticalTuple tuple = new StatisticalTuple();
            while (this.running) {
                if (!this.paused) {
                    tuple.clear();
                    tuple.setTimeStamp(System.currentTimeMillis());
                    for (ObjectName beanName : JMXPollingSource.this.beanMap.keySet()) {
                        try {
                            AttributeList list = JMXPollingSource.this.mbsc.getAttributes(beanName, (String[])JMXPollingSource.this.beanMap.get(beanName));
                            AttributeDescriptor[] descriptors = (AttributeDescriptor[])JMXPollingSource.this.descriptorMap.get(beanName);
                            int i = 0;
                            for (Object attObj : list) {
                                StatisticalObservation obs;
                                Attribute att = (Attribute)attObj;
                                Object value = att.getValue();
                                AttributeDescriptor desc = descriptors[i];
                                if (desc.isComposite) {
                                    while (i < descriptors.length && descriptors[i].name.equals(att.getName())) {
                                        ((CompositeData)value).get(descriptors[i].compositeKey);
                                        obs = new StatisticalObservation(String.valueOf(descriptors[i].name) + ":" + descriptors[i].compositeKey, ((CompositeData)value).get(desc.compositeKey));
                                        tuple.add(obs);
                                        ++i;
                                    }
                                    continue;
                                }
                                obs = new StatisticalObservation(att.getName(), att.getValue());
                                tuple.add(obs);
                                ++i;
                            }
                        }
                        catch (InstanceNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (ReflectionException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    JMXPollingSource.this.dispatch(tuple);
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(JMXPollingSource.this.interval);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

