/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.faults.InvalidFilterFault;
import org.apache.muse.ws.notification.impl.FilterCollection;
import org.apache.muse.ws.notification.impl.FilterFactoryHandler;
import org.apache.muse.ws.notification.impl.MessagePatternFilterHandler;
import org.apache.muse.ws.notification.impl.ProducerPropertiesFilterHandler;
import org.apache.muse.ws.notification.impl.PublishAllMessagesFilter;
import org.apache.muse.ws.notification.impl.TopicFilterHandler;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterFactory {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$notification$impl$FilterFactory == null ? (class$org$apache$muse$ws$notification$impl$FilterFactory = FilterFactory.class$("org.apache.muse.ws.notification.impl.FilterFactory")) : class$org$apache$muse$ws$notification$impl$FilterFactory));
    private static final FilterFactory _SINGLETON = new FilterFactory();
    private Collection _handlers = new LinkedList();
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$FilterFactory;

    private FilterFactory() {
        this._handlers.add(new TopicFilterHandler());
        this._handlers.add(new ProducerPropertiesFilterHandler());
        this._handlers.add(new MessagePatternFilterHandler());
    }

    public void addHandler(FilterFactoryHandler handler) {
        this._handlers.add(handler);
    }

    public static FilterFactory getInstance() {
        return _SINGLETON;
    }

    public Filter newInstance(Element xml) throws BaseFault {
        if (xml == null) {
            return PublishAllMessagesFilter.getInstance();
        }
        Element[] children = XmlUtils.getAllElements((Node)xml);
        if (children.length == 0) {
            return PublishAllMessagesFilter.getInstance();
        }
        FilterCollection filters = new FilterCollection();
        for (int n = 0; n < children.length; ++n) {
            QName name = XmlUtils.getElementQName((Element)children[n]);
            String dialect = children[n].getAttribute("Dialect");
            Filter filter = null;
            Iterator i = this._handlers.iterator();
            while (i.hasNext() && filter == null) {
                FilterFactoryHandler handler = (FilterFactoryHandler)i.next();
                if (!handler.accepts(name, dialect)) continue;
                filter = handler.newInstance(children[n]);
            }
            if (filter == null) {
                Object[] filler = new Object[]{XmlUtils.getFirstElement((Node)xml)};
                throw new InvalidFilterFault(_MESSAGES.get("InvalidFilterType", filler));
            }
            filters.addFilter(filter);
        }
        return filters;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

