/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.topics.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.notification.faults.InvalidTopicExpressionFault;
import org.apache.muse.ws.notification.topics.Topic;
import org.apache.muse.ws.notification.topics.TopicNamespace;
import org.apache.muse.ws.notification.topics.WstConstants;
import org.apache.muse.ws.notification.topics.impl.SimpleTopic;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleTopicNamespace
implements TopicNamespace {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$notification$topics$impl$SimpleTopicNamespace == null ? (class$org$apache$muse$ws$notification$topics$impl$SimpleTopicNamespace = SimpleTopicNamespace.class$("org.apache.muse.ws.notification.topics.impl.SimpleTopicNamespace")) : class$org$apache$muse$ws$notification$topics$impl$SimpleTopicNamespace));
    private String _name = null;
    private Map _rootTopics = new LinkedHashMap();
    private String _targetNamespace = null;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$topics$impl$SimpleTopicNamespace;

    public SimpleTopicNamespace(Element root) throws BaseFault {
        if (root == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicSpaceElement"));
        }
        this._targetNamespace = root.getAttribute("targetNamespace");
        if (this._targetNamespace == null) {
            throw new InvalidTopicExpressionFault(_MESSAGES.get("NoTopicSpaceNS"));
        }
        this._name = root.getAttribute("name");
        Element[] children = XmlUtils.getElements((Node)root, (QName)WstConstants.TOPIC_QNAME);
        for (int n = 0; n < children.length; ++n) {
            SimpleTopic topic = new SimpleTopic(children[n], (TopicNamespace)this);
            this.addTopic(topic);
        }
    }

    public SimpleTopicNamespace(String targetNamespace) {
        if (targetNamespace == null) {
            throw new NullPointerException(_MESSAGES.get("NullTargetNS"));
        }
        this._targetNamespace = targetNamespace;
    }

    public final synchronized void addTopic(Topic topic) throws BaseFault {
        if (topic == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopic"));
        }
        String name = topic.getName();
        if (this._rootTopics.containsKey(name)) {
            Object[] filler = new Object[]{name, this.getTargetNamespace()};
            throw new InvalidTopicExpressionFault(_MESSAGES.get("TopicExists", filler));
        }
        TopicNamespace topicSpace = topic.getTopicNamespace();
        if (topicSpace != this) {
            Object[] filler = new Object[]{topicSpace.getTargetNamespace(), this.getTargetNamespace()};
            throw new InvalidTopicExpressionFault(_MESSAGES.get("InvalidTopicNS", filler));
        }
        this._rootTopics.put(name, topic);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TopicNamespace that = (TopicNamespace)obj;
        return this.getTargetNamespace().equals(that.getTargetNamespace());
    }

    public final synchronized String getName() {
        return this._name;
    }

    public final synchronized Collection getRootTopics() {
        return Collections.unmodifiableCollection(this._rootTopics.values());
    }

    public final synchronized String getTargetNamespace() {
        return this._targetNamespace;
    }

    public final synchronized Topic getTopic(String topicName) {
        return (Topic)this._rootTopics.get(topicName);
    }

    public int hashCode() {
        return this.getTargetNamespace().hashCode();
    }

    public final synchronized boolean hasTopic(String topicName) {
        return this.getTopic(topicName) != null;
    }

    public final synchronized void removeTopic(String topicName) {
        if (topicName == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicName"));
        }
        this._rootTopics.remove(topicName);
    }

    public final synchronized void setName(String name) {
        this._name = name;
    }

    public synchronized String toString() {
        return XmlUtils.toString((Node)this.toXML(), (boolean)false);
    }

    public synchronized Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public synchronized Element toXML(Document doc) {
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element topicSpace = XmlUtils.createElement((Document)doc, (QName)WstConstants.TOPIC_NAMESPACE_QNAME);
        topicSpace.setAttribute("targetNamespace", this.getTargetNamespace());
        String name = this.getName();
        if (name != null) {
            topicSpace.setAttribute("name", name);
        }
        Iterator i = this.getRootTopics().iterator();
        while (i.hasNext()) {
            Topic topic = (Topic)i.next();
            Element topicXML = topic.toXML(doc);
            topicSpace.appendChild(topicXML);
        }
        return topicSpace;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

