/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.adapter.util.AbstractXPATHFilterExit;

public class WindowsEventLogFilterExit
extends AbstractXPATHFilterExit {
    private SimpleDateFormat SDFformatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat SDFparser = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.S", Locale.US);

    public short parseSeverity(String record) {
        int firstOccuranceIndex = record.indexOf("Severity");
        if (firstOccuranceIndex != -1) {
            int startIndex = record.indexOf(": ", firstOccuranceIndex);
            int endIndex = record.indexOf(";", firstOccuranceIndex + 1);
            if (startIndex != -1 && endIndex != -1 && startIndex < endIndex) {
                String severity = record.substring(startIndex + 2, endIndex).trim();
                try {
                    return Short.parseShort(severity);
                }
                catch (Exception exception) {}
            }
        }
        return 0;
    }

    public String parseTime(String record) {
        int firstOccuranceIndex = record.indexOf("CreationTime");
        if (firstOccuranceIndex != -1) {
            Date creationDate;
            int startIndex = record.indexOf(": ", firstOccuranceIndex);
            int endIndex = record.indexOf(";", firstOccuranceIndex + 1);
            StringBuffer currentTimeStamp = null;
            if (startIndex != -1 && endIndex != -1 && startIndex < endIndex && (creationDate = this.SDFparser.parse(record.substring(startIndex + 1, endIndex).trim(), new ParsePosition(0))) != null) {
                currentTimeStamp = new StringBuffer(this.SDFformatter.format(creationDate).trim());
                currentTimeStamp.replace(10, 11, "T");
                currentTimeStamp.append(".000000");
                if (this.getTimezone() != null) {
                    String tz = this.getTimezone();
                    currentTimeStamp.append(tz.charAt(0));
                    currentTimeStamp.append(tz.substring(1, 3));
                    currentTimeStamp.append(":");
                    currentTimeStamp.append(tz.substring(3, 5));
                } else {
                    Calendar localCalendar = Calendar.getInstance();
                    localCalendar.setTime(creationDate);
                    int utcOffset = (localCalendar.get(15) + localCalendar.get(16)) / 60000;
                    if (utcOffset < 0) {
                        currentTimeStamp.append("-");
                    } else {
                        currentTimeStamp.append("+");
                    }
                    utcOffset = Math.abs(utcOffset);
                    String numberHours = String.valueOf(utcOffset / 60);
                    if (numberHours.length() == 1) {
                        currentTimeStamp.append("0");
                    }
                    currentTimeStamp.append(numberHours);
                    currentTimeStamp.append(":");
                    String numberMinutes = String.valueOf(utcOffset % 60);
                    if (numberMinutes.length() == 1) {
                        currentTimeStamp.append("0");
                    }
                    currentTimeStamp.append(numberMinutes);
                }
                return currentTimeStamp.toString();
            }
        }
        return null;
    }
}

