/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.NestedColumnUtil;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParser;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.XMLDataInputStream;

public class SaxParserComplexNestedQueryHelper
implements ISaxParserConsumer {
    private String tableName;
    private RelationInformation relationInfo;
    private String[] namesOfNestedColumns;
    private SaxParser sp;
    private Thread spThread;
    private NestedColumnUtil nestedColumnUtil;
    private SaxParserConsumer consumer;

    protected SaxParserComplexNestedQueryHelper(SaxParserConsumer consumer, RelationInformation rinfo, XMLDataInputStream xdis, String tName) {
        this.tableName = tName;
        this.relationInfo = rinfo;
        this.consumer = consumer;
        this.namesOfNestedColumns = this.relationInfo.getTableComplexNestedXMLColumnNames(this.tableName);
        this.nestedColumnUtil = new NestedColumnUtil(this.relationInfo, this.tableName, false);
        this.sp = new SaxParser(xdis, this);
        this.spThread = new Thread(this.sp);
        this.spThread.start();
    }

    public boolean isPrepared() {
        return !this.spThread.isAlive();
    }

    public void manipulateData(String path, String value) {
        int i = 0;
        while (i < this.namesOfNestedColumns.length) {
            this.nestedColumnUtil.update(this.namesOfNestedColumns[i], path, value);
            ++i;
        }
    }

    public void detectNewRow(String path, boolean start) {
    }

    public void wakeup() {
        this.consumer.wakeup();
    }

    NestedColumnUtil getNestedColumnUtil() {
        return this.nestedColumnUtil;
    }
}

