/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.dataManager.impl;

import java.util.Properties;
import org.apache.muse.core.Capability;
import org.apache.muse.util.uuid.RandomUuidFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.dm.muws.Description;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.eclipse.cosmos.dc.broker.client.BrokerClient;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.dc.management.domain.client.ManagementDomainClient;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedProperty;
import org.eclipse.cosmos.dc.mgmt.binding.Binding;

public abstract class AbstractDataManager
implements IDataManager {
    @ManagedProperty(resourceID=true)
    private String identifier = "undefined";
    @ManagedFrameworkAutowire(name="WSDM")
    private Binding wsdmBinding;
    protected Properties config = null;
    private boolean initialized = false;
    private EndpointReference domainEpr = null;
    private String displayName = null;
    private String description = null;
    private EndpointReference dataManagerEPR = null;

    public void setWsdmBinding(Binding wsdmBinding) {
        this.wsdmBinding = wsdmBinding;
    }

    public String getIdentifier() {
        this.identifier = this.config != null ? this.config.getProperty("RESOURCE_ID") : RandomUuidFactory.getInstance().createUUID();
        return this.identifier;
    }

    public String getDisplayName() {
        if (this.displayName == null && this.config != null) {
            this.displayName = this.config.getProperty("DISPLAY_NAME");
        }
        return this.displayName;
    }

    public String getDescription() {
        if (this.description == null && this.config != null) {
            this.description = this.config.getProperty("DESCRIPTION");
        }
        return this.description;
    }

    public void setConfigProperties(Properties config) {
        this.config = config;
    }

    public void setManagementDomainEPR(EndpointReference domainEPR) {
        this.domainEpr = domainEPR;
    }

    protected String getConfigProperty(String key) {
        return this.config != null ? this.config.getProperty(key) : null;
    }

    private void initialize() throws DataManagerException {
        if (!this.initialized) {
            Object resourceObject = this.wsdmBinding.getBindingForObject((Object)this);
            WsResource resource = null;
            if (resourceObject == null || !(resourceObject instanceof WsResource)) {
                throw new DataManagerException("Unable to access WsResource object of data manager");
            }
            resource = (WsResource)resourceObject;
            this.dataManagerEPR = resource.getEndpointReference();
            Capability c = resource.getCapability("http://docs.oasis-open.org/wsdm/muws/capabilities/Description");
            Description d = (Description)c;
            this.displayName = this.config.getProperty("DISPLAY_NAME");
            this.description = this.config.getProperty("DESCRIPTION");
            try {
                d.setCaption(new String[]{this.displayName});
                d.setDescription(new String[]{this.description});
            }
            catch (BaseFault baseFault) {
                throw new DataManagerException("Error occurred ");
            }
        }
    }

    public void register() throws DataManagerException {
        System.out.println("Register MDR with COSMOS broker...");
        this.initialize();
        String[] brokerEPRs = null;
        try {
            ManagementDomainClient client = new ManagementDomainClient(this.domainEpr);
            brokerEPRs = client.getAllServices();
        }
        catch (Exception e) {
            throw new DataManagerException("Error occurred while getting broker EPR from management domain.", (Throwable)e);
        }
        int i = 0;
        while (i < brokerEPRs.length) {
            try {
                EndpointReference brokerEPR = new EndpointReference(XmlUtils.createDocument((String)brokerEPRs[i]).getDocumentElement());
                BrokerClient brokerClient = new BrokerClient(brokerEPR);
                brokerClient.add(this.dataManagerEPR, null);
            }
            catch (Exception e) {
                throw new DataManagerException("Error occurred during registration with data broker.", (Throwable)e);
            }
            ++i;
        }
    }

    public void deregister() throws DataManagerException {
        System.out.println("deregister MDR from broker");
    }
}

