/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.dataManager.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractDataManagerActivator
implements BundleActivator,
ServiceListener {
    protected static final String MGMT_SRV_FILTER = "(objectclass=org.eclipse.cosmos.dc.mgmt.binding.Binding)";
    protected BundleContext context;
    private IDataManager dataMgrImpl;

    public void start(BundleContext context) throws Exception {
        this.dataMgrImpl = this.getDataManagerInstance();
        URL resource = context.getBundle().getResource("/META-INF/config.properties");
        Properties dmConfig = new Properties();
        dmConfig.load(resource.openStream());
        this.dataMgrImpl.setConfigProperties(dmConfig);
        String domainEprFile = (String)dmConfig.get("MGMT_DOMAIN_EPR_FILE");
        if (domainEprFile == null) {
            System.out.println("Warning: Data manager registration cannot be completed because EPR of management domain is not set.");
        } else {
            URL domainEprURL = context.getBundle().getResource(domainEprFile);
            Document domainEprDoc = XmlUtils.createDocument((InputStream)domainEprURL.openStream());
            Element eprElement = domainEprDoc.getDocumentElement();
            EndpointReference domainEpr = new EndpointReference(eprElement);
            this.dataMgrImpl.setManagementDomainEPR(domainEpr);
        }
        this.context = context;
        context.addServiceListener((ServiceListener)this, MGMT_SRV_FILTER);
        ServiceReference[] references = context.getServiceReferences(null, MGMT_SRV_FILTER);
        int i = 0;
        while (references != null && i < references.length) {
            this.serviceChanged(new ServiceEvent(1, references[i]));
            ++i;
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                ServiceReference ref = this.context.getServiceReference("org.eclipse.cosmos.dc.mgmt.common.ContributionManager");
                if (ref == null) break;
                ContributionManager manager = (ContributionManager)this.context.getService(ref);
                manager.manage((Object)this.dataMgrImpl);
                try {
                    this.dataMgrImpl.register();
                }
                catch (Exception exception) {
                    System.out.println("Tried to register data manager with broker at startup, but registration failed.");
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected abstract IDataManager getDataManagerInstance();
}

