/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.xml.namespace.QName;
import org.apache.muse.core.Capability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.core.routing.ReflectionMessageHandler;
import org.apache.muse.ws.dm.muws.impl.SimpleDescription;
import org.apache.muse.ws.dm.muws.impl.SimpleManageabilityCharacteristics;
import org.apache.muse.ws.dm.muws.impl.SimpleMetrics;
import org.apache.muse.ws.dm.muws.impl.SimpleOperationalStatus;
import org.apache.muse.ws.dm.muws.impl.SimpleRelationships;
import org.apache.muse.ws.notification.impl.SimpleNotificationConsumer;
import org.apache.muse.ws.notification.impl.SimpleNotificationProducer;
import org.apache.muse.ws.resource.lifetime.impl.SimpleImmediateTermination;
import org.apache.muse.ws.resource.lifetime.impl.SimpleScheduledTermination;
import org.apache.muse.ws.resource.properties.get.impl.SimpleGetCapability;
import org.apache.muse.ws.resource.properties.query.impl.SimpleQueryCapability;
import org.apache.muse.ws.resource.properties.set.impl.SimpleSetCapability;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.DynamicAdvertisementCapability;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.DynamicOperationalStatus;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.WSDLSource;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMAttributeInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMNotificationInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMOperationInfo;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.info.WSDMRelationInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDMInfo
extends MBeanInfo {
    private WSDMAttributeInfo resourceIdAttribute = null;
    private WSDMRelationInfo[] relations;
    private String targetNamespace = "";
    private boolean hasMetrics = false;
    private boolean advertised = false;
    private boolean hasEventConsumers = false;
    private String advertisementConsumer = "";
    private Annotation[] annotations;
    private HashMap<String, WSDMOperationInfo> metaMethodMap = new HashMap();
    private HashMap<String, String> namespaceList = new HashMap();
    private HashMap<Class, HashMap<String, HandlerDescriptor>> capabilityMethodMap = new HashMap();

    public WSDMInfo(String name, String description, String targetNamespace, WSDMAttributeInfo[] properties, MBeanConstructorInfo[] constructors, WSDMOperationInfo[] operations, WSDMRelationInfo[] relations, WSDMNotificationInfo[] notifications, Annotation[] annotations) throws IllegalArgumentException {
        super(name, description, properties, constructors, operations, notifications);
        int n;
        int n2;
        Object[] objectArray;
        int namespaceCount = 0;
        this.targetNamespace = targetNamespace;
        this.annotations = annotations;
        this.namespaceList.put(targetNamespace, "dyn");
        if (properties != null) {
            objectArray = properties;
            n2 = properties.length;
            n = 0;
            while (n < n2) {
                Object property = objectArray[n];
                if (((WSDMAttributeInfo)property).isResourceID() && ((MBeanAttributeInfo)property).isReadable() && !((MBeanAttributeInfo)property).isWritable()) {
                    this.resourceIdAttribute = property;
                } else if (((WSDMAttributeInfo)property).isMetric()) {
                    this.hasMetrics = true;
                }
                ++n;
            }
        }
        if (operations != null) {
            objectArray = operations;
            n2 = operations.length;
            n = 0;
            while (n < n2) {
                String namespace;
                Object operation = objectArray[n];
                ((WSDMOperationInfo)operation).isMetaDataMethod();
                if (((WSDMOperationInfo)operation).isEventConsumer()) {
                    this.hasEventConsumers = true;
                }
                if (!"".equals(namespace = ((WSDMOperationInfo)operation).getNamespace()) && this.namespaceList.get(namespace) == null) {
                    this.namespaceList.put(namespace, "dyn_" + namespaceCount++);
                }
                ++n;
            }
        }
        this.relations = relations;
        objectArray = annotations;
        n2 = annotations.length;
        n = 0;
        while (n < n2) {
            Object annotation = objectArray[n];
            if (annotation instanceof ManagedResource) {
                this.advertised = ((ManagedResource)annotation).advertise();
                this.advertisementConsumer = ((ManagedResource)annotation).advertisementConsumer();
                break;
            }
            ++n;
        }
    }

    public boolean hasNamespace(String namespace) {
        return this.namespaceList.containsKey(namespace);
    }

    public String[] getNamespaces() {
        return this.namespaceList.keySet().toArray(new String[0]);
    }

    public String getPrefixForNamespace(String namespace) {
        if ("".equals(namespace)) {
            return "dyn";
        }
        return this.namespaceList.get(namespace);
    }

    public WSDMAttributeInfo getResourceIdField() {
        return this.resourceIdAttribute;
    }

    public boolean resourceLifetimeSupport() {
        return false;
    }

    public boolean hasMetrics() {
        return this.hasMetrics;
    }

    public boolean isAdvertised() {
        return this.advertised;
    }

    public boolean hasEventConsumers() {
        return this.hasEventConsumers;
    }

    public String getAdvertisementConsumer() {
        return this.advertisementConsumer;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getResourceName() {
        return this.getClassName();
    }

    public WSDMRelationInfo[] getRelations() {
        return this.relations;
    }

    public void compileCapabilties(Environment environment) {
        WSDLSource metaData = new WSDLSource(this);
        metaData.setEnvironment(environment);
        Document wsdl = metaData.getWSDLDocument();
        Element binding = (Element)wsdl.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "binding").item(0);
        Element portType = (Element)wsdl.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "portType").item(0);
        HashMap<String, Element> actionToElementMap = new HashMap<String, Element>();
        NodeList children = binding.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "operation");
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            child.getAttribute("name");
            NodeList inputChild = child.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "operation");
            String action = ((Element)inputChild.item(0)).getAttribute("soapAction");
            actionToElementMap.put(action, child);
            ++i;
        }
        this.capabilityMethodMap.put(WSDLSource.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, WSDLSource.class));
        this.capabilityMethodMap.put(SimpleDescription.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleDescription.class));
        this.capabilityMethodMap.put(SimpleGetCapability.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleGetCapability.class));
        this.capabilityMethodMap.put(SimpleSetCapability.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleSetCapability.class));
        this.capabilityMethodMap.put(SimpleQueryCapability.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleQueryCapability.class));
        this.capabilityMethodMap.put(SimpleManageabilityCharacteristics.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleManageabilityCharacteristics.class));
        if (this.namespaceList.containsKey("http://docs.oasis-open.org/wsdm/muws/capabilities/OperationalStatus")) {
            this.capabilityMethodMap.put(DynamicOperationalStatus.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, DynamicOperationalStatus.class));
        } else {
            this.capabilityMethodMap.put(SimpleOperationalStatus.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleOperationalStatus.class));
        }
        if (this.resourceLifetimeSupport()) {
            this.capabilityMethodMap.put(SimpleImmediateTermination.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleImmediateTermination.class));
            this.capabilityMethodMap.put(SimpleScheduledTermination.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleScheduledTermination.class));
        }
        if (this.getNotifications().length > 0 || this.advertised) {
            this.capabilityMethodMap.put(SimpleNotificationProducer.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleNotificationProducer.class));
        }
        if (this.getRelations().length > 0) {
            this.capabilityMethodMap.put(SimpleRelationships.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleRelationships.class));
        }
        if (this.hasMetrics) {
            this.capabilityMethodMap.put(SimpleMetrics.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleMetrics.class));
        }
        if (this.advertised) {
            this.capabilityMethodMap.put(DynamicAdvertisementCapability.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, DynamicAdvertisementCapability.class));
        }
        if (this.hasEventConsumers()) {
            this.capabilityMethodMap.put(SimpleNotificationConsumer.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, SimpleNotificationConsumer.class));
        }
    }

    protected MessageHandler createMessageHandler(String actionURI, QName operationName, QName returnValueName) {
        return new ReflectionMessageHandler(actionURI, operationName, returnValueName);
    }

    protected HashMap compileMessageHandlers(Document wsdl, Element portType, Map opsByAction, Class theClass) {
        HashMap<String, HandlerDescriptor> descriptorMap = new HashMap<String, HandlerDescriptor>();
        HashMap<String, Method> methodsByName = new HashMap<String, Method>();
        Method[] methods = theClass.getMethods();
        NamedNodeMap docAttrs = wsdl.getDocumentElement().getAttributes();
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        int i = 0;
        while (i < docAttrs.getLength()) {
            Attr attr = (Attr)docAttrs.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
                if ("xmlns".equals(attr.getName())) {
                    prefixMap.put("", attr.getValue());
                } else {
                    prefixMap.put(attr.getName().substring("xmlns:".length(), attr.getName().length()), attr.getValue());
                }
            } else if ("targetNamespace".equals(attr.getName())) {
                prefixMap.put("dyn", attr.getValue());
            }
            ++i;
        }
        int n = 0;
        while (n < methods.length) {
            Class<?> declaringClass = methods[n].getDeclaringClass();
            if (declaringClass != Object.class && declaringClass != Capability.class) {
                methodsByName.put(methods[n].getName(), methods[n]);
            }
            ++n;
        }
        new ArrayList(opsByAction.size());
        Iterator i2 = opsByAction.keySet().iterator();
        while (i2.hasNext()) {
            String action = (String)i2.next();
            Element next = (Element)opsByAction.get(action);
            QName inputName = this.getInputPartName(prefixMap, wsdl, portType, next);
            QName outputName = this.getOutputPartName(prefixMap, wsdl, portType, next);
            String localName = next.getAttribute("name");
            String methodName = this.getMethodName(localName);
            Method method = (Method)methodsByName.get(methodName);
            String qualifiedAction = this.getQualifiedAction(portType, next);
            if (qualifiedAction == null) {
                qualifiedAction = action;
            }
            if (method == null) continue;
            descriptorMap.put(qualifiedAction, new HandlerDescriptor(method, inputName, outputName));
            i2.remove();
        }
        return descriptorMap;
    }

    public Collection createMessageHandlers(Class theClass) {
        Map actionMap = this.capabilityMethodMap.get(theClass);
        ArrayList<MessageHandler> handlers = new ArrayList<MessageHandler>();
        if (actionMap == null) {
            System.out.println("Oops");
        }
        for (String action : actionMap.keySet()) {
            HandlerDescriptor desc = (HandlerDescriptor)actionMap.get(action);
            MessageHandler handler = this.createMessageHandler(action, desc.inputName, desc.outputName);
            handler.setMethod(desc.method);
            handlers.add(handler);
        }
        return handlers;
    }

    private QName getInputPartName(HashMap<String, String> prefixMap, Document doc, Element portType, Element oper) {
        return this.getPartName("input", doc, prefixMap, portType, oper);
    }

    private QName getOutputPartName(HashMap<String, String> prefixMap, Document doc, Element portType, Element oper) {
        return this.getPartName("output", doc, prefixMap, portType, oper);
    }

    private QName getPartName(String part, Document doc, HashMap<String, String> prefixMap, Element portType, Element oper) {
        NodeList inputChild = oper.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "input");
        ((Element)inputChild.item(0)).getAttribute("name");
        String message = null;
        NodeList operTypeList = portType.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "operation");
        int i = 0;
        while (i < operTypeList.getLength()) {
            Element type = (Element)operTypeList.item(i);
            if (oper.getAttribute("name").equals(type.getAttribute("name"))) {
                message = ((Element)type.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", part).item(0)).getAttribute("message");
                break;
            }
            ++i;
        }
        String namespace = prefixMap.get("dyn");
        String name = message;
        if (message == null) {
            // empty if block
        }
        if (message.indexOf(":") > 0) {
            String prefix = message.substring(0, message.indexOf(":"));
            name = message.substring(message.indexOf(":") + 1, message.length());
            namespace = prefixMap.get(prefix);
        }
        NodeList messageList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "message");
        int i2 = 0;
        while (i2 < messageList.getLength()) {
            Element msg = (Element)messageList.item(i2);
            if (name.equals(msg.getAttribute("name"))) {
                String partName;
                msg.getNamespaceURI();
                message = partName = ((Element)msg.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "part").item(0)).getAttribute("element");
                name = partName;
                if (message.indexOf(":") > 0) {
                    String prefix = message.substring(0, message.indexOf(":"));
                    name = message.substring(message.indexOf(":") + 1, message.length());
                    namespace = prefixMap.get(prefix);
                    return new QName(namespace, name, prefix);
                }
            }
            ++i2;
        }
        return null;
    }

    private String getQualifiedAction(Element portType, Element oper) {
        NodeList operTypeList = portType.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "operation");
        int i = 0;
        while (i < operTypeList.getLength()) {
            Element type = (Element)operTypeList.item(i);
            if (oper.getAttribute("name").equals(type.getAttribute("name"))) {
                return ((Element)type.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "input").item(0)).getAttributeNS("http://www.w3.org/2005/08/addressing", "Action");
            }
            ++i;
        }
        return null;
    }

    private String getMethodName(String actionName) {
        return String.valueOf(Character.toLowerCase(actionName.charAt(0))) + actionName.substring(1);
    }

    private class HandlerDescriptor {
        Method method;
        QName inputName;
        QName outputName;

        public HandlerDescriptor(Method method, QName inputName, QName outputName) {
            this.method = method;
            this.inputName = inputName;
            this.outputName = outputName;
        }
    }
}

