/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.remote.wsdm.spec;

import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.eclipse.cosmos.dc.remote.wsdm.api.ContextClient;
import org.eclipse.cosmos.dc.remote.wsdm.spec.UtilityClient;
import org.eclipse.cosmos.dc.remote.wsdm.spi.RuntimeHostClient;
import org.w3c.dom.Element;

public class DataBrokerClient
extends WsResourceClient {
    public static final String DEFAULT_DATABROKER_NAME = "Default";
    public static final String DATABROKER_CONTEXT_NAME = "DataBroker.xml";
    public static final String DATABROKER_EP = "/cosmos/services/org.eclipse.cosmos.dc.local.registry.DataBroker";
    public static final String DATABROKER_RES_ID = "DataBrokerIdentifierValue";
    public static final QName BROKER_GETDATAMANAGERS_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "getDataManagers");
    public static final QName BROKER_REGISTERDATAMANAGER_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "registerDataManager");
    public static final QName BROKER_DEREGISTERDATAMANAGER_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "deregisterDataManager");
    public static final QName BROKER_PINGDATABROKER_QNAME = new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "pingDataBroker");

    public DataBrokerClient(EndpointReference epr) {
        super(epr);
    }

    public static EndpointReference getDataBrokerEPR(String hostAddress, int runtimePort) throws Exception {
        URI uri = UtilityClient.getURIAddress(hostAddress, DATABROKER_EP, runtimePort);
        EndpointReference epr = new EndpointReference(uri);
        epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, (Object)DATABROKER_RES_ID);
        return epr;
    }

    public static synchronized WsResourceClient loadDataBrokerContext(String hostAddress, int runtimePort) throws Exception {
        URI uri = UtilityClient.getURIAddress(hostAddress, UtilityClient.OSGI_RUNTIME_HOST, runtimePort);
        EndpointReference epr = new EndpointReference(uri);
        epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, (Object)"RuntimeIdentifierValue");
        RuntimeHostClient client = new RuntimeHostClient(epr);
        ContextClient context = client.loadContext(DATABROKER_CONTEXT_NAME);
        client.getContexts();
        return context;
    }

    public Element getDataManagers(String classification) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability/getDataManagers";
        Element soapBody = XmlUtils.createElement((QName)BROKER_GETDATAMANAGERS_QNAME);
        Element parm = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "classification"));
        if (classification != null) {
            parm.setTextContent(classification);
        }
        soapBody.appendChild(parm);
        Element result = this.invoke(action, soapBody);
        return result;
    }

    public Element registerDataManager(String endpointAddress, String endpointResourceId, String dataManagerName, String classification, String dialect) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability/registerDataManager";
        Element soapBody = XmlUtils.createElement((QName)BROKER_REGISTERDATAMANAGER_QNAME);
        Element elepr = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "endpointAddress"));
        if (endpointAddress != null) {
            elepr.setTextContent(endpointAddress);
        }
        Element elresid = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "endpointResourceId"));
        if (endpointResourceId != null) {
            elresid.setTextContent(endpointResourceId);
        }
        Element elName = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "name"));
        if (dataManagerName != null) {
            elName.setTextContent(dataManagerName);
        }
        Element elClassification = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "classification"));
        if (classification != null) {
            elClassification.setTextContent(classification);
        }
        Element elDialect = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "dialect"));
        if (dialect != null) {
            elDialect.setTextContent(dialect);
        }
        soapBody.appendChild(elepr);
        soapBody.appendChild(elresid);
        soapBody.appendChild(elName);
        soapBody.appendChild(elClassification);
        soapBody.appendChild(elDialect);
        Element result = this.invoke(action, soapBody);
        return result;
    }

    public Element deregisterDataManager(String name) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability/deregisterDataManager";
        Element soapBody = XmlUtils.createElement((QName)BROKER_DEREGISTERDATAMANAGER_QNAME);
        Element elName = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "name"));
        if (name != null) {
            elName.setTextContent(name);
        }
        soapBody.appendChild(elName);
        Element result = this.invoke(action, soapBody);
        return result;
    }

    public Element pingDataBroker(String name) throws Exception {
        String action = "http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability/pingDataBroker";
        Element soapBody = XmlUtils.createElement((QName)BROKER_PINGDATABROKER_QNAME);
        Element elName = XmlUtils.createElement((QName)new QName("http://www.eclipse.org/xmlns/cosmos/1.0/DataBrokerCapability", "name"));
        if (name != null) {
            elName.setTextContent(name);
        }
        soapBody.appendChild(elName);
        Element result = this.invoke(action, soapBody);
        return result;
    }
}

