/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.remote.wsdm.spec;

import java.text.ParseException;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.eclipse.cosmos.dc.spec.types.StatisticalObservation;
import org.eclipse.cosmos.dc.spec.types.StatisticalTuple;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpecSerializer
implements Serializer {
    private static SpecSerializer statisticalQuerySerializer = new SpecSerializer(StatisticalTuple.class);
    private static final int STATISTICAL_TUPLE_TYPE = 0;
    private static final int INVALID_TYPE = -1;
    private Class type;
    private int switchType = -1;

    public static SpecSerializer getStatisticalTupleSerializer() {
        return statisticalQuerySerializer;
    }

    private SpecSerializer(Class type) {
        this.type = type;
        if (StatisticalTuple.class.isAssignableFrom(type)) {
            this.switchType = 0;
        }
    }

    public Object fromXML(Element xml) throws SoapFault {
        try {
            switch (this.switchType) {
                case 0: {
                    return this.statisticalTupleFromXML(xml);
                }
            }
            throw new SoapFault("Unable to deserialize " + xml.getNodeName());
        }
        catch (Throwable t) {
            throw new SoapFault("Unable to deserialize ", t);
        }
    }

    private Object statisticalTupleFromXML(Element xml) throws ParseException {
        Element[] obsElements;
        StatisticalTuple tuple = new StatisticalTuple();
        Element[] elementArray = obsElements = XmlUtils.getAllElements((Node)xml, (String)StatisticalObservation.STAT_OBSERVATION_QNAME.getNamespaceURI(), (String)StatisticalObservation.STAT_OBSERVATION_QNAME.getLocalPart());
        int n = obsElements.length;
        int n2 = 0;
        while (n2 < n) {
            Element obsElement = elementArray[n2];
            String name = obsElement.getAttribute("name");
            String type = obsElement.getAttribute("type");
            Object value = null;
            value = "cont".equals(type) ? Double.valueOf(Double.parseDouble(obsElement.getAttribute("value"))) : ("int".equals(type) ? Long.valueOf(Long.parseLong(obsElement.getAttribute("value"))) : obsElement.getTextContent());
            tuple.add(new StatisticalObservation(name, value));
            ++n2;
        }
        tuple.setTimeStamp(XsdUtils.getLocalTime((String)xml.getAttribute("timestamp")));
        return tuple;
    }

    public Class getSerializableType() {
        return this.type;
    }

    public Element toXML(Object obj, QName qname) throws SoapFault {
        Element child;
        block4: {
            block3: {
                child = null;
                if (obj == null || !this.type.isInstance(obj)) break block3;
                switch (this.switchType) {
                    case 0: {
                        child = this.toXML((StatisticalTuple)obj);
                        break block4;
                    }
                    default: {
                        throw new SoapFault("Invalid object type:" + obj.getClass().getName());
                    }
                }
            }
            throw new SoapFault("Invalid object type:" + obj.getClass().getName());
        }
        return child;
    }

    private Element toXML(StatisticalTuple tuple) {
        StatisticalObservation[] observations;
        Element dsElement = XmlUtils.createElement((QName)StatisticalTuple.STAT_TUPLE_QNAME);
        dsElement.setAttribute("timestamp", XsdUtils.getLocalTimeString((Date)tuple.getTimeStamp()));
        StatisticalObservation[] statisticalObservationArray = observations = tuple.getObservations();
        int n = observations.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticalObservation obs = statisticalObservationArray[n2];
            Element obsElement = XmlUtils.createElement((QName)StatisticalObservation.STAT_OBSERVATION_QNAME);
            obsElement.setAttribute("name", obs.getName());
            if (obs.isContinuousObservation()) {
                obsElement.setAttribute("type", "cont");
                obsElement.setAttribute("value", Double.toString(obs.getContinuousValue()));
            } else if (obs.isIntegralObservation()) {
                obsElement.setAttribute("type", "int");
                obsElement.setAttribute("value", Long.toString(obs.getIntegralValue()));
            } else {
                obsElement.setAttribute("type", "string");
                obsElement.setTextContent(obs.getStringValue());
            }
            dsElement.appendChild(obsElement);
            ++n2;
        }
        return dsElement;
    }
}

