/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.Dimension;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.spi.InboundContext;
import org.eclipse.cosmos.dc.common.spi.OutboundContext;
import org.eclipse.cosmos.dc.common.spi.RuntimeHost;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ConsoleExtension
implements CommandProvider {
    BundleContext context;
    private static RuntimeHost runtime;

    public static void setRuntime(RuntimeHost rt) {
        runtime = rt;
    }

    public ConsoleExtension(BundleContext context) {
        this.context = context;
        Hashtable props = new Hashtable();
        context.registerService(CommandProvider.class.getName(), (Object)this, props);
    }

    public void _dc(CommandInterpreter ci) throws Exception {
        block35: {
            Bundle[] bundles;
            String name;
            block42: {
                block41: {
                    String key;
                    block40: {
                        block39: {
                            block38: {
                                block37: {
                                    block36: {
                                        if (runtime == null) {
                                            System.out.println("No Runtime available");
                                            return;
                                        }
                                        key = ci.nextArgument();
                                        if (!"start".equals(key)) break block36;
                                        runtime.start();
                                        break block35;
                                    }
                                    if (!"load".equals(key)) break block37;
                                    String name2 = ci.nextArgument();
                                    if (name2 == null) break block35;
                                    try {
                                        URL resource;
                                        Bundle bundle = this.getBundleForLoadTarget(name2);
                                        if (bundle != null && (resource = bundle.getResource("/META-INF/cosmos/" + name2)) != null) {
                                            runtime.loadContextFromStream(resource.openStream());
                                        }
                                        break block35;
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                    }
                                    break block35;
                                }
                                if (!"activate".equals(key)) break block38;
                                String name3 = ci.nextArgument();
                                if (name3 == null) break block35;
                                IDataCollectionContext ctx = runtime.getContextForName(name3);
                                if (ctx == null) {
                                    System.out.println("Unknown context " + name3);
                                } else {
                                    if (ctx instanceof InboundContext) {
                                        ((InboundContext)((Object)ctx)).activate();
                                    }
                                    System.out.println("Context " + name3 + " activated");
                                }
                                break block35;
                            }
                            if (!"deactivate".equals(key)) break block39;
                            String name4 = ci.nextArgument();
                            if (name4 == null) break block35;
                            IDataCollectionContext ctx = runtime.getContextForName(name4);
                            if (ctx == null) {
                                System.out.println("Unknown context " + name4);
                            } else {
                                if (ctx instanceof InboundContext) {
                                    ((InboundContext)((Object)ctx)).deactivate();
                                }
                                System.out.println("Context " + name4 + " deactivated");
                            }
                            break block35;
                        }
                        if (!"query".equals(key)) break block40;
                        String name5 = ci.nextArgument();
                        if (name5 == null) break block35;
                        IDataCollectionContext ctx = runtime.getContextForName(name5);
                        if (ctx == null) {
                            System.out.println("Unknown context " + name5);
                        } else if (ctx instanceof OutboundContext) {
                            String dialect = ci.nextArgument();
                            String response = ci.nextArgument();
                            String queryString = ci.nextArgument();
                            String dataSource = ci.nextArgument();
                            IDataQueryService query = ((OutboundContext)((Object)ctx)).getRootQuery();
                            if (query.supportedQuery(dialect, response)) {
                                query.query(dialect, response, queryString, dataSource);
                            } else {
                                System.out.println("Unsupported query combination");
                            }
                        } else {
                            System.out.println("Unable to query InboundContext " + name5);
                        }
                        break block35;
                    }
                    if (!"list".equals(key)) break block35;
                    name = ci.nextArgument();
                    if (!"contexts".equals(name)) break block41;
                    Collection<IDataCollectionContext> contexts = runtime.getContexts();
                    for (IDataCollectionContext ctx : contexts) {
                        String mode = "inbound";
                        if (ctx instanceof OutboundContext) {
                            mode = "outbound";
                        }
                        System.out.println(String.valueOf(ctx.getName()) + " " + mode);
                    }
                    break block35;
                }
                if (!"datasets".equals(name)) break block42;
                ProviderRegistry reg = runtime.getRegistry();
                ci.nextArgument();
                String constraint = ci.nextArgument();
                if ("flow".equals(constraint)) {
                    Collection<DataFlow> flows = reg.getAllDataFlows();
                    for (DataFlow flow : flows) {
                        Collection<DataSet> sets = reg.getDataSetsForFlow(flow);
                        if (sets.isEmpty()) continue;
                        System.out.println("Flow " + flow.getName());
                        for (DataSet set : sets) {
                            System.out.println("  DataSet " + set.getName());
                        }
                    }
                } else if ("source".equals(constraint)) {
                    Collection<DataSource> sources = reg.getAllDataSources();
                    for (DataSource source : sources) {
                        Collection<DataSet> sets = reg.getDataSetsForSource(source);
                        if (sets.isEmpty()) continue;
                        System.out.println("Source " + source.getName());
                        for (DataSet set : sets) {
                            System.out.println("  DataSet " + set.getName());
                        }
                    }
                } else {
                    Collection<DataSet> sets = reg.getAllDataSets();
                    for (DataSet set : sets) {
                        System.out.println("DataSet " + set.getName());
                        System.out.println("  Source " + set.getDataSource().getName());
                        System.out.println("  Start " + set.getStart());
                        System.out.println("  Stop " + set.getStop());
                        System.out.println("  Flow " + set.getDataFlow().getName());
                        System.out.println("  Source " + set.getDataFlow().getDataSource().getName());
                        System.out.println("  Dimensions ");
                        Collection<Dimension> dims = set.getDataFlow().getDimensionSet().getDimensions();
                        for (Dimension dim : dims) {
                            System.out.println("      Dim " + dim.getName());
                        }
                    }
                }
                break block35;
            }
            if (!"assemblies".equals(name)) break block35;
            Bundle[] bundleArray = bundles = this.context.getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                block43: {
                    Bundle bundle = bundleArray[n2];
                    Enumeration resources = bundle.getEntryPaths("META-INF/cosmos/");
                    if (resources == null) break block43;
                    switch (bundle.getState()) {
                        case 32: {
                            break;
                        }
                        case 4: {
                            bundle.start();
                            break;
                        }
                        default: {
                            break block43;
                        }
                    }
                    System.out.println("Bundle(" + bundle.getBundleId() + ") " + bundle.getSymbolicName());
                    while (resources.hasMoreElements()) {
                        String element = (String)resources.nextElement();
                        if (element.startsWith("META-INF/cosmos/")) {
                            element = element.substring(16);
                        }
                        System.out.println("   " + element);
                    }
                }
                ++n2;
            }
        }
    }

    public void stop() {
        if (runtime != null) {
            runtime.stop();
        }
    }

    public String getHelp() {
        return "dc (start|stop) registers or unregisters service";
    }

    /*
     * Unable to fully structure code
     */
    private Bundle getBundleForLoadTarget(String target) {
        var6_3 = bundles = this.context.getBundles();
        var5_4 = bundles.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            block9: {
                bundle = var6_3[var4_5];
                try {
                    resources = bundle.getEntryPaths("META-INF/cosmos/");
                    if (resources == null) break block9;
                    switch (bundle.getState()) {
                        case 32: {
                            ** GOTO lbl19
                        }
                        case 4: {
                            bundle.start();
                            if (true) ** GOTO lbl19
                        }
                    }
                    break block9;
                    do {
                        if (!(element = (String)resources.nextElement()).endsWith("/" + target)) continue;
                        return bundle;
lbl19:
                        // 3 sources

                    } while (resources.hasMoreElements());
                }
                catch (NoSuchElementException v0) {
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ++var4_5;
        }
        return null;
    }
}

