/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.api.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.spi.IWireSource;
import org.eclipse.cosmos.dc.mgmt.annotations.CreateManagedRelation;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;

public abstract class AbstractPersistor
implements IDataSinkService {
    private static Class[] EMPTY_LIST = new Class[0];
    private static Class[] supportedTypes = EMPTY_LIST;
    private static HashMap<Class, Method> methodMap = new HashMap();
    private IWireSource wireSource;
    private Method wireMethod;
    protected IDataSinkService _proxy;

    protected abstract Class[] getSupportedTypes();

    public AbstractPersistor(ContributionManager manager) {
        Method[] methods;
        supportedTypes = this.getSupportedTypes();
        Method[] methodArray = methods = this.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals("store") && method.getParameterTypes().length <= 1 && Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
                Class[] classArray = supportedTypes;
                int n3 = supportedTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class supportedType = classArray[n4];
                    if (method.getParameterTypes()[0].isAssignableFrom(supportedType)) {
                        methodMap.put(supportedType, method);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this._proxy = (IDataSinkService)manager.manage((Object)this);
    }

    public boolean acceptType(Class type) {
        Class[] classArray = supportedTypes;
        int n = supportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class supportedType = classArray[n2];
            if (supportedType.isAssignableFrom(type)) {
                Method method = methodMap.get(type);
                if (method == null) {
                    method = methodMap.get(supportedType);
                    if (method == null) {
                        System.out.println("Hmmmm... " + this.getClass().getName() + " claimed support for " + supportedType.getName() + " but provided no store method");
                        return false;
                    }
                    methodMap.put(type, method);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Method getStoreMethod(Class type) {
        return methodMap.get(type);
    }

    public abstract boolean acceptWireSource(IWireSource var1) throws Exception;

    @CreateManagedRelation(type="WireSource", namespace="http://www.eclipse.org/xmlns/cosmos/1.0")
    public void setWireSource(IWireSource source) throws Exception {
        this.wireSource = source;
    }

    public IWireSource getWireSource() {
        return this.wireSource;
    }

    public void setWireMethod(Method wireMethod) {
        this.wireMethod = wireMethod;
    }

    public Method getWireMethod() {
        return this.wireMethod;
    }

    public Class[] getAcceptableTypes() {
        return this.getSupportedTypes();
    }
}

