/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.registry.util;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataSourceService;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.DataSourceType;
import org.eclipse.cosmos.dc.common.registry.Dimension;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataFlow;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataSource;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataSourceType;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDimension;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDimensionSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistryBindingUtil {
    public static DataSource getDataSource(ProviderRegistry registry, Element root) throws Exception {
        Element dataSourceElement = XmlUtils.getElement((Node)root, (QName)IDataSourceService.DATA_SOURCE_QNAME);
        String name = dataSourceElement.getAttribute("name");
        String type = dataSourceElement.getAttribute("type");
        boolean register = "true".equals(dataSourceElement.getAttribute("register"));
        DataSource ds = registry.getDataSource(name);
        DataSourceType dt = registry.getDataSourceType(type);
        if (register && ds == null) {
            if (dt == null) {
                dt = new SimpleDataSourceType(type);
                registry.registerDataSourceType(dt);
            }
            ds = new SimpleDataSource(name, dt);
            registry.registerDataSource(ds);
        }
        return ds;
    }

    public static DataFlow getDataFlow(ProviderRegistry registry, Element root) throws Exception {
        Element dataFlowElement = XmlUtils.getElement((Node)root, (QName)IDataSinkService.DATA_FLOW_QNAME);
        String name = dataFlowElement.getAttribute("name");
        boolean register = "true".equals(dataFlowElement.getAttribute("register"));
        DataFlow df = registry.getDataFlow(name);
        if (register && df == null) {
            DataSource ds = RegistryBindingUtil.getDataSource(registry, dataFlowElement);
            DimensionSet dims = RegistryBindingUtil.getDimensionSet(registry, dataFlowElement);
            df = new SimpleDataFlow(name, ds, dims);
            registry.registerDataFlow(df);
        }
        return df;
    }

    public static DimensionSet getDimensionSet(ProviderRegistry registry, Element root) throws Exception {
        Element dimsElement = XmlUtils.getElement((Node)root, (QName)IDataSinkService.DATA_KEY_SET_QNAME);
        String name = dimsElement.getAttribute("name");
        boolean register = "true".equals(dimsElement.getAttribute("register"));
        DimensionSet dims = registry.getDimensionSet(name);
        if (register && dims == null) {
            Element[] keys = XmlUtils.getAllElements((Node)dimsElement, (String)"http://www.eclipse.org/xmlns/cosmos/1.0", (String)"key");
            ArrayList<Dimension> dimList = new ArrayList<Dimension>();
            Element[] elementArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Element key = elementArray[n2];
                String keyName = key.getAttribute("name");
                String keyType = key.getAttribute("type");
                SimpleDimension dim = new SimpleDimension(keyName, keyType);
                dimList.add(dim);
                ++n2;
            }
            dims = new SimpleDimensionSet(name, dimList);
            registry.registerDimensionSet(dims);
        }
        return dims;
    }

    private static DataSourceType getDataSourceType(ProviderRegistry registry, Element root) throws Exception {
        Element typeElement = XmlUtils.getElement((Node)root, (QName)IDataSinkService.DATA_SOURCE_TYPE_QNAME);
        String name = typeElement.getAttribute("name");
        boolean register = "true".equals(typeElement.getAttribute("register"));
        DataSourceType dt = registry.getDataSourceType(name);
        if (register && dt == null) {
            dt = new SimpleDataSourceType(name);
            registry.registerDataSourceType(dt);
        }
        return dt;
    }
}

