/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.spi.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataSourceService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataFlow;
import org.eclipse.cosmos.dc.common.registry.impl.SimpleDataSet;
import org.eclipse.cosmos.dc.common.spi.BindingService;
import org.eclipse.cosmos.dc.common.spi.ComponentEventSource;
import org.eclipse.cosmos.dc.common.spi.ComponentListener;
import org.eclipse.cosmos.dc.common.spi.IWireSource;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.common.spi.IWireTerminal;
import org.eclipse.cosmos.dc.common.spi.InboundContext;
import org.eclipse.cosmos.dc.common.spi.impl.AbstractCollectionContext;
import org.eclipse.cosmos.dc.common.spi.impl.DescriptorNode;
import org.eclipse.cosmos.dc.common.spi.impl.FilterDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.SinkDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.SourceDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.TransformDescriptor;
import org.eclipse.cosmos.dc.mgmt.annotations.CreateManagedRelation;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.mgmt.common.util.ManagementProxy;
import org.eclipse.cosmos.dc.runtime.Runtime;

@ManagedResource(advertise=true, advertisementConsumer="Dispatch-Consumer")
public class InboundDataContext
extends AbstractCollectionContext
implements InboundContext,
IDataCollectionContext,
ComponentListener {
    private Runtime runtime;
    private boolean isInbound = false;
    private IDataSourceService rootSource = null;
    private ContributionManager manager;
    private boolean hasBrokenWire = false;
    private boolean hasCompleteWire = false;
    private ArrayList<IDataSinkService> sinkList = new ArrayList();
    private HashMap<DataSet, IDataSinkService> setList = new HashMap();
    private InboundContext _proxy;

    public void setRootSource(IDataSourceService rootSource) {
        this.rootSource = rootSource;
    }

    public IDataSourceService getRootSource() {
        return this.rootSource;
    }

    @CreateManagedRelation(type="root", namespace="http://www.eclipse.org/xmlns/cosmos/1.0")
    private void setRootSink(IDataSinkService rootSink) {
    }

    public InboundDataContext(Runtime runtime, ContributionManager manager) {
        this.runtime = runtime;
        this.manager = manager;
        this.setOperationalStatus(3);
        this._proxy = (InboundContext)manager.manage((Object)this);
    }

    public void materialize() throws Exception {
        this.resolveContext();
        if (this.isValid()) {
            this.wireContext();
            if (this.hasCompleteWire && this.hasBrokenWire) {
                this.setWired(2);
            } else if (this.hasCompleteWire) {
                this.setWired(1);
            } else {
                this.setWired(0);
            }
        }
        if (this.isValid()) {
            if (this.isFullyWired()) {
                this.setOperationalStatus(0);
            } else if (this.isWired()) {
                this.setOperationalStatus(2);
            } else {
                this.setOperationalStatus(1);
            }
        }
    }

    protected void resolveContext() throws Exception {
        DescriptorNode[] children;
        SourceDescriptor sourceDescriptor = this.rootDescriptor.getSource();
        BindingService bindingService = this.getBindingService(sourceDescriptor);
        if (bindingService == null) {
            this.setValid(false);
            return;
        }
        IDataSourceService root = bindingService.bindSource(sourceDescriptor, sourceDescriptor.getBindingElement());
        this.manager.manage((Object)root);
        this._proxy.setRootSource(root);
        DescriptorNode[] descriptorNodeArray = children = sourceDescriptor.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ManagementProxy proxy;
            DescriptorNode child = descriptorNodeArray[n2];
            if (child instanceof FilterDescriptor) {
                bindingService = this.getBindingService(child);
                IDataFilterService filter = bindingService.bindFilter((FilterDescriptor)child, child.getBindingElement());
                proxy = (ManagementProxy)this.manager.manage((Object)filter);
                this.rootSource.addWireTarget((IDataFilterService)proxy.getProxiedObject());
                this.resolveChildren(child, filter);
            } else if (child instanceof TransformDescriptor) {
                bindingService = this.getBindingService(child);
                IDataTransformService transform = bindingService.bindTransform((TransformDescriptor)child, child.getBindingElement());
                proxy = (ManagementProxy)this.manager.manage((Object)transform);
                this.rootSource.addWireTarget((IDataTransformService)proxy.getProxiedObject());
                this.resolveChildren(child, transform);
            } else if (child instanceof SinkDescriptor) {
                bindingService = this.getBindingService(child);
                IDataSinkService sink = bindingService.bindSink((SinkDescriptor)child, child.getBindingElement());
                proxy = (ManagementProxy)this.manager.manage((Object)sink);
                this.rootSource.addWireTarget((IDataSinkService)proxy.getProxiedObject());
            } else {
                this.setValid(false);
                throw new Exception("Invalid configuration - unexpected descriptor child for inbound Source");
            }
            ++n2;
        }
    }

    protected void resolveChildren(DescriptorNode node, IWireSource source) throws Exception {
        DescriptorNode[] children;
        BindingService bindingService = null;
        DescriptorNode[] descriptorNodeArray = children = node.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ManagementProxy proxy;
            DescriptorNode child = descriptorNodeArray[n2];
            if (child instanceof FilterDescriptor) {
                bindingService = this.getBindingService(child);
                IDataFilterService filter = bindingService.bindFilter((FilterDescriptor)child, child.getBindingElement());
                proxy = (ManagementProxy)this.manager.manage((Object)filter);
                source.addWireTarget((IDataFilterService)proxy.getProxiedObject());
                this.resolveChildren(child, filter);
            } else if (child instanceof TransformDescriptor) {
                bindingService = this.getBindingService(child);
                IDataTransformService transform = bindingService.bindTransform((TransformDescriptor)child, child.getBindingElement());
                proxy = (ManagementProxy)this.manager.manage((Object)transform);
                source.addWireTarget((IDataTransformService)proxy.getProxiedObject());
                this.resolveChildren(child, transform);
            } else if (child instanceof SinkDescriptor) {
                bindingService = this.getBindingService(child);
                IDataSinkService sink = bindingService.bindSink((SinkDescriptor)child, child.getBindingElement());
                proxy = (ManagementProxy)this.manager.manage((Object)sink);
                source.addWireTarget((IDataSinkService)proxy.getProxiedObject());
            } else {
                this.setValid(false);
                throw new Exception("Invalid configuration - unexpected descriptor child for inbound Source");
            }
            ++n2;
        }
    }

    private BindingService getBindingService(DescriptorNode node) throws Exception {
        String namespace = node.getBindingNamespace();
        if (namespace == null) {
            throw new Exception("No Binding specified for Config Element" + node);
        }
        BindingService bindingService = this.runtime.getBindingServiceForNamespace(namespace);
        if (bindingService == null) {
            throw new Exception("No Binding service available for Namespace " + namespace);
        }
        return bindingService;
    }

    protected void wireContext() throws Exception {
        Class[] rootTypes = this.rootSource.getOutputTypes();
        IWireTarget[] targets = this.rootSource.getWireTargets();
        if (targets.length == 0) {
            this.hasCompleteWire = true;
        }
        IWireTarget[] iWireTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IWireTarget target = iWireTargetArray[n2];
            Method targetMethod = this.wireTarget(target, rootTypes);
            if (targetMethod == null) {
                this.hasBrokenWire = true;
            }
            target.setWireMethod(targetMethod);
            if (target instanceof IDataSinkService) {
                this.sinkList.add((IDataSinkService)target);
            }
            ++n2;
        }
        if (this.rootSource instanceof IWireTerminal) {
            ((IWireTerminal)((Object)this.rootSource)).prepare();
        }
        if (this.rootSource instanceof ComponentEventSource) {
            ((ComponentEventSource)((Object)this.rootSource)).addListener(this);
        }
        if (this.hasBrokenWire) {
            this.setWired(2);
        }
    }

    private Method wireTarget(IWireTarget target, Class[] types) {
        Method returnMethod = null;
        if (target instanceof IDataFilterService) {
            Class[] computedTypes = this.computeIntersection(((IDataFilterService)target).getAcceptableTypes(), types);
            returnMethod = ((IDataFilterService)target).getFilterMethod(computedTypes[0]);
            if (target instanceof IWireSource) {
                IWireTarget[] targets = ((IWireSource)((Object)target)).getWireTargets();
                if (targets.length == 0 && returnMethod != null) {
                    this.hasCompleteWire = true;
                }
                IWireTarget[] iWireTargetArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    IWireTarget wireTarget = iWireTargetArray[n2];
                    Method wireMethod = this.wireTarget(wireTarget, computedTypes);
                    if (wireMethod == null) {
                        this.hasBrokenWire = true;
                    }
                    wireTarget.setWireMethod(wireMethod);
                    ++n2;
                }
            }
        } else if (target instanceof IDataTransformService) {
            Class inType = null;
            Class<?> outType = null;
            boolean hasTargets = false;
            Class[] classArray = types;
            int n = types.length;
            int n3 = 0;
            while (n3 < n) {
                Class type = classArray[n3];
                if (target.acceptType(type)) {
                    inType = type;
                    break;
                }
                ++n3;
            }
            if (target instanceof IWireSource) {
                IWireTarget[] targets = ((IWireSource)((Object)target)).getWireTargets();
                if (targets.length > 0) {
                    hasTargets = true;
                }
                IWireTarget[] iWireTargetArray = targets;
                int n4 = targets.length;
                n = 0;
                while (n < n4) {
                    IWireTarget wireTarget = iWireTargetArray[n];
                    Method wireMethod = this.wireTarget(wireTarget, ((IDataTransformService)target).getTransformTypes(inType));
                    wireTarget.setWireMethod(wireMethod);
                    if (wireMethod != null) {
                        outType = wireMethod.getParameterTypes()[0];
                    } else {
                        this.hasBrokenWire = true;
                    }
                    ++n;
                }
            }
            returnMethod = ((IDataTransformService)target).getTransformMethod(outType, inType);
            if (!hasTargets && returnMethod != null) {
                this.hasCompleteWire = true;
            }
        } else if (target instanceof IDataSinkService) {
            Class[] computedTypes = this.computeIntersection(((IDataSinkService)target).getAcceptableTypes(), types);
            if (computedTypes.length > 0) {
                returnMethod = ((IDataSinkService)target).getStoreMethod(computedTypes[0]);
            }
            if (returnMethod == null) {
                this.hasBrokenWire = true;
            } else {
                this.hasCompleteWire = true;
            }
        }
        return returnMethod;
    }

    protected Class[] computeIntersection(Class[] targetClasses, Class[] sourceClasses) {
        ArrayList<Class> result = new ArrayList<Class>();
        Class[] classArray = targetClasses;
        int n = targetClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class target = classArray[n2];
            Class[] classArray2 = sourceClasses;
            int n3 = sourceClasses.length;
            int n4 = 0;
            while (n4 < n3) {
                Class source = classArray2[n4];
                if (source.equals(target)) {
                    result.add(source);
                    System.out.println("Adding " + source.getName());
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new Class[0]);
    }

    public void dispatch() throws Exception {
        if (!this.isValid()) {
            throw new Exception("Context " + this.getName() + " is invalid");
        }
        if ("Unavailable".equals(this.getOperationalStatus())) {
            throw new Exception("Context " + this.getName() + " is unavailable");
        }
        if (this.isInbound) {
            this.rootSource.connect();
            this.rootSource.run();
        }
    }

    public void activate() throws Exception {
        IDataSourceService source = this.getRootSource();
        source.connect();
        if (!this.sinkList.isEmpty()) {
            DataSource ds = source.getDataSource();
            for (IDataSinkService sink : this.sinkList) {
                DimensionSet dims = sink.getDimensionSet();
                String flowName = String.valueOf(ds.getDataSourceType().getName()) + ":" + dims.getName();
                DataFlow flow = this.runtime.getRegistry().getDataFlow(flowName);
                if (flow == null) {
                    flow = new SimpleDataFlow(flowName, ds, dims);
                    this.runtime.getRegistry().registerDataFlow(flow);
                }
                Date start = new Date(System.currentTimeMillis());
                Date stop = new Date(System.currentTimeMillis());
                String dsName = String.valueOf(ds.getName()) + System.currentTimeMillis();
                SimpleDataSet data = new SimpleDataSet(dsName, flow, ds, start, stop);
                this.setList.put(data, sink);
            }
        }
        source.run();
    }

    public void deactivate() throws Exception {
        IDataSourceService source = this.getRootSource();
        source.cancel();
        source.disconnect();
    }

    public void event(int id, Object component) {
        switch (id) {
            case 0: {
                System.out.println("Normal Completion " + component);
                break;
            }
        }
    }

    public void event(int id, Object component, Throwable t) {
        switch (id) {
            case 0: {
                break;
            }
        }
    }

    public void event(int id, Object component, Object parm) {
        switch (id) {
            case 2: {
                if (!(parm instanceof Date)) break;
                for (DataSet ds : this.setList.keySet()) {
                    ds.setStart((Date)parm);
                    try {
                        this.runtime.getRegistry().registerDataSet(ds);
                        this.setList.get(ds).setDataSet(ds);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            case 3: {
                if (!(parm instanceof Date)) break;
                for (DataSet ds : this.setList.keySet()) {
                    ds.setStop((Date)parm);
                    try {
                        this.runtime.getRegistry().updateDataSet(ds);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
        }
    }
}

