/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.IOException;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.birt.report.engine.api.impl.EngineLoggerHandler;

public class EngineLogger {
    private static final String BIRT_NAME_SPACE = "org.eclipse.birt";
    private static EngineLoggerHandler sharedHandler = null;
    private static Logger userLogger = null;
    private static String dirName = null;
    private static Logger fileLogger = null;

    public static void startEngineLogging(Logger logger, String directoryName, Level logLevel) {
        Logger rootLogger = Logger.getLogger(BIRT_NAME_SPACE);
        if (sharedHandler == null) {
            sharedHandler = new EngineLoggerHandler(rootLogger);
            sharedHandler.setLevel(Level.ALL);
            rootLogger.addHandler(sharedHandler);
        }
        if (fileLogger != null) {
            EngineLogger.closeFileLogger(fileLogger);
            fileLogger = null;
        }
        if (logger != null && EngineLogger.isValidLogger(logger)) {
            userLogger = logger;
            sharedHandler.setSharedLogger(userLogger);
        } else {
            if (directoryName != null) {
                dirName = directoryName;
            }
            if (logLevel == null) {
                logLevel = rootLogger.getLevel();
            }
            if (logLevel != Level.OFF && dirName != null) {
                fileLogger = EngineLogger.createFileLogger(dirName);
                sharedHandler.setSharedLogger(fileLogger);
            }
            rootLogger.setLevel(logLevel);
        }
        rootLogger.setUseParentHandlers(false);
    }

    public static boolean isValidLogger(Logger logger) {
        Logger rootLogger = Logger.getLogger(BIRT_NAME_SPACE);
        while (logger != null) {
            if (logger == rootLogger) {
                return false;
            }
            logger = logger.getParent();
        }
        return true;
    }

    public static void stopEngineLogging() {
        Logger rootLogger = Logger.getLogger(BIRT_NAME_SPACE);
        rootLogger.removeHandler(sharedHandler);
        if (sharedHandler != null) {
            sharedHandler.close();
            sharedHandler = null;
        }
        if (fileLogger != null) {
            EngineLogger.closeFileLogger(fileLogger);
            fileLogger = null;
        }
        userLogger = null;
    }

    public static void changeLogLevel(Level newLevel) {
        if (newLevel != null) {
            if (userLogger != null && newLevel != Level.OFF && fileLogger == null && dirName != null && (fileLogger = EngineLogger.createFileLogger(dirName)) != null) {
                sharedHandler.setSharedLogger(fileLogger);
            }
            Logger rootLogger = Logger.getLogger(BIRT_NAME_SPACE);
            rootLogger.setLevel(newLevel);
        }
    }

    private static String generateUniqueLogFileName(String directoryName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String dateTimeString = df.format(new Date());
        if (directoryName == null) {
            directoryName = "";
        } else if (directoryName.length() > 0) {
            directoryName = String.valueOf(directoryName) + System.getProperty("file.separator");
        }
        return new String(String.valueOf(directoryName) + "ReportEngine_" + dateTimeString + ".log");
    }

    private static Logger createFileLogger(String dirName) {
        try {
            FileHandler logFileHandler = new FileHandler(EngineLogger.generateUniqueLogFileName(dirName), true);
            logFileHandler.setFormatter(new SimpleFormatter());
            logFileHandler.setLevel(Level.FINEST);
            Logger logger = Logger.getAnonymousLogger();
            logger.addHandler(logFileHandler);
            return logger;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void closeFileLogger(Logger logger) {
        Handler[] handles = logger.getHandlers();
        if (handles != null) {
            int i = 0;
            while (i < handles.length) {
                handles[i].close();
                ++i;
            }
        }
    }
}

