/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.script.BirtHashMap;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.core.script.CoreJavaScriptWrapper;
import org.eclipse.birt.core.script.IJavascriptWrapper;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.ILinkedResult;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ParameterAttribute;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.DataEngineFactory;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.executor.IPageBreakListener;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ScriptUtil;
import org.eclipse.birt.report.engine.executor.ScriptableParameters;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScriptLibHandle;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

public class ExecutionContext {
    public static final String PROPERTYSEPARATOR = File.pathSeparator;
    private IReportEngine engine;
    private EngineTask task;
    private Logger log;
    private boolean presentationMode = false;
    private boolean factoryMode = true;
    private ScriptContext scriptContext;
    private IDataEngine dataEngine;
    private IReportExecutor executor;
    private TOCBuilder tocBuilder;
    private ReportRunnable runnable;
    private Map configs = new BirtHashMap();
    private Map params = new BirtHashMap();
    private Map persistentBeans = new HashMap();
    private Map transientBeans = new HashMap();
    private ReportDocumentWriter docWriter;
    private Map appContext;
    private IReportContext reportContext;
    private IRenderOption renderOption;
    private Locale locale;
    private IReportDocument reportDoc;
    private IReportContent reportContent;
    private ReportItemDesign design;
    private IContent content;
    private IBaseResultSet[] rsets;
    private Stack reportHandles = new Stack();
    private long totalPage;
    private long pageNumber;
    private List onPrepareErrors = new ArrayList();
    private boolean isCancelled = false;
    private boolean cancelOnError = false;
    private HashMap stringFormatters = new HashMap();
    private HashMap numberFormatters = new HashMap();
    private HashMap dateFormatters = new HashMap();
    private ClassLoader applicationClassLoader;
    private int MAX_ERRORS = 100;
    private IDocArchiveReader dataSource;
    private List pageBreakListeners;
    protected HashMap elementExceptions = new HashMap();
    boolean isExecutingMasterPage = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExecutionContext() {
        this(null);
    }

    public ExecutionContext(EngineTask engineTask) {
        Object scope;
        if (engineTask != null) {
            this.task = engineTask;
            this.engine = this.task.getEngine();
            this.log = this.task.getLogger();
        } else {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.birt.report.engine.executor.ExecutionContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.log = Logger.getLogger(clazz.getName());
        }
        this.locale = Locale.getDefault();
        ScriptableObject rootScope = null;
        if (this.engine != null && (scope = this.engine.getRootScope()) instanceof ScriptableObject) {
            rootScope = (ScriptableObject)scope;
        }
        this.scriptContext = rootScope != null ? new ScriptContext(rootScope) : new ScriptContext();
        Context context = this.scriptContext.getContext();
        try {
            context.setSecurityController(ScriptUtil.createSecurityController());
        }
        catch (Throwable throwable) {}
        context.setLocale(this.locale);
        this.initailizeScriptContext(context, this.scriptContext.getRootScope());
        this.scriptContext.registerBean("report", (Object)new ReportObject());
        this.scriptContext.registerBean("params", (Object)new ScriptableParameters(this.params, this.scriptContext.getScope()));
        this.scriptContext.registerBean("config", (Object)this.configs);
        this.scriptContext.registerBean("currentPage", (Object)new Long(this.pageNumber));
        this.scriptContext.registerBean("totalPage", (Object)new Long(this.totalPage));
        this.scriptContext.registerBean("_jsContext", (Object)this);
        this.scriptContext.eval("function registerGlobal( name, value) { _jsContext.registerGlobalBean(name, value); }");
        this.scriptContext.eval("function unregisterGlobal(name) { _jsContext.unregisterGlobalBean(name); }");
        this.applicationClassLoader = new ApplicationClassLoader(this);
        context.setApplicationClassLoader(this.applicationClassLoader);
    }

    protected void initailizeScriptContext(Context cx, Scriptable scope) {
        this.scriptContext.getContext().setWrapFactory(new WrapFactory(){
            protected IJavascriptWrapper coreWrapper = new CoreJavaScriptWrapper();

            public Object wrap(Context cx, Scriptable scope, Object obj, Class staticType) {
                Object object = this.coreWrapper.wrap(cx, scope, obj, staticType);
                if (object != obj) {
                    return object;
                }
                return super.wrap(cx, scope, obj, staticType);
            }
        });
        new CoreJavaScriptInitializer().initialize(cx, scope);
    }

    public IReportEngine getEngine() {
        return this.engine;
    }

    public void close() {
        this.scriptContext.exit();
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "Failed to close the data source", e);
            }
            this.dataSource = null;
        }
        if (this.dataEngine != null) {
            this.dataEngine.shutdown();
            this.dataEngine = null;
        }
    }

    public void newScope() {
        this.scriptContext.enterScope();
    }

    public void newScope(Object object) {
        Object jsObject = this.scriptContext.javaToJs(object);
        if (jsObject instanceof Scriptable) {
            this.scriptContext.enterScope((Scriptable)jsObject);
        } else {
            this.scriptContext.enterScope();
        }
    }

    public void exitScope() {
        this.scriptContext.exitScope();
    }

    public void registerBeans(Map map) {
        if (map != null) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object keyObj = entry.getKey();
                Object value = entry.getValue();
                if (keyObj == null) continue;
                String key = keyObj.toString();
                this.registerBean(key, value);
            }
        }
    }

    public void registerBean(String name, Object value) {
        this.transientBeans.put(name, value);
        this.scriptContext.registerBean(name, value);
    }

    public void unregisterBean(String name) {
        this.transientBeans.remove(name);
        this.scriptContext.registerBean(name, null);
    }

    public Map getBeans() {
        return this.transientBeans;
    }

    public void registerGlobalBeans(Map map) {
        if (map != null) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object keyObj = entry.getKey();
                Object value = entry.getValue();
                if (keyObj == null || !(value instanceof Serializable)) continue;
                String key = keyObj.toString();
                this.registerGlobalBean(key, (Serializable)value);
            }
        }
    }

    public void registerGlobalBean(String name, Serializable value) {
        this.persistentBeans.put(name, value);
        this.registerInRoot(name, value);
    }

    public void unregisterGlobalBean(String name) {
        this.persistentBeans.remove(name);
        this.registerInRoot(name, null);
    }

    public Map getGlobalBeans() {
        return this.persistentBeans;
    }

    private void registerInRoot(String name, Object value) {
        Scriptable root = this.scriptContext.getRootScope();
        Object sObj = Context.javaToJS((Object)value, (Scriptable)root);
        root.put(name, root, sObj);
    }

    public Object evaluate(String source) {
        return this.evaluate(source, "<inline>", 1);
    }

    public Object evaluate(String expr, String name, int lineNo) {
        if (expr != null) {
            try {
                return this.scriptContext.eval(expr, name, lineNo);
            }
            catch (Throwable e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
                this.addException(new EngineException("Error.ScriptEvaluationError", expr, e));
            }
        }
        return null;
    }

    public Object evaluateCondExpr(IConditionalExpression expr) {
        int operator = expr.getOperator();
        IScriptExpression testExpr = expr.getExpression();
        IScriptExpression v1 = expr.getOperand1();
        IScriptExpression v2 = expr.getOperand2();
        if (testExpr == null) {
            return Boolean.FALSE;
        }
        Object testExprValue = this.evaluate(testExpr.getText());
        if (operator == 0) {
            return testExprValue;
        }
        Object vv1 = null;
        Object vv2 = null;
        if (v1 != null) {
            vv1 = this.evaluate(v1.getText());
        }
        if (v2 != null) {
            vv2 = this.evaluate(v2.getText());
        }
        try {
            return ScriptEvalUtil.evalConditionalExpr((Object)testExprValue, (int)expr.getOperator(), (Object)vv1, (Object)vv2);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
            this.addException(new EngineException("Error.InvalidExpressionError", expr, (Throwable)e));
            return Boolean.FALSE;
        }
    }

    public void execute(String script) {
        if (script != null) {
            this.evaluate(script);
        }
    }

    public void execute(String script, String fileName, int lineNo) {
        if (script != null) {
            this.evaluate(script, fileName, lineNo);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.scriptContext.getContext().setLocale(locale);
    }

    public Report getReport() {
        if (this.runnable != null) {
            return this.runnable.getReportIR();
        }
        return null;
    }

    public void openDataEngine() {
        if (this.dataEngine == null) {
            try {
                this.dataEngine = DataEngineFactory.getInstance().createDataEngine(this);
            }
            catch (BirtException bex) {
                this.addException(bex);
            }
            catch (Exception ex) {
                this.addException(new EngineException(ex.getLocalizedMessage(), ex));
            }
        }
    }

    public IDataEngine getDataEngine() {
        if (this.dataEngine == null) {
            this.openDataEngine();
        }
        return this.dataEngine;
    }

    public void closeDataEngine() {
        if (this.dataEngine != null) {
            this.dataEngine.shutdown();
            this.dataEngine = null;
        }
    }

    public void setParameterValue(String name, Object value) {
        Object parameter = this.params.get(name);
        if (parameter instanceof ParameterAttribute) {
            ((ParameterAttribute)parameter).setValue(value);
        } else {
            this.params.put(name, new ParameterAttribute(value, null));
        }
    }

    public void setParameter(String name, Object value, String displayText) {
        this.params.put(name, new ParameterAttribute(value, displayText));
    }

    public void clearParameters() {
        this.params.clear();
    }

    public Object getParameterValue(String name) {
        Object parameter = this.params.get(name);
        if (parameter != null) {
            return ((ParameterAttribute)parameter).getValue();
        }
        return null;
    }

    public Map getParameterValues() {
        HashMap result = new HashMap();
        Set entries = this.params.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ParameterAttribute parameter = (ParameterAttribute)entry.getValue();
            result.put(entry.getKey(), parameter.getValue());
        }
        return result;
    }

    public Map getParameterDisplayTexts() {
        HashMap<String, String> result = new HashMap<String, String>();
        Set entries = this.params.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            ParameterAttribute value = (ParameterAttribute)entry.getValue();
            result.put(name, value.getDisplayText());
        }
        return result;
    }

    public String getParameterDisplayText(String name) {
        Object parameter = this.params.get(name);
        if (parameter != null) {
            return ((ParameterAttribute)parameter).getDisplayText();
        }
        return null;
    }

    public void setParameterDisplayText(String name, String displayText) {
        Object parameter = this.params.get(name);
        if (parameter != null) {
            ((ParameterAttribute)parameter).setDisplayText(displayText);
        }
    }

    public Map getConfigs() {
        return this.configs;
    }

    public ReportDesignHandle getDesign() {
        return (ReportDesignHandle)this.runnable.getDesignHandle();
    }

    public IReportContent getReportContent() {
        return this.reportContent;
    }

    public void setReportContent(IReportContent content) {
        this.reportContent = content;
        content.getErrors().addAll(this.onPrepareErrors);
    }

    public void loadScript(String fileName) {
        ReportDesignHandle reportDesign = this.getDesign();
        URL url = null;
        if (reportDesign != null) {
            url = reportDesign.findResource(fileName, 2);
        }
        if (url == null) {
            return;
        }
        try {
            InputStream in = url.openStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int size = in.read(buffer);
            while (size != -1) {
                out.write(buffer, 0, size);
                size = in.read(buffer);
            }
            byte[] script = out.toByteArray();
            this.execute(new String(script, "UTF-8"), fileName, 1);
            in.close();
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, "loading external script file " + fileName + " failed.", ex);
            this.addException(new EngineException("Error.ScriptFileLoadError", url.toString(), (Throwable)ex));
        }
    }

    public Scriptable getScope() {
        return this.scriptContext.getScope();
    }

    public Scriptable getSharedScope() {
        return this.scriptContext.getSharedScope();
    }

    ScriptContext getScriptContext() {
        return this.scriptContext;
    }

    public IContent getContent() {
        return this.content;
    }

    public void setContent(IContent content) {
        this.content = content;
    }

    public ReportItemDesign getItemDesign() {
        return this.design;
    }

    public void setItemDesign(ReportItemDesign design) {
        this.design = design;
    }

    public void pushHandle(DesignElementHandle obj) {
        this.reportHandles.push(obj);
    }

    public DesignElementHandle popHandle() {
        return (DesignElementHandle)this.reportHandles.pop();
    }

    public DesignElementHandle getHandle() {
        if (this.reportHandles.empty()) {
            return null;
        }
        return (DesignElementHandle)this.reportHandles.peek();
    }

    public void addException(BirtException ex) {
        ReportDesignHandle handle = this.getDesign();
        if (this.design != null) {
            handle = this.design.getHandle();
        }
        this.addException((DesignElementHandle)handle, ex);
    }

    public void addException(DesignElementHandle element, BirtException ex) {
        ElementExceptionInfo exInfo = (ElementExceptionInfo)this.elementExceptions.get(element);
        if (exInfo == null) {
            exInfo = new ElementExceptionInfo(element);
            if (this.reportContent != null) {
                this.reportContent.getErrors().add(exInfo);
            } else {
                this.onPrepareErrors.add(exInfo);
            }
            this.elementExceptions.put(element, exInfo);
        }
        exInfo.addException(ex);
        if (this.cancelOnError && this.task != null) {
            this.task.cancel();
        }
    }

    public ReportRunnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(IReportRunnable runnable) {
        this.runnable = (ReportRunnable)runnable;
        ReportDesignHandle reportDesign = (ReportDesignHandle)runnable.getDesignHandle();
        IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)reportDesign);
        this.scriptContext.registerBean("design", (Object)element);
    }

    public IRenderOption getRenderOption() {
        return this.renderOption;
    }

    public void setRenderOption(IRenderOption renderOption) {
        this.renderOption = renderOption;
    }

    public String getOutputFormat() {
        if (this.renderOption != null) {
            return this.renderOption.getOutputFormat();
        }
        return "html";
    }

    public Map getAppContext() {
        return this.appContext;
    }

    public void setAppContext(Map appContext) {
        this.appContext = appContext;
    }

    public IReportContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(IReportContext reportContext) {
        this.reportContext = reportContext;
        this.scriptContext.registerBean("reportContext", (Object)reportContext);
    }

    public void setPageNumber(long pageNo) {
        this.pageNumber = pageNo;
        this.scriptContext.registerBean("pageNumber", (Object)new Long(this.pageNumber));
        if (this.totalPage < this.pageNumber) {
            this.setTotalPage(this.pageNumber);
        }
    }

    public void setTotalPage(long totalPage) {
        if (totalPage > this.pageNumber) {
            this.totalPage = totalPage;
            this.scriptContext.registerBean("totalPage", (Object)new Long(totalPage));
            if (this.reportContent instanceof ReportContent) {
                ((ReportContent)this.reportContent).setTotalPage(totalPage);
            }
        }
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public boolean isInFactory() {
        return this.factoryMode;
    }

    public boolean isInPresentation() {
        return this.presentationMode;
    }

    public void setFactoryMode(boolean mode) {
        this.factoryMode = mode;
    }

    public boolean getFactoryMode() {
        return this.factoryMode;
    }

    public void setPresentationMode(boolean mode) {
        this.presentationMode = mode;
    }

    public StringFormatter getStringFormatter(String value) {
        StringFormatter fmt = (StringFormatter)this.stringFormatters.get(value);
        if (fmt == null) {
            fmt = new StringFormatter(value, ULocale.forLocale((Locale)this.locale));
            this.stringFormatters.put(value, fmt);
        }
        return fmt;
    }

    public NumberFormatter getNumberFormatter(String value) {
        NumberFormatter fmt = (NumberFormatter)this.numberFormatters.get(value);
        if (fmt == null) {
            fmt = new NumberFormatter(value, ULocale.forLocale((Locale)this.locale));
            this.numberFormatters.put(value, fmt);
        }
        return fmt;
    }

    public DateFormatter getDateFormatter(String value) {
        DateFormatter fmt = null;
        if (value != null) {
            fmt = (DateFormatter)this.dateFormatters.get(value);
            if (fmt == null) {
                fmt = new DateFormatter(value, ULocale.forLocale((Locale)this.locale));
                this.dateFormatters.put(value, fmt);
            }
            return fmt;
        }
        return new DateFormatter(value, ULocale.forLocale((Locale)this.locale));
    }

    public void setExecutor(IReportExecutor executor) {
        this.executor = executor;
    }

    public IReportExecutor getExecutor() {
        return this.executor;
    }

    public TOCBuilder getTOCBuilder() {
        return this.tocBuilder;
    }

    public void setTOCBuilder(TOCBuilder builder) {
        this.tocBuilder = builder;
    }

    public void setReportDocument(IReportDocument doc) {
        this.reportDoc = doc;
    }

    public IReportDocument getReportDocument() {
        return this.reportDoc;
    }

    public void setReportDocWriter(ReportDocumentWriter docWriter) {
        this.docWriter = docWriter;
    }

    public ReportDocumentWriter getReportDocWriter() {
        return this.docWriter;
    }

    public IHTMLActionHandler getActionHandler() {
        return this.renderOption.getActionHandler();
    }

    public IHTMLImageHandler getImageHandler() {
        return this.renderOption.getImageHandler();
    }

    public ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public boolean isCanceled() {
        return this.isCancelled;
    }

    public void setCancelOnError(boolean cancel) {
        this.cancelOnError = cancel;
    }

    public void setDataSource(IDocArchiveReader dataSource) throws IOException {
        dataSource.open();
        this.dataSource = dataSource;
    }

    public IDocArchiveReader getDataSource() {
        return this.dataSource;
    }

    public IBaseResultSet executeQuery(IBaseResultSet parent, IDataQueryDefinition query, boolean useCache) throws BirtException {
        IDataEngine dataEngine = this.getDataEngine();
        return dataEngine.execute(parent, query, useCache);
    }

    public IBaseResultSet getResultSet() {
        if (this.rsets != null) {
            return this.rsets[0];
        }
        return null;
    }

    public void setResultSet(IBaseResultSet rset) {
        if (this.rsets != null && this.rsets.length == 1 && this.rsets[0] == rset) {
            return;
        }
        this.setResultSets(new IBaseResultSet[]{rset});
    }

    public IBaseResultSet[] getResultSets() {
        return this.rsets;
    }

    public void setResultSets(IBaseResultSet[] rsets) {
        if (this.rsets == rsets) {
            return;
        }
        this.rsets = rsets;
        if (rsets[0] != null) {
            Scriptable scope = this.scriptContext.getRootScope();
            DataAdapterUtil.registerJSObject((Scriptable)scope, (ILinkedResult)new ResultIteratorTree(rsets[0]));
        }
    }

    public boolean hasErrors() {
        return !this.elementExceptions.isEmpty();
    }

    public List getErrors() {
        List errors = this.getAllErrors();
        if (errors.size() > this.MAX_ERRORS) {
            errors = errors.subList(0, this.MAX_ERRORS - 1);
        }
        return errors;
    }

    public List getAllErrors() {
        ArrayList errors = new ArrayList();
        Iterator entries = this.elementExceptions.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ArrayList elementExceptions = ((ElementExceptionInfo)entry.getValue()).getErrorList();
            errors.addAll(elementExceptions);
        }
        return errors;
    }

    public int getMaxErrors() {
        return this.MAX_ERRORS;
    }

    public void setMaxErrors(int maxErrors) {
        this.MAX_ERRORS = maxErrors;
    }

    public void setExecutingMasterPage(boolean isExecutingMasterPage) {
        this.isExecutingMasterPage = isExecutingMasterPage;
    }

    public boolean isExecutingMasterPage() {
        return this.isExecutingMasterPage;
    }

    public void addPageBreakListener(IPageBreakListener listener) {
        if (this.pageBreakListeners == null) {
            this.pageBreakListeners = new ArrayList();
        }
        this.pageBreakListeners.add(listener);
    }

    public void firePageBreakEvent() {
        if (this.pageBreakListeners != null) {
            int i = 0;
            while (i < this.pageBreakListeners.size()) {
                ((IPageBreakListener)this.pageBreakListeners.get(i)).onPageBreak();
                ++i;
            }
        }
    }

    public void removePageBreakListener(IPageBreakListener listener) {
        if (this.pageBreakListeners != null) {
            this.pageBreakListeners.remove(listener);
        }
    }

    public IEngineTask getEngineTask() {
        return this.task;
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    private static class ApplicationClassLoader
    extends ClassLoader {
        private static String[] classPathes = new String[]{"webapplication.projectclasspath", "user.projectclasspath", "workspace.projectclasspath"};
        private ExecutionContext context = null;
        private ClassLoader loader = null;

        public ApplicationClassLoader(ExecutionContext context) {
            this.context = context;
        }

        public Class loadClass(String className) throws ClassNotFoundException {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.loader == null) {
                    this.createWrappedClassLoaders();
                }
                return this.loader.loadClass(className);
            }
        }

        public URL getResource(String name) {
            URL url;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.ExecutionContext$ApplicationClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((url = clazz.getClassLoader().getResource(name)) == null) {
                if (this.loader == null) {
                    this.createWrappedClassLoaders();
                }
                return this.loader.getResource(name);
            }
            return null;
        }

        protected void createWrappedClassLoaders() {
            ClassLoader root = this.getAppClassLoader();
            if (root == null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.birt.report.engine.executor.ExecutionContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                root = clazz.getClassLoader();
            }
            this.loader = this.createClassLoaderFromProperty(root);
            this.loader = this.createClassLoaderFromDesign(this.loader);
        }

        protected ClassLoader createClassLoaderFromProperty(ClassLoader parent) {
            EngineConfig config = this.context.getEngine().getConfig();
            ArrayList<URL> urls = new ArrayList<URL>();
            int i = 0;
            while (i < classPathes.length) {
                String[] jars;
                Object propValue;
                String classPath = null;
                if (config != null && (propValue = config.getProperty(classPathes[i])) instanceof String) {
                    classPath = (String)propValue;
                }
                if (classPath == null) {
                    classPath = System.getProperty(classPathes[i]);
                }
                if (classPath != null && classPath.length() != 0 && (jars = classPath.split(PROPERTYSEPARATOR, -1)) != null && jars.length != 0) {
                    int j = 0;
                    while (j < jars.length) {
                        File file = new File(jars[j]);
                        try {
                            urls.add(file.toURL());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (urls.size() != 0) {
                return new URLClassLoader(urls.toArray(new URL[0]), parent);
            }
            return parent;
        }

        protected ClassLoader getAppClassLoader() {
            Object appLoader;
            Map appContext = this.context.getAppContext();
            if (appContext != null && (appLoader = appContext.get("PARENT_CLASSLOADER")) instanceof ClassLoader) {
                return (ClassLoader)appLoader;
            }
            return null;
        }

        protected ClassLoader createClassLoaderFromDesign(ClassLoader parent) {
            ReportRunnable runnable = this.context.getRunnable();
            if (runnable != null) {
                ModuleHandle module = (ModuleHandle)runnable.getDesignHandle();
                ArrayList<URL> urls = new ArrayList<URL>();
                Iterator iter = module.scriptLibsIterator();
                while (iter.hasNext()) {
                    ScriptLibHandle lib = (ScriptLibHandle)iter.next();
                    String libPath = lib.getName();
                    URL url = module.findResource(libPath, 2);
                    if (url == null) continue;
                    urls.add(url);
                }
                if (urls.size() != 0) {
                    URL[] jarUrls = urls.toArray(new URL[0]);
                    return new URLClassLoader(jarUrls, parent);
                }
            }
            return parent;
        }
    }

    public class ElementExceptionInfo {
        DesignElementHandle element;
        ArrayList exList = new ArrayList();
        ArrayList countList = new ArrayList();

        public ElementExceptionInfo(DesignElementHandle element) {
            this.element = element;
        }

        public void addException(BirtException e) {
            int i = 0;
            while (i < this.exList.size()) {
                BirtException err = (BirtException)((Object)this.exList.get(i));
                if (e.getErrorCode() != null && e.getErrorCode().equals(err.getErrorCode()) && e.getLocalizedMessage() != null && e.getLocalizedMessage().equals(err.getLocalizedMessage())) {
                    this.countList.set(i, new Integer((Integer)this.countList.get(i) + 1));
                    return;
                }
                ++i;
            }
            this.exList.add(e);
            this.countList.add(new Integer(1));
        }

        public String getType() {
            if (this.element == null) {
                return "report";
            }
            return this.element.getDefn().getName();
        }

        public String getName() {
            if (this.element == null) {
                return "report";
            }
            return this.element.getName();
        }

        public String getID() {
            if (this.element == null) {
                return null;
            }
            return String.valueOf(this.element.getID());
        }

        public ArrayList getErrorList() {
            return this.exList;
        }

        public ArrayList getCountList() {
            return this.countList;
        }
    }

    private class ReportObject {
        private ReportObject() {
        }

        public Object getDesign() {
            return ExecutionContext.this.scriptContext.eval("design");
        }

        public Object getDocument() {
            return ExecutionContext.this.reportDoc;
        }

        public Map getParams() {
            return ExecutionContext.this.params;
        }

        public Object getDataSets() {
            return ExecutionContext.this.scriptContext.eval("design.dataSets");
        }

        public Object getDataSources() {
            return ExecutionContext.this.scriptContext.eval("design.dataSources");
        }

        public Map getConfig() {
            return ExecutionContext.this.configs;
        }

        public Object getReportContext() {
            return ExecutionContext.this.reportContext;
        }
    }

    private class ResultIteratorTree
    implements ILinkedResult {
        IBaseResultSet currentRset;
        int resultType = -1;

        public ResultIteratorTree(IBaseResultSet rset) {
            this.currentRset = rset;
            if (rset instanceof IQueryResultSet) {
                this.resultType = 2;
            } else if (rset instanceof ICubeResultSet) {
                this.resultType = 1;
            }
        }

        public ILinkedResult getParent() {
            return new ResultIteratorTree(this.currentRset.getParent());
        }

        public Object getCurrentResult() {
            if (this.resultType == 2) {
                return ((IQueryResultSet)this.currentRset).getResultIterator();
            }
            if (this.resultType == 1) {
                return ((ICubeResultSet)this.currentRset).getCubeCursor();
            }
            return null;
        }

        public int getCurrentResultType() {
            return this.resultType;
        }
    }
}

