/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemGeneration;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.internal.RowSet;
import org.eclipse.birt.report.engine.extension.internal.SingleRowSet;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;

public class ExtendedGenerateExecutor
extends QueryItemExecutor {
    IReportItemGeneration itemGeneration;
    IBaseResultSet[] rsets;

    public ExtendedGenerateExecutor(ExecutorManager manager, IReportItemGeneration itemGeneration) {
        super(manager, -1);
        this.itemGeneration = itemGeneration;
    }

    public void close() {
        this.closeQueries();
        super.close();
    }

    public IContent execute() {
        ExtendedItemDesign extDesign = (ExtendedItemDesign)this.design;
        IForeignContent extContent = this.report.createForeignContent();
        this.setContent(extContent);
        this.executeQueries();
        this.initializeContent(extDesign, extContent);
        this.processAction(extDesign, extContent);
        this.processBookmark(extDesign, extContent);
        this.processStyle(extDesign, extContent);
        this.processVisibility(extDesign, extContent);
        this.generateContent(extDesign, extContent);
        return extContent;
    }

    protected void generateContent(ExtendedItemDesign item, IForeignContent content) {
        ExtendedItemHandle handle = (ExtendedItemHandle)item.getHandle();
        String name = item.getName();
        byte[] generationStatus = null;
        if (this.itemGeneration != null) {
            this.itemGeneration.setModelObject(handle);
            this.itemGeneration.setApplicationClassLoader(this.context.getApplicationClassLoader());
            this.itemGeneration.setScriptContext(this.context.getReportContext());
            IBaseQueryDefinition[] queries = (IBaseQueryDefinition[])item.getQueries();
            this.itemGeneration.setReportQueries(queries);
            try {
                if (this.rsets != null) {
                    IRowSet[] rowSets = new IRowSet[this.rsets.length];
                    int i = 0;
                    while (i < this.rsets.length) {
                        IBaseResultSet rset = this.rsets[i];
                        rowSets[i] = rset != null && rset.getType() == 0 ? new RowSet(this.context, (IQueryResultSet)rset) : null;
                        ++i;
                    }
                    this.itemGeneration.onRowSets(rowSets);
                } else {
                    IBaseResultSet prset = this.getParentResultSet();
                    if (prset instanceof IQueryResultSet) {
                        IRowSet[] rowSets = new IRowSet[]{new SingleRowSet(this.context, (IQueryResultSet)prset)};
                        this.itemGeneration.onRowSets(rowSets);
                    }
                }
                if (this.itemGeneration.needSerialization()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    this.itemGeneration.serialize(out);
                    generationStatus = out.toByteArray();
                }
                this.itemGeneration.finish();
            }
            catch (BirtException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.context.addException(new EngineException("Error.ExtendedItemGenerationError", String.valueOf(handle.getExtensionName()) + (name != null ? " " + name : ""), (Throwable)ex));
            }
        }
        content.setRawType("object/external");
        content.setRawValue(generationStatus);
    }

    protected static byte[] readContent(InputStream in) {
        BufferedInputStream bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int readSize = 0;
        try {
            readSize = bin.read(buffer);
            while (readSize != -1) {
                out.write(buffer, 0, readSize);
                readSize = bin.read(buffer);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return out.toByteArray();
    }

    protected void executeQueries() {
        DesignElementHandle elementHandle;
        ExtendedItemDesign extItem = (ExtendedItemDesign)this.design;
        IDataEngine dataEngine = this.context.getDataEngine();
        IBaseResultSet parent = this.getParentResultSet();
        boolean useCache = false;
        IDataQueryDefinition[] queries = extItem.getQueries();
        if (queries == null && (elementHandle = this.design.getHandle()) instanceof ReportElementHandle) {
            queries = this.report.getDesign().getQueryByReportHandle((ReportElementHandle)elementHandle);
            useCache = true;
        }
        if (queries != null) {
            this.rsets = new IBaseResultSet[queries.length];
            int i = 0;
            while (i < this.rsets.length) {
                this.rsets[i] = dataEngine.execute(parent, queries[i], useCache);
                ++i;
            }
            this.context.setResultSets(this.rsets);
        }
    }

    protected void closeQueries() {
        if (this.rsets != null) {
            int i = 0;
            while (i < this.rsets.length) {
                if (this.rsets[i] != null) {
                    this.rsets[i].close();
                }
                ++i;
            }
        }
        this.rsets = null;
    }
}

