/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.net.URL;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public abstract class StyledItemExecutor
extends ReportItemExecutor {
    private ExpressionUtil expressionUtil = new ExpressionUtil();

    protected StyledItemExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    protected void processStyle(ReportItemDesign design, IContent content) {
        StyleDeclaration inlineStyle = this.createHighlightStyle(design.getHighlight());
        content.setInlineStyle(inlineStyle);
    }

    protected void processColumnStyle(ColumnDesign columnDesign, IColumn column) {
        StyleDeclaration inlineStyle = this.createHighlightStyle(columnDesign.getHighlight());
        column.setInlineStyle(inlineStyle);
    }

    private StyleDeclaration createHighlightStyle(HighlightDesign highlight) {
        if (highlight == null) {
            return null;
        }
        StyleDeclaration style = null;
        int i = 0;
        while (i < highlight.getRuleCount()) {
            HighlightRuleDesign rule = highlight.getRule(i);
            if (rule != null) {
                Object value = null;
                if (rule.getConditionExpr() != null) {
                    value = this.evaluate(rule.getConditionExpr());
                } else {
                    IConditionalExpression newExpression = this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2());
                    value = this.evaluate(newExpression);
                }
                if (value != null && value instanceof Boolean && ((Boolean)value).booleanValue()) {
                    StyleDeclaration highlightStyle = new StyleDeclaration((StyleDeclaration)rule.getStyle());
                    if (style != null) {
                        style.setProperties(highlightStyle);
                    } else {
                        style = highlightStyle;
                    }
                }
            }
            ++i;
        }
        if (style != null) {
            this.processBackgroundImage(style);
        }
        return style;
    }

    protected void processMappingValue(StyledElementDesign item, IDataContent dataObj) {
        MapDesign map = item.getMap();
        if (map != null) {
            int i = 0;
            while (i < map.getRuleCount()) {
                MapRuleDesign rule = map.getRule(i);
                if (rule != null) {
                    Object value = null;
                    if (rule.getConditionExpr() != null) {
                        value = this.evaluate(rule.getConditionExpr());
                    } else {
                        IConditionalExpression newExpression = this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2());
                        value = this.evaluate(newExpression);
                    }
                    if (value != null && value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        dataObj.setLabelText(rule.getDisplayText());
                        dataObj.setLabelKey(rule.getDisplayKey());
                    }
                }
                ++i;
            }
        }
    }

    protected void processBackgroundImage(IStyle style) {
        URL url;
        if (style == null) {
            return;
        }
        String image = style.getBackgroundImage();
        if (image == null) {
            return;
        }
        ReportDesignHandle reportDesign = this.context.getDesign();
        if (reportDesign != null && (url = reportDesign.findResource(image, 1)) != null) {
            style.setBackgroundImage(url.toExternalForm());
        }
    }
}

