/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.buffermgr;

public class Cell {
    static final Cell EMPTY_CELL;
    public static final int CELL_EMPTY = 0;
    public static final int CELL_USED = 1;
    public static final int CELL_SPANED = 2;
    int status;
    int rowId;
    int colId;
    int rowSpan = 1;
    int colSpan = 1;
    Object content;
    Cell cell;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.buffermgr.Cell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        EMPTY_CELL = new Cell(0);
    }

    static Cell createCell(int rowId, int colId, int rowSpan, int colSpan, Content content) {
        Cell cell = new Cell(1);
        cell.rowId = rowId;
        cell.colId = colId;
        cell.rowSpan = rowSpan;
        cell.colSpan = colSpan;
        cell.content = content;
        return cell;
    }

    static Cell createSpanCell(int rowId, int colId, Cell cell) {
        if (!$assertionsDisabled && cell.status != 1) {
            throw new AssertionError();
        }
        Cell span = new Cell(2);
        span.rowId = rowId;
        span.colId = colId;
        span.content = cell;
        return span;
    }

    private Cell(int status) {
        this.status = status;
    }

    Cell getCell() {
        if (this.status == 2) {
            return (Cell)this.content;
        }
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public Content getContent() {
        Cell cell = this.getCell();
        return (Content)cell.content;
    }

    public int getRowId() {
        return this.rowId;
    }

    public int getColId() {
        return this.colId;
    }

    public int getLeftRowSpan() {
        Cell cell;
        if (this.status == 1) {
            return this.rowSpan;
        }
        if (this.status == 2 && (cell = this.getCell()) != null) {
            int originalRowSpan = cell.getRowSpan();
            if (originalRowSpan > 0) {
                return originalRowSpan + cell.getRowId() - this.rowId;
            }
            return originalRowSpan;
        }
        return this.rowSpan;
    }

    public int getRowSpan() {
        Cell cell;
        if (this.status == 1) {
            return this.rowSpan;
        }
        if (this.status == 2 && (cell = this.getCell()) != null) {
            int originalRowSpan = cell.getRowSpan();
            if (originalRowSpan > 0) {
                return originalRowSpan + cell.getRowId() - this.rowId;
            }
            return originalRowSpan;
        }
        return this.rowSpan;
    }

    public int getColSpan() {
        Cell cell;
        if (this.status == 1) {
            return this.colSpan;
        }
        if (this.status == 2 && (cell = this.getCell()) != null) {
            return cell.getColSpan();
        }
        return this.colSpan;
    }

    public static interface Content {
        public boolean isEmpty();

        public void reset();
    }
}

