/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;

public class HTMLListLM
extends HTMLBlockStackingLM {
    boolean isFirstLayout;

    public HTMLListLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 6;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        super.initialize(parent, content, executor, emitter);
        this.isFirstLayout = true;
    }

    protected void repeatHeader() {
        IListBandContent header;
        IListContent list;
        if (!this.isFirstLayout && (list = (IListContent)this.content).isHeaderRepeat() && (header = list.getHeader()) != null) {
            boolean pageBreak = this.context.allowPageBreak();
            boolean isEmpty = this.context.isPageEmpty();
            this.context.setPageEmpty(true);
            this.context.setAllowPageBreak(pageBreak);
            this.engine.layout((ILayoutManager)this, header, this.emitter);
            this.context.setAllowPageBreak(pageBreak);
            this.context.setPageEmpty(isEmpty);
            this.context.continueContent(null);
        }
        this.isFirstLayout = false;
    }

    protected boolean layoutChildren() {
        this.repeatHeader();
        boolean hasNext = super.layoutChildren();
        return hasNext;
    }
}

