/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.ChartEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.MultipleFill;

public class EventObjectCache {
    private transient Hashtable _htEvents = new Hashtable();
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/event");
    static /* synthetic */ Class class$0;

    public final ChartEvent getEventObject(Object oSource, Class cType) {
        ChartEvent event = (ChartEvent)this._htEvents.get(cType);
        if (event == null) {
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Constructor co = cType.getConstructor(classArray);
                event = (ChartEvent)co.newInstance(oSource);
                this._htEvents.put(cType, event);
            }
            catch (NoSuchMethodException nsmex) {
                logger.log(nsmex);
            }
            catch (InvocationTargetException itex) {
                logger.log(itex);
            }
            catch (IllegalAccessException iaex) {
                logger.log(iaex);
            }
            catch (InstantiationException iex) {
                logger.log(iex);
            }
        } else {
            event.setSourceObject(oSource);
            event.reset();
        }
        return event;
    }

    protected final boolean validateLineAttributes(Object oSource, LineAttributes lia) throws ChartException {
        if (!lia.isSetStyle() || !lia.isSetThickness()) {
            return false;
        }
        if (!lia.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.unset.line.visibility", new Object[]{oSource}, Messages.getResourceBundle());
        }
        return lia.isVisible();
    }

    protected final Object validateEdgeColor(ColorDefinition cdEdge, Fill fBackground, IDisplayServer ids) {
        Object cFG = null;
        if (cdEdge == null) {
            if (!(fBackground instanceof ColorDefinition) || ((ColorDefinition)fBackground).isSetTransparency() && ((ColorDefinition)fBackground).getTransparency() == 0) {
                return null;
            }
            cFG = ids.getColor(((ColorDefinition)fBackground).darker());
        } else {
            cFG = ids.getColor(cdEdge);
        }
        return cFG;
    }

    protected final boolean isFullTransparent(Fill fill) {
        if (fill == null) {
            return true;
        }
        if (fill instanceof ColorDefinition) {
            ColorDefinition cd = (ColorDefinition)fill;
            return cd.isSetTransparency() && cd.getTransparency() == 0;
        }
        if (fill instanceof Gradient) {
            Gradient g = (Gradient)fill;
            return g.isSetTransparency() && g.getTransparency() == 0;
        }
        return false;
    }

    protected final Fill validateMultipleFill(Fill fill) {
        if (!(fill instanceof MultipleFill)) {
            return fill;
        }
        if (((MultipleFill)fill).getFills().size() > 0) {
            return this.validateMultipleFill((Fill)((MultipleFill)fill).getFills().get(0));
        }
        return null;
    }
}

