/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.sun50.fastxpath.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.IFastXPathEngine;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.sun50.fastxpath.axes.EPredicatedNodeTest;

public class CompilerContext
implements ICompilerContext {
    protected StringBuffer sb = new StringBuffer(" ");
    protected ArrayList nameStack = new ArrayList();
    protected ArrayList returnValueNameStack = new ArrayList();
    protected HashMap objNameMap = new HashMap();
    protected FastXPathContext runtimeContext;
    protected int maxStackSize = 0;
    protected int stackSize = 0;
    protected int lastStackSize = 0;
    protected int lastPredicateMarker = 0;
    protected ArrayList expressionStack = new ArrayList();
    protected IFastXPathEngine fastXPathEngine;
    protected int predicateDepth = 0;

    public CompilerContext(Object object, FastXPathContext fastXPathContext, IFastXPathEngine iFastXPathEngine) {
        this.runtimeContext = fastXPathContext;
        this.runtimeContext.getBindingMetaData().getClassMapping(object);
        this.fastXPathEngine = iFastXPathEngine;
    }

    public IExpression getPreviousExpresion() {
        if (this.expressionStack.size() > 0) {
            return (IExpression)this.expressionStack.get(0);
        }
        return null;
    }

    public StringBuffer getSb() {
        if (this.sb.indexOf("$*$*$*$* ") == -1) {
            this.sb.insert(this.lastPredicateMarker, "$*$*$*$* ");
        }
        if (this.sb.indexOf("$*$*$*$* ") + "$*$*$*$* ".length() == this.sb.length() && !this.nameStackToBuffer(this.sb, this.returnValueNameStack)) {
            this.sb.append(" obj");
        }
        return this.sb;
    }

    public void enterPredicate() {
        if (this.predicateDepth++ == 0) {
            this.returnValueNameStack = new ArrayList();
            this.returnValueNameStack.addAll(this.nameStack);
        }
    }

    public void exitPredicate() {
        --this.predicateDepth;
        this.lastPredicateMarker = this.sb.length();
    }

    public String getReturnExpression() {
        return this.sb.substring(this.lastPredicateMarker);
    }

    public void in(IExpression iExpression) {
        this.expressionStack.add(0, iExpression);
        if (!(iExpression instanceof EPredicatedNodeTest)) {
            return;
        }
        if (++this.stackSize > this.maxStackSize) {
            this.maxStackSize = this.stackSize;
        }
        if (this.stackSize < this.lastStackSize) {
            this.maxStackSize = this.stackSize;
        }
        this.lastStackSize = this.stackSize;
    }

    public void out() {
        Object object;
        if (this.expressionStack.size() > 0 && !((object = (IExpression)this.expressionStack.remove(0)) instanceof EPredicatedNodeTest)) {
            return;
        }
        if (this.stackSize-- == this.maxStackSize) {
            this.nameStackToBuffer(this.sb, this.nameStack);
        }
        if (this.nameStack.size() > 1) {
            object = (String)this.nameStack.get(this.nameStack.size() - 1);
            try {
                Double.parseDouble((String)object);
                this.nameStack.remove(this.nameStack.size() - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.nameStack.remove(this.nameStack.size() - 1);
        }
    }

    protected boolean nameStackToBuffer(StringBuffer stringBuffer, ArrayList arrayList) {
        if (arrayList.size() <= 1) {
            return false;
        }
        for (int i = 1; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string.equals("FUNC_LAST_OBSERVED")) {
                stringBuffer.append(".get( ");
                for (int j = 1; j < i; ++j) {
                    this.appendGetter2((String)arrayList.get(j));
                }
                stringBuffer.append(".size() -1)");
                arrayList.remove(i--);
                continue;
            }
            try {
                double d = Double.parseDouble(string);
                int n = (int)d;
                stringBuffer.append(".get(" + n + ")");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.appendGetter2(string, i);
            }
        }
        return true;
    }

    public void appendGetter2(String string) {
        if (string.equals("")) {
            return;
        }
        String string2 = string.substring(0, 1).toUpperCase();
        this.sb.append(" .get" + string2 + string.substring(1, string.length()) + "()");
    }

    public void appendGetter2(String string, int n) {
        if (string.equals("")) {
            return;
        }
        String string2 = string.substring(0, 1).toUpperCase();
        if (n > 1) {
            this.sb.append(".get" + string2 + string.substring(1, string.length()) + "()");
        } else {
            this.sb.append(" .get" + string2 + string.substring(1, string.length()) + "()");
        }
    }

    public void addName(String string) {
        this.nameStack.add(string);
    }

    public void append(String string) {
        if (string.equals(" ) ") && this.sb.indexOf(" ( ") == this.sb.length() - 3) {
            int n = this.sb.length();
            this.sb.delete(n - 3, n - 1);
        } else {
            this.sb.append(string);
        }
    }

    public IFastXPathEngine getFastXPathEngine() {
        return this.fastXPathEngine;
    }

    public FastXPathContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public ICompilerContext setRuntimeContext(FastXPathContext fastXPathContext, Object object) {
        this.runtimeContext = fastXPathContext;
        fastXPathContext.getBindingMetaData().getClassMapping(object);
        return this;
    }

    public int getPredicateDepth() {
        return this.predicateDepth;
    }
}

